/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica.painter;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.painter.Cacheable;
import de.javasoft.plaf.synthetica.painter.SyntheticaAddonsPainter;
import de.javasoft.plaf.synthetica.util.OS;
import de.javasoft.plaf.synthetica.util.Synthetica2DUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.Window;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.synth.SynthContext;

public class SyntheticaComponentPainter
implements Cacheable {
    private Object antialiasing_old;
    private Object strokeControl_old;
    private AffineTransform at_old;
    private Paint paint_old;
    private Stroke stroke_old;
    private static final boolean OS_X_QUARTZ_ENABLED = SyntheticaLookAndFeel.isSystemPropertySet("apple.awt.graphics.UseQuartz");
    private static final String SYNTHETICA_BACKGROUND = "Synthetica.background";
    private static final String SYNTHETICA_BACKGROUND_ALPHA = "Synthetica.background.alpha";
    private static final boolean RESPECT_PARENT_BACKGROUND = SyntheticaLookAndFeel.getBoolean("Synthetica.background.respectParent", null, false);
    protected static HashMap<String, SyntheticaComponentPainter> instances = new HashMap();

    protected static SyntheticaComponentPainter getInstance(SynthContext sc, Class<?> syntheticaPainter, String customPainterUIKey) {
        SyntheticaComponentPainter instance = null;
        Object customPainter = sc == null ? UIManager.get(customPainterUIKey) : SyntheticaLookAndFeel.get(customPainterUIKey, sc.getComponent());
        try {
            if (customPainter == null && syntheticaPainter != null) {
                instance = (SyntheticaComponentPainter)syntheticaPainter.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            } else if (customPainter == null) {
                String simpleClassName = customPainterUIKey.substring(customPainterUIKey.lastIndexOf(46) + 1);
                String packageName = SyntheticaAddonsPainter.getPackageName(customPainterUIKey);
                instance = packageName != null ? (SyntheticaComponentPainter)Class.forName(String.valueOf(packageName) + "." + simpleClassName).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]) : (SyntheticaComponentPainter)Class.forName(String.valueOf(SyntheticaComponentPainter.class.getPackage().getName()) + "." + simpleClassName).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            } else if (customPainter instanceof SyntheticaComponentPainter) {
                instance = (SyntheticaComponentPainter)customPainter;
            } else if (customPainter instanceof String) {
                instance = (SyntheticaComponentPainter)Class.forName((String)customPainter).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        instances.put(instance.getClass().getName(), instance);
        return instance;
    }

    protected static String getPainterClassName(SynthContext sc, Class<?> syntheticaPainter, String customPainterUIKey) {
        Object customPainter;
        Object object = customPainter = sc == null ? UIManager.get(customPainterUIKey) : SyntheticaLookAndFeel.get(customPainterUIKey, sc.getComponent());
        if (customPainter == null) {
            return syntheticaPainter.getName();
        }
        if (customPainter instanceof SyntheticaComponentPainter) {
            return customPainter.getClass().getName();
        }
        return (String)customPainter;
    }

    protected String resolveImagePath(String key, Component c) {
        return SyntheticaLookAndFeel.resolveImagePath(key, c);
    }

    protected Insets getImageInsets(String key, Component c) {
        return SyntheticaLookAndFeel.getInsets(key, c, false, false);
    }

    protected Insets getImageInsets(String key, Component c, Insets defaultValue) {
        return SyntheticaLookAndFeel.getInsets(key, c, defaultValue, false);
    }

    protected Graphics2D prepareGraphics2D(SynthContext sc, Graphics g, int x, int y, boolean antiAlias, boolean translateXY, BasicStroke stroke) {
        Graphics2D g2 = (Graphics2D)g;
        this.antialiasing_old = g2.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        this.strokeControl_old = g2.getRenderingHint(RenderingHints.KEY_STROKE_CONTROL);
        this.at_old = g2.getTransform();
        this.paint_old = g2.getPaint();
        this.stroke_old = g2.getStroke();
        if (antiAlias) {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        if (stroke == null) {
            stroke = this.createStroke(sc);
        }
        g2.setStroke(stroke);
        if (translateXY) {
            double cx = (float)x + stroke.getLineWidth() / 2.0f;
            double cy = (float)y + stroke.getLineWidth() / 2.0f;
            if (OS.getCurrentOS() == OS.Mac && OS_X_QUARTZ_ENABLED) {
                cx = Math.round(cx - 0.5);
                cy = Math.round(cy - 0.5);
            }
            g2.translate(cx, cy);
        }
        return g2;
    }

    protected Graphics2D prepareGraphics2D(SynthContext sc, Graphics g, int x, int y, boolean antiAlias) {
        return this.prepareGraphics2D(sc, g, x, y, antiAlias, true, null);
    }

    protected Graphics2D prepareGraphics2D(SynthContext sc, Graphics g, int x, int y, boolean antiAlias, boolean translateXY) {
        return this.prepareGraphics2D(sc, g, x, y, antiAlias, translateXY, null);
    }

    protected Graphics2D prepareGraphics2D(SynthContext sc, Graphics g, int x, int y, int w, int h, BasicStroke stroke) {
        return this.prepareGraphics2D(sc, g, x, y, true, true, stroke);
    }

    protected Graphics2D prepareGraphics2D(SynthContext sc, Graphics g, int x, int y, int w, int h, boolean respectStrokeWidth) {
        return this.prepareGraphics2D(sc, g, x, y, true, true, null);
    }

    protected void restoreGraphics2D(Graphics2D g2) {
        g2.setStroke(this.stroke_old);
        g2.setPaint(this.paint_old);
        g2.setTransform(this.at_old);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, this.antialiasing_old);
        g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, this.strokeControl_old);
    }

    protected float getScale() {
        return SyntheticaLookAndFeel.getInstance().getScaleFactor();
    }

    protected BasicStroke createStroke(SynthContext sc) {
        return new BasicStroke(this.getScale());
    }

    float scaleArc(float arc, float size, float w, float h) {
        float length = Math.min(w, h);
        arc = length < size * this.getScale() ? length - (size - arc) / size * length : this.scaleArc(arc);
        return arc;
    }

    protected float scaleArc(float arc) {
        return arc * this.getScale();
    }

    protected float calcRelativeArc(Graphics2D g2, float arc, float offset) {
        float sw = ((BasicStroke)g2.getStroke()).getLineWidth();
        return arc + sw * offset;
    }

    protected float calcRelativePos(Graphics2D g2, float pos, float offset) {
        float sw = ((BasicStroke)g2.getStroke()).getLineWidth();
        return pos + sw * offset;
    }

    protected float calcRelativeGradientPos(Graphics2D g2, float pos, float offset) {
        return this.calcRelativePos(g2, pos, offset) - this.getScale() / 2.0f;
    }

    protected static float calcRelativeLength(Graphics2D g2, float length, float offset) {
        float sw = ((BasicStroke)g2.getStroke()).getLineWidth();
        return length + offset * sw - sw;
    }

    protected static Shape subtractStroke(Graphics2D g2, Shape s) {
        if (!SyntheticaLookAndFeel.getBoolean("Synthetica.2D.subtractStrokeEnabled", null)) {
            return s;
        }
        Area strokeArea = new Area(((BasicStroke)g2.getStroke()).createStrokedShape(s));
        Area shapeArea = new Area(s);
        shapeArea.subtract(strokeArea);
        return shapeArea;
    }

    public static Color getSyntheticaBackgroundColor(JComponent c) {
        int bgAlpha;
        Color background;
        Color color = null;
        Color color2 = RESPECT_PARENT_BACKGROUND ? c.getBackground() : (background = c.isBackgroundSet() ? c.getBackground() : null);
        if (background != null && !(background instanceof ColorUIResource)) {
            color = background;
        }
        color = SyntheticaLookAndFeel.getClientProperty(SYNTHETICA_BACKGROUND, c, color);
        float alpha = (float)SyntheticaLookAndFeel.getInt(SYNTHETICA_BACKGROUND_ALPHA, (Component)c, 10) / 100.0f;
        alpha = SyntheticaLookAndFeel.getClientProperty(SYNTHETICA_BACKGROUND_ALPHA, c, Float.valueOf(alpha)).floatValue();
        int n = bgAlpha = color == null ? 255 : color.getAlpha();
        if (bgAlpha < 255) {
            alpha = (float)bgAlpha / 255.0f;
        }
        return SyntheticaComponentPainter.createAlphaColor(color, Float.valueOf(alpha));
    }

    public static Color createAlphaColor(Color color, Float alpha) {
        if (color != null) {
            alpha = Float.valueOf(alpha == null ? 0.1f : alpha.floatValue());
            int rgb = color.getRGB();
            if (rgb >>> 24 < 255) {
                rgb = 0xFF000000 | rgb;
            }
            int rgba = rgb & ((int)(alpha.floatValue() * 255.0f) << 24 | 0xFFFFFF);
            color = new Color(rgba, true);
        }
        return color;
    }

    public static Synthetica2DUtils.BlendMode getSyntheticaBackgroundBlendMode(JComponent c) throws IllegalArgumentException {
        String SYNTHETICA_BLEND_MODE = "Synthetica.background.blendMode";
        String blendMode = SyntheticaLookAndFeel.getString(SYNTHETICA_BLEND_MODE, c, null);
        return (blendMode = SyntheticaLookAndFeel.getClientProperty(SYNTHETICA_BLEND_MODE, c, blendMode)) == null || blendMode.isEmpty() ? null : Synthetica2DUtils.BlendMode.valueOf(blendMode);
    }

    protected Paint createLinearGradientPaint(float startX, float startY, float endX, float endY, float[] fractions, Color[] colors) {
        return SyntheticaLookAndFeel.createLinearGradientPaint(startX, startY, endX, endY, fractions, colors);
    }

    public static Color blend(Color col1, Color col2, Synthetica2DUtils.BlendMode blendMode) {
        if (col2 == null) {
            return col1;
        }
        Color color = Synthetica2DUtils.blend(col1, col2, blendMode);
        return color;
    }

    @Override
    public int getCacheHash(SynthContext sc, int w, int h, int meta, String id) {
        JComponent c = sc.getComponent();
        Border border = c.getBorder();
        Boolean opaque = (Boolean)c.getClientProperty("Synthetica.opaque");
        Color sBackground = (Color)c.getClientProperty(SYNTHETICA_BACKGROUND);
        Float alpha = (Float)c.getClientProperty(SYNTHETICA_BACKGROUND_ALPHA);
        Color background = c.getBackground();
        String name = SyntheticaLookAndFeel.getStyleName(c);
        Window win = SwingUtilities.getWindowAncestor(c);
        int hash = id.hashCode();
        if (this.getCacheScaleType(id) != Cacheable.ScaleType.NINE_SQUARE) {
            hash = 31 * hash + w;
            hash = 31 * hash + h;
        }
        hash = 31 * hash + meta;
        hash = 31 * hash + (int)this.getScale() * 100;
        hash = 31 * hash + this.getClass().hashCode();
        hash = 31 * hash + c.getClass().hashCode();
        hash = 31 * hash + c.getComponentOrientation().hashCode();
        hash = 31 * hash + sc.getComponentState();
        int n = hash = border == null ? hash : 31 * hash + this.getBorderHashCode(border);
        hash = opaque == null ? hash : 31 * hash + (opaque != false ? 0 : 1);
        hash = sBackground == null ? hash : hash * 31 + sBackground.getRGB();
        hash = alpha == null ? hash : hash * 31 + (int)(alpha.floatValue() * 100.0f);
        hash = background == null ? hash : hash * 31 + background.getRGB();
        hash = name == null ? hash : 31 * hash + name.hashCode();
        hash = 31 * hash + (win == null || win.isActive() ? 0 : 1);
        return hash;
    }

    private int getBorderHashCode(Border border) {
        int hash;
        int n = hash = border == null ? 0 : border.getClass().hashCode();
        if (border instanceof CompoundBorder) {
            hash = 31 * hash + this.getBorderHashCode(((CompoundBorder)border).getInsideBorder());
            hash = 31 * hash + this.getBorderHashCode(((CompoundBorder)border).getOutsideBorder());
        }
        return hash;
    }

    @Override
    public Cacheable.ScaleType getCacheScaleType(String id) {
        return Cacheable.ScaleType.NONE;
    }

    @Override
    public Insets getCacheScaleInsets(SynthContext sc, String id) {
        JComponent c = sc.getComponent();
        int val = (int)(this.getScale() * 10.0f);
        Insets insets = c == null ? new Insets(val, val, val, val) : c.getInsets();
        return insets;
    }
}

