/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica.painter;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import java.awt.Image;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

class SyntheticaSoftCache {
    private final int maxCacheSize;
    private final int maxImageSize;
    private final LinkedHashMap<Integer, ImageReference> cache = new LinkedHashMap();
    private ReferenceQueue<Image> referenceQueue = new ReferenceQueue();
    private int pixelCount = 0;
    private static final SyntheticaSoftCache instance = new SyntheticaSoftCache();

    private SyntheticaSoftCache() {
        int maxSize = SyntheticaLookAndFeel.getInt("Synthetica.cache.maxSize", null, 4);
        this.maxCacheSize = maxSize * 1024 * 1024;
        this.maxImageSize = SyntheticaLookAndFeel.getInt("Synthetica.cache.maxImageSize", null, 200000);
    }

    static SyntheticaSoftCache getInstance() {
        return instance;
    }

    public boolean isCacheable(int w, int h) {
        return w * h < this.maxImageSize && w > 0 && h > 0;
    }

    public Image getImage(int cacheHash) {
        ImageReference ref = this.cache.get(cacheHash);
        if (ref != null) {
            return (Image)ref.get();
        }
        return null;
    }

    public boolean setImage(Image image, int cacheHash) {
        ImageReference ref = this.cache.get(cacheHash);
        if (ref != null && ref.get() != null) {
            return true;
        }
        int newPixelCount = image.getWidth(null) * image.getHeight(null);
        this.pixelCount += newPixelCount;
        while ((ref = (ImageReference)this.referenceQueue.poll()) != null) {
            this.cache.remove(ref.cacheHash);
            this.pixelCount -= ref.pixelCount;
        }
        if (this.pixelCount > this.maxCacheSize) {
            Iterator<Map.Entry<Integer, ImageReference>> it = this.cache.entrySet().iterator();
            while (this.pixelCount > this.maxCacheSize / 2 && it.hasNext()) {
                Map.Entry<Integer, ImageReference> entry = it.next();
                ImageReference ir = entry.getValue();
                Image img = (Image)ir.get();
                if (img != null) {
                    img.flush();
                }
                it.remove();
                this.pixelCount -= ir.pixelCount;
            }
        }
        this.cache.put(cacheHash, new ImageReference(image, cacheHash, this.referenceQueue));
        return true;
    }

    public void clear() {
        this.pixelCount = 0;
        this.cache.clear();
    }

    private static class ImageReference
    extends SoftReference<Image> {
        private int cacheHash;
        private int pixelCount;

        public ImageReference(Image image, int cacheHash, ReferenceQueue<Image> queue) {
            super(image, queue);
            this.cacheHash = cacheHash;
            this.pixelCount = image.getWidth(null) * image.getHeight(null);
        }
    }
}

