/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica.painter;

import de.javasoft.plaf.synthetica.StyleFactory;
import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.SyntheticaState;
import de.javasoft.plaf.synthetica.painter.Cacheable;
import de.javasoft.plaf.synthetica.painter.FocusPainter;
import de.javasoft.plaf.synthetica.painter.ImagePainter;
import de.javasoft.plaf.synthetica.painter.SyntheticaComponentPainter;
import de.javasoft.plaf.synthetica.painter.SyntheticaPainterState;
import de.javasoft.plaf.synthetica.painter.UIKey;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.lang.reflect.Method;
import java.util.Comparator;
import java.util.HashMap;
import java.util.TreeMap;
import java.util.WeakHashMap;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;

public class TabbedPanePainter
extends SyntheticaComponentPainter {
    public static final String UI_KEY = "Synthetica.TabbedPanePainter";
    public static final int UNDEFINED = -1;
    public static final int LEFT = 0;
    public static final int RIGHT = 1;
    public static final int LEFT_RIGHT = 2;
    public static final int TOP = 3;
    public static final int BOTTOM = 4;
    public static final int TOP_BOTTOM = 5;
    private static final String FOCUS_PLACEMENT_KEY = "JTabbedPane.focusPlacement";
    private static WeakHashMap<JComponent, Object> translucentTabbedPanes = new WeakHashMap();
    private static final String TRANSLUCENT_KEY = "Synthetica.childsAreTranslucent";
    private static HashMap<String, Image> imgCache = new HashMap();

    protected TabbedPanePainter() {
    }

    public static TabbedPanePainter getInstance() {
        return TabbedPanePainter.getInstance(null);
    }

    public static TabbedPanePainter getInstance(SynthContext sc) {
        SyntheticaComponentPainter instance = (SyntheticaComponentPainter)instances.get(TabbedPanePainter.getPainterClassName(sc, TabbedPanePainter.class, UI_KEY));
        if (instance == null) {
            instance = TabbedPanePainter.getInstance(sc, TabbedPanePainter.class, UI_KEY);
        }
        return (TabbedPanePainter)instance;
    }

    public static void reinitialize() {
        for (JComponent c : translucentTabbedPanes.keySet()) {
            c.putClientProperty(TRANSLUCENT_KEY, false);
        }
        translucentTabbedPanes = new WeakHashMap();
    }

    public void paintTabbedPaneBackground(SynthContext sc, Graphics g, int x, int y, int w, int h) {
    }

    public void paintTabbedPaneBorder(SynthContext sc, Graphics g, int x, int y, int w, int h) {
    }

    public void paintTabbedPaneContentBackground(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        JTabbedPane tabbedPane = (JTabbedPane)sc.getComponent();
        if (!SyntheticaLookAndFeel.getBoolean("Synthetica.tabbedPane.contentBorder.paintBackground", tabbedPane, false)) {
            return;
        }
        int placement = tabbedPane.getTabPlacement();
        SyntheticaState state = new SyntheticaState(sc.getComponentState());
        String imagePath = this.getContentBorderImagePath(tabbedPane, state, placement);
        UIKey key = new UIKey("tabbedPane.contentBorder.image", state, -1, placement, -1);
        Insets sInsets = (Insets)UIKey.findProperty(tabbedPane, key.get(), "sourceInsets", 1);
        Insets dInsets = (Insets)sInsets.clone();
        ImagePainter imagePainter = new ImagePainter(tabbedPane, null, -1, -1, -1, -1, g, x, y, w, h, imagePath, sInsets, dInsets, 0, 0, this.flipOnRTL(tabbedPane), false);
        imagePainter.drawCenter();
    }

    public void paintTabbedPaneContentBorder(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        JTabbedPane tabbedPane = (JTabbedPane)sc.getComponent();
        g.setColor(SyntheticaLookAndFeel.getColor("Synthetica.tabbedPane.hideBorderColor", tabbedPane));
        this.modifyChildOpacity(sc);
        this.paintTabbedPaneContentBorder(tabbedPane, new SyntheticaState(sc.getComponentState()), tabbedPane.getTabPlacement(), true, g, x, y, w, h);
    }

    public void paintTabbedPaneContentBorder(JComponent c, SyntheticaState state, int placement, boolean gap4SelectedTab, Graphics g, int x, int y, int w, int h) {
        this.paintTabbedPaneContentBorder(c, state, placement, gap4SelectedTab, 0, g, x, y, w, h);
    }

    public void paintTabbedPaneContentBorder(JComponent c, SyntheticaState state, int placement, boolean gap4SelectedTab, int angle, Graphics g, int x, int y, int w, int h) {
        String imagePath = this.getContentBorderImagePath(c, state, placement);
        UIKey key = new UIKey("tabbedPane.contentBorder.image", state, -1, placement, -1);
        Insets sInsets = (Insets)UIKey.findProperty(c, key.get(), "sourceInsets", 1);
        if (sInsets == null) {
            sInsets = new Insets(0, 0, 0, 0);
        }
        Insets dInsets = (Insets)sInsets.clone();
        int xPolicy = SyntheticaLookAndFeel.getBoolean("Synthetica.tabbedPane.contentBorder.horizontalTiled", c, false) ? 1 : 0;
        int yPolicy = SyntheticaLookAndFeel.getBoolean("Synthetica.tabbedPane.contentBorder.verticalTiled", c, false) ? 1 : 0;
        ImagePainter imagePainter = new ImagePainter(c, null, -1, -1, -1, -1, g, x, y, w, h, imagePath, sInsets, dInsets, xPolicy, yPolicy, this.flipOnRTL(c), false);
        imagePainter.drawBorder();
        if (gap4SelectedTab && c instanceof JTabbedPane && !SyntheticaLookAndFeel.getBoolean("Synthetica.tabbedPane.tab.selected.paintOverContentBorder.disabled", c)) {
            this.drawContentBorderLine4SelectedTab((JTabbedPane)c, placement, angle, g, x, y, w, h);
        }
    }

    private String getContentBorderImagePath(JComponent c, SyntheticaState state, int placement) {
        boolean ltr = c.getComponentOrientation().isLeftToRight();
        if (placement == 2 && !ltr) {
            placement = 4;
        } else if (placement == 4 && !ltr) {
            placement = 2;
        }
        UIKey key = new UIKey("tabbedPane.contentBorder.image", state, -1, placement, -1);
        return UIKey.resolveImagePath(c, key.get(), null, 1);
    }

    protected void modifyChildOpacity(SynthContext sc) {
        boolean childsTranslucent;
        JComponent c = sc.getComponent();
        boolean bl = childsTranslucent = c.getClientProperty(TRANSLUCENT_KEY) == null ? false : (Boolean)c.getClientProperty(TRANSLUCENT_KEY);
        if (!(SyntheticaLookAndFeel.getBoolean("Synthetica.tabbedPane.keepOpacity", c) || childsTranslucent || c.getParent().getClass().getName().equals("org.flexdock.view.Viewport"))) {
            Component[] components;
            c.putClientProperty(TRANSLUCENT_KEY, Boolean.TRUE);
            translucentTabbedPanes.put(c, null);
            Component[] componentArray = components = c.getComponents();
            int n = components.length;
            int n2 = 0;
            while (n2 < n) {
                Component comp = componentArray[n2];
                if (comp instanceof Container && !(comp instanceof Window) && !(comp instanceof JRootPane)) {
                    TabbedPanePainter.setComponentsTranslucent((Container)comp, true);
                }
                ++n2;
            }
        }
    }

    public static void setAllNonOpaque(Container container) {
        TabbedPanePainter.setComponentsTranslucent(container, false);
    }

    private static void setComponentsTranslucent(Container container, boolean storeOpacity) {
        Component[] components;
        JComponent c;
        StyleFactory factory = storeOpacity ? (StyleFactory)SynthLookAndFeel.getStyleFactory() : null;
        boolean keepOpacity = false;
        boolean keepChildrenOpacity = false;
        if (container instanceof JComponent) {
            keepOpacity = ((JComponent)container).getClientProperty("Synthetica.tabbedPane.keepOpacity") == null ? false : (Boolean)((JComponent)container).getClientProperty("Synthetica.tabbedPane.keepOpacity");
            boolean bl = keepChildrenOpacity = ((JComponent)container).getClientProperty("Synthetica.tabbedPane.keepChildrenOpacity") == null ? false : (Boolean)((JComponent)container).getClientProperty("Synthetica.tabbedPane.keepChildrenOpacity");
        }
        if ((container instanceof JPanel || container instanceof JScrollPane || container instanceof JViewport) && !keepOpacity) {
            if (factory != null) {
                factory.getComponentPropertyStore().storeComponentProperty(container, "SYCP_OPAQUE");
            }
            if (!SyntheticaLookAndFeel.isWindowOpacityEnabled(null)) {
                ((JComponent)container).setDoubleBuffered(false);
            }
            ((JComponent)container).setOpaque(false);
        } else if (container instanceof JComponent && !keepOpacity && ((c = (JComponent)container) instanceof JRadioButton || c instanceof JCheckBox || c instanceof JTextArea && !(c.getParent() instanceof JViewport)) && (c.getBackground() == null || c.getBackground() instanceof ColorUIResource)) {
            if (factory != null) {
                factory.getComponentPropertyStore().storeComponentProperty(c, "SYCP_OPAQUE");
            }
            if (!SyntheticaLookAndFeel.isWindowOpacityEnabled(null)) {
                c.setDoubleBuffered(false);
            }
            c.setOpaque(false);
        }
        if (keepChildrenOpacity) {
            return;
        }
        Component[] componentArray = components = container.getComponents();
        int n = components.length;
        int n2 = 0;
        while (n2 < n) {
            Component c2 = componentArray[n2];
            if (c2 instanceof Container && !(c2 instanceof Window) && !(c2 instanceof JRootPane)) {
                TabbedPanePainter.setComponentsTranslucent((Container)c2, storeOpacity);
            }
            ++n2;
        }
    }

    public void paintTabbedPaneTabAreaBorder(SynthContext sc, Graphics g, int x, int y, int w, int h) {
    }

    public void paintTabbedPaneTabAreaBackground(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        JTabbedPane tabbedPane = (JTabbedPane)sc.getComponent();
        this.paintTabbedPaneTabAreaBackground(tabbedPane, new SyntheticaPainterState(sc), tabbedPane.getTabPlacement(), 0, g, x, y, w, h);
    }

    public void paintTabbedPaneTabAreaBackground(JComponent c, SyntheticaState state, int placement, int angle, Graphics g, int x, int y, int w, int h) {
        Insets sInsets;
        boolean ltr = c.getComponentOrientation().isLeftToRight();
        if (placement == 2 && !ltr) {
            placement = 4;
        } else if (placement == 4 && !ltr) {
            placement = 2;
        }
        UIKey key = new UIKey("tabbedPane.tabArea.background.image", state, -1, placement, -1);
        Insets dInsets = sInsets = SyntheticaLookAndFeel.getInsets(key.get("insets"), (Component)c, false, false);
        String imagePath = this.resolveImagePath(key.get(), c);
        if (imagePath != null) {
            int xPolicy = SyntheticaLookAndFeel.getBoolean("Synthetica.tabbedPane.tabArea.background.horizontalTiled", c, false) ? 1 : 0;
            int yPolicy = SyntheticaLookAndFeel.getBoolean("Synthetica.tabbedPane.tabArea.background.verticalTiled", c, false) ? 1 : 0;
            ImagePainter imagePainter = new ImagePainter(c, null, -1, -1, -1, -1, g, x, y, w, h, imagePath, sInsets, dInsets, xPolicy, yPolicy, this.flipOnRTL(c), false);
            imagePainter.setAngle(angle);
            imagePainter.draw();
        }
    }

    public void paintTabbedPaneTabBorder(SynthContext sc, Graphics g, int x, int y, int w, int h, int tabIndex) {
        JTabbedPane tabbedPane = (JTabbedPane)sc.getComponent();
        if (SyntheticaLookAndFeel.getBoolean("Synthetica.tabbedPane.tab.selected.bold", tabbedPane) && tabbedPane.getSelectedIndex() == tabIndex && tabbedPane.hasFocus()) {
            JButton b = new JButton();
            SynthStyle ss = SynthLookAndFeel.getStyle(b, Region.BUTTON);
            sc = new SynthContext(b, Region.BUTTON, ss, 256);
            ss.getPainter(sc).paintButtonBorder(sc, g, x, y, w, h);
        }
    }

    public void paintTabbedPaneTab(JComponent c, SyntheticaState state, int tabIndex, int placement, int position, int angle, Graphics g, int x, int y, int w, int h) {
        ImagePainter imagePainter;
        Color syntheticaBackground = (Color)c.getClientProperty("Synthetica.background");
        Float syntheticaBackgroundAlpha = (Float)c.getClientProperty("Synthetica.background.alpha");
        String bgKey = "Synthetica.tabbedPane.tab." + tabIndex + ".background";
        Color bg = (Color)c.getClientProperty(bgKey);
        if (bg == null && c instanceof JTabbedPane && !(((JTabbedPane)c).getBackgroundAt(tabIndex) instanceof UIResource)) {
            bg = ((JTabbedPane)c).getBackgroundAt(tabIndex);
        }
        if (bg != null) {
            c.putClientProperty("Synthetica.background", bg);
            if (c.getClientProperty(String.valueOf(bgKey) + ".alpha") != null) {
                c.putClientProperty("Synthetica.background.alpha", c.getClientProperty(String.valueOf(bgKey) + ".alpha"));
            }
        }
        String id = String.valueOf(placement) + "/" + tabIndex;
        String imagePath = null;
        Insets sInsets = null;
        String propertyKey = "tabbedPane.tab";
        if (state.isSet(SyntheticaState.State.HOVER) && !state.isSet(SyntheticaState.State.SELECTED) && !state.isSet(SyntheticaState.State.DISABLED)) {
            propertyKey = String.valueOf(propertyKey) + ".hover";
        } else if (state.isSet(SyntheticaState.State.SELECTED)) {
            propertyKey = String.valueOf(propertyKey) + ".selected";
        } else if (state.isSet(SyntheticaState.State.DISABLED)) {
            propertyKey = String.valueOf(propertyKey) + ".disabled";
        }
        if (placement == 1) {
            propertyKey = String.valueOf(propertyKey) + ".top";
        } else if (placement == 2) {
            propertyKey = String.valueOf(propertyKey) + ".left";
        } else if (placement == 3) {
            propertyKey = String.valueOf(propertyKey) + ".bottom";
        } else if (placement == 4) {
            propertyKey = String.valueOf(propertyKey) + ".right";
        }
        String name = SyntheticaLookAndFeel.getStyleName(c);
        imagePath = SyntheticaLookAndFeel.resolveImagePath(propertyKey, null, name, true);
        sInsets = SyntheticaLookAndFeel.getInsets(propertyKey, "insets", name, true);
        if (imagePath == null) {
            if (state.isSet(SyntheticaState.State.SELECTED)) {
                imagePath = this.getTabImagePath(c, placement, position, ".selected");
                if (imagePath == null) {
                    imagePath = placement == 1 || placement == 3 ? this.resolveImagePath("Synthetica.tabbedPane.tab.x.image.selected", c) : this.resolveImagePath("Synthetica.tabbedPane.tab.y.image.selected", c);
                }
            } else if (state.isSet(SyntheticaState.State.DISABLED)) {
                imagePath = this.getTabImagePath(c, placement, position, ".disabled");
            } else {
                if (state.isSet(SyntheticaState.State.HOVER)) {
                    imagePath = this.getTabImagePath(c, placement, position, ".hover");
                }
                if (imagePath == null) {
                    imagePath = this.getTabImagePath(c, placement, position, null);
                }
            }
        }
        Insets bgInsets = SyntheticaLookAndFeel.getInsets("Synthetica.tabbedPane.tab.noneSelected.background.insets", (Component)c, true, true);
        if (!state.isSet(SyntheticaState.State.SELECTED) && bgInsets != null) {
            if (placement == 1) {
                y += bgInsets.top;
            } else if (placement == 3) {
                h -= bgInsets.bottom;
            } else if (placement == 2) {
                x += bgInsets.left;
            } else if (placement == 4) {
                if (angle == 0) {
                    w -= bgInsets.right;
                } else {
                    h -= bgInsets.right;
                }
            }
        }
        if (placement == 3) {
            sInsets = new Insets(sInsets.bottom, sInsets.left, sInsets.top, sInsets.right);
        }
        if (placement == 4) {
            sInsets = new Insets(sInsets.top, sInsets.right, sInsets.bottom, sInsets.left);
        }
        if (sInsets == null) {
            sInsets = new Insets(0, 0, 0, 0);
        }
        Insets dInsets = (Insets)sInsets.clone();
        if (SyntheticaLookAndFeel.getBoolean("Synthetica.tabbedPane.tab.removeDoubleBorder", c)) {
            if (!(placement != 1 && placement != 3 || position != 0 && position != -1)) {
                dInsets.right = SyntheticaLookAndFeel.getInt("Synthetica.tabbedPane.tab.doubleBorderXCorrection", c, 0, true);
            } else if (placement == 2 && (position == 4 || position == -1) && angle != 0) {
                dInsets.right = SyntheticaLookAndFeel.getInt("Synthetica.tabbedPane.tab.doubleBorderYCorrection", c, 0, true);
            } else if (placement == 4 && (position == 3 || position == -1) && angle != 0) {
                dInsets.right = SyntheticaLookAndFeel.getInt("Synthetica.tabbedPane.tab.doubleBorderYCorrection", c, 0, true);
            } else if (!(placement != 2 && placement != 4 || position != 3 && position != -1)) {
                dInsets.bottom = SyntheticaLookAndFeel.getInt("Synthetica.tabbedPane.tab.doubleBorderYCorrection", c, 0, true);
            }
        }
        if (placement == 1) {
            dInsets.bottom = 0;
        } else if (placement == 2) {
            if (angle == 0) {
                dInsets.right = 0;
            } else {
                dInsets.bottom = 0;
            }
        } else if (placement == 3) {
            dInsets.top = 0;
        } else if (placement == 4) {
            if (angle == 0) {
                dInsets.left = 0;
            } else {
                dInsets.bottom = 0;
            }
        }
        boolean clippingEnabled = SyntheticaLookAndFeel.getBoolean("Synthetica.tabbePane.tab.imageClippingEnabled", c, SyntheticaLookAndFeel.getBoolean("Synthetica.tabbedPane.tab.imageClippingEnabled", c, true));
        if (state.isSet(SyntheticaState.State.HOVER) && !state.isSet(SyntheticaState.State.DISABLED) && !state.isSet(SyntheticaState.State.SELECTED) && SyntheticaLookAndFeel.getInt("Synthetica.tabbedPane.tab.hover.red", (Component)c, Integer.MIN_VALUE) != Integer.MIN_VALUE) {
            int red = SyntheticaLookAndFeel.getInt("Synthetica.tabbedPane.tab.hover.red", c);
            int green = SyntheticaLookAndFeel.getInt("Synthetica.tabbedPane.tab.hover.green", c);
            int blue = SyntheticaLookAndFeel.getInt("Synthetica.tabbedPane.tab.hover.blue", c);
            Insets cInsets = SyntheticaLookAndFeel.getInsets("Synthetica.tabbedPane.tab.hover.insets", (Component)c, false, true);
            imagePainter = new ImagePainter(c, red, green, blue, cInsets, g, x, y, w, h, imagePath, sInsets, clippingEnabled ? dInsets : sInsets, 0, 0, this.flipOnRTL(c), false);
        } else {
            int delay = 0;
            int cycles = 0;
            int type = 0;
            if (state.isSet(SyntheticaState.State.HOVER)) {
                cycles = SyntheticaLookAndFeel.getInt("Synthetica.tabbedPane.tab.hover.animation.cycles", (Component)c, 1);
                delay = SyntheticaLookAndFeel.getInt("Synthetica.tabbedPane.tab.hover.animation.delay", (Component)c, 50);
                type = SyntheticaLookAndFeel.getInt("Synthetica.tabbedPane.tab.hover.animation.type", (Component)c, 1);
            } else {
                cycles = SyntheticaLookAndFeel.getInt("Synthetica.tabbedPane.tab.animation.cycles", (Component)c, 1);
                delay = SyntheticaLookAndFeel.getInt("Synthetica.tabbedPane.tab.animation.delay", (Component)c, 50);
                type = SyntheticaLookAndFeel.getInt("Synthetica.tabbedPane.tab.animation.type", (Component)c, 2);
            }
            imagePainter = new ImagePainter(c, id, cycles, delay, type, state.getState(), g, x, y, w, h, imagePath, sInsets, clippingEnabled ? dInsets : sInsets, 0, 0, this.flipOnRTL(c), false);
        }
        imagePainter.setAngle(angle);
        if (!clippingEnabled) {
            imagePainter.draw();
        } else {
            if (placement != 3) {
                imagePainter.drawTopLeft();
                imagePainter.drawTopCenter();
                imagePainter.drawTopRight();
            }
            if (placement != 4 || angle != 0) {
                imagePainter.drawLeft();
            }
            if (placement != 1) {
                imagePainter.drawBottomLeft();
                imagePainter.drawBottomCenter();
                imagePainter.drawBottomRight();
            }
            if (placement != 2 || angle != 0) {
                imagePainter.drawRight();
            }
            imagePainter.drawCenter();
        }
        c.putClientProperty("Synthetica.background", syntheticaBackground);
        c.putClientProperty("Synthetica.background.alpha", syntheticaBackgroundAlpha);
        if (state.isSet(SyntheticaState.State.FOCUSED)) {
            int focusPlacement;
            int n = focusPlacement = c.getClientProperty(FOCUS_PLACEMENT_KEY) == null ? -1 : (Integer)c.getClientProperty(FOCUS_PLACEMENT_KEY);
            if (focusPlacement != -1) {
                placement = focusPlacement;
            }
            String key = "";
            if (placement == 1) {
                key = "focus.tabbedPane.tab.top";
            } else if (placement == 3) {
                key = "focus.tabbedPane.tab.bottom";
            } else if (placement == 2) {
                key = "focus.tabbedPane.tab.left";
            } else if (placement == 4) {
                key = "focus.tabbedPane.tab.right";
            }
            FocusPainter.paintFocus(key, c, state.getState(), id, angle, g, x, y, w, h);
        }
    }

    private String getTabImagePath(JComponent c, int placement, int position, String stateExtension) {
        String imagePath = null;
        if (stateExtension == null) {
            stateExtension = "";
        }
        imagePath = position == 0 ? this.resolveImagePath("Synthetica.tabbedPane.tab.left.image" + stateExtension, c) : (position == 1 ? this.resolveImagePath("Synthetica.tabbedPane.tab.right.image" + stateExtension, c) : (position == 2 ? this.resolveImagePath("Synthetica.tabbedPane.tab.leftRight.image" + stateExtension, c) : (position == 3 ? this.resolveImagePath("Synthetica.tabbedPane.tab.top.image" + stateExtension, c) : (position == 4 ? this.resolveImagePath("Synthetica.tabbedPane.tab.bottom.image" + stateExtension, c) : (position == 5 ? this.resolveImagePath("Synthetica.tabbedPane.tab.topBottom.image" + stateExtension, c) : (placement == 1 || placement == 3 ? this.resolveImagePath("Synthetica.tabbedPane.tab.middle.image" + stateExtension, c) : this.resolveImagePath("Synthetica.tabbedPane.tab.center.image" + stateExtension, c)))))));
        return imagePath;
    }

    public void paintTabbedPaneTabBackground(SynthContext sc, Graphics g, int x, int y, int w, int h, int tabIndex) {
        int hoverTabIndex;
        JTabbedPane tabbedPane = (JTabbedPane)sc.getComponent();
        int placement = tabbedPane.getTabPlacement();
        int position = this.getTabPosition(tabbedPane, tabIndex);
        SyntheticaState state = new SyntheticaState(sc.getComponentState());
        Integer iHover = (Integer)tabbedPane.getClientProperty("Synthetica.MOUSE_OVER");
        int n = hoverTabIndex = iHover == null ? -1 : iHover;
        if (hoverTabIndex == tabIndex) {
            state.setState(SyntheticaState.State.HOVER);
        }
        if (!tabbedPane.isEnabledAt(tabIndex)) {
            state.setState(SyntheticaState.State.DISABLED);
        }
        this.paintTabbedPaneTab(tabbedPane, state, tabIndex, placement, position, 0, g, x, y, w, h);
    }

    protected int getTabPosition(JTabbedPane tabbedPane, int tabIndex) {
        if (tabIndex < 0) {
            return -1;
        }
        boolean left = false;
        boolean right = false;
        boolean top = false;
        boolean bottom = false;
        if (tabbedPane.getTabPlacement() == 1 || tabbedPane.getTabPlacement() == 3) {
            TreeMap<Object, Integer> x1Tabs = new TreeMap<Object, Integer>(new Comparator<Object>(){

                @Override
                public int compare(Object o1, Object o2) {
                    Rectangle r1 = (Rectangle)o1;
                    Rectangle r2 = (Rectangle)o2;
                    if (r1.x > r2.x) {
                        return 1;
                    }
                    if (r1.x < r2.x) {
                        return -1;
                    }
                    return 0;
                }
            });
            TreeMap<Object, Integer> x2Tabs = new TreeMap<Object, Integer>(new Comparator<Object>(){

                @Override
                public int compare(Object o1, Object o2) {
                    Rectangle r1 = (Rectangle)o1;
                    Rectangle r2 = (Rectangle)o2;
                    if (r1.x + r1.width < r2.x + r2.width) {
                        return 1;
                    }
                    if (r1.x + r1.width > r2.x + r2.width) {
                        return -1;
                    }
                    return 0;
                }
            });
            int i = 0;
            while (i < tabbedPane.getTabCount()) {
                x1Tabs.put(tabbedPane.getBoundsAt(i), i);
                ++i;
            }
            if (x1Tabs.headMap(tabbedPane.getBoundsAt(tabIndex)).size() == 0) {
                left = true;
            }
            i = 0;
            while (i < tabbedPane.getTabCount()) {
                x2Tabs.put(tabbedPane.getBoundsAt(i), i);
                ++i;
            }
            if (x2Tabs.headMap(tabbedPane.getBoundsAt(tabIndex)).size() == 0) {
                right = true;
            }
            if (left && right) {
                return 2;
            }
            if (left) {
                return 0;
            }
            if (right) {
                return 1;
            }
        } else {
            TreeMap<Object, Integer> y1Tabs = new TreeMap<Object, Integer>(new Comparator<Object>(){

                @Override
                public int compare(Object o1, Object o2) {
                    Rectangle r1 = (Rectangle)o1;
                    Rectangle r2 = (Rectangle)o2;
                    if (r1.y > r2.y) {
                        return 1;
                    }
                    if (r1.y < r2.y) {
                        return -1;
                    }
                    return 0;
                }
            });
            TreeMap<Object, Integer> y2Tabs = new TreeMap<Object, Integer>(new Comparator<Object>(){

                @Override
                public int compare(Object o1, Object o2) {
                    Rectangle r1 = (Rectangle)o1;
                    Rectangle r2 = (Rectangle)o2;
                    if (r1.y + r1.height < r2.y + r2.height) {
                        return 1;
                    }
                    if (r1.y + r1.height > r2.y + r2.height) {
                        return -1;
                    }
                    return 0;
                }
            });
            int i = 0;
            while (i < tabbedPane.getTabCount()) {
                y1Tabs.put(tabbedPane.getBoundsAt(i), i);
                ++i;
            }
            if (y1Tabs.headMap(tabbedPane.getBoundsAt(tabIndex)).size() == 0) {
                top = true;
            }
            i = 0;
            while (i < tabbedPane.getTabCount()) {
                y2Tabs.put(tabbedPane.getBoundsAt(i), i);
                ++i;
            }
            if (y2Tabs.headMap(tabbedPane.getBoundsAt(tabIndex)).size() == 0) {
                bottom = true;
            }
            if (top && bottom) {
                return 5;
            }
            if (top) {
                return 3;
            }
            if (bottom) {
                return 4;
            }
        }
        return -1;
    }

    private void drawContentBorderLine4SelectedTab(JTabbedPane tabbedPane, int placement, int angle, Graphics g, int x, int y, int w, int h) {
        int selectedTab;
        String imagePath;
        if (SyntheticaLookAndFeel.get("Synthetica.tabbedPane.rotateTabRuns", tabbedPane) != null && !SyntheticaLookAndFeel.getBoolean("Synthetica.tabbedPane.rotateTabRuns", tabbedPane) && this.getSelectedRun(tabbedPane) != 0) {
            return;
        }
        if (placement == 1 && this.resolveImagePath("Synthetica.tabbedPane.tab.selected.top", tabbedPane) != null) {
            imagePath = this.resolveImagePath("Synthetica.tabbedPane.tab.selected.top", tabbedPane);
        } else if (placement == 3 && this.resolveImagePath("Synthetica.tabbedPane.tab.selected.bottom", tabbedPane) != null) {
            imagePath = this.resolveImagePath("Synthetica.tabbedPane.tab.selected.bottom", tabbedPane);
        } else if (placement == 2 && this.resolveImagePath("Synthetica.tabbedPane.tab.selected.left", tabbedPane) != null) {
            imagePath = this.resolveImagePath("Synthetica.tabbedPane.tab.selected.left", tabbedPane);
        } else if (placement == 4 && this.resolveImagePath("Synthetica.tabbedPane.tab.selected.right", tabbedPane) != null) {
            imagePath = this.resolveImagePath("Synthetica.tabbedPane.tab.selected.right", tabbedPane);
        } else {
            int position = this.getTabPosition(tabbedPane, tabbedPane.getSelectedIndex());
            imagePath = this.getTabImagePath(tabbedPane, placement, position, ".selected");
            if (imagePath == null) {
                imagePath = placement == 1 || placement == 3 ? this.resolveImagePath("Synthetica.tabbedPane.tab.x.image.selected", tabbedPane) : this.resolveImagePath("Synthetica.tabbedPane.tab.y.image.selected", tabbedPane);
            }
        }
        if (imagePath == null) {
            return;
        }
        Image image = imgCache.get(imagePath);
        if (image == null) {
            image = new ImageIcon(SyntheticaLookAndFeel.getResource(imagePath)).getImage();
            imgCache.put(imagePath, image);
        }
        int rdb = 0;
        if (SyntheticaLookAndFeel.getBoolean("Synthetica.tabbedPane.tab.removeDoubleBorder", tabbedPane)) {
            boolean rightBorderTab = false;
            int borderTab = this.getTabPosition(tabbedPane, tabbedPane.getSelectedIndex());
            if ((placement == 1 || placement == 3) && borderTab == 1) {
                rightBorderTab = true;
            } else if (angle != 0 && placement == 4 && borderTab == 4) {
                rightBorderTab = true;
            } else if (angle != 0 && placement == 2 && borderTab == 3) {
                rightBorderTab = true;
            }
            if (!rightBorderTab) {
                rdb = 1;
            }
        }
        if ((selectedTab = tabbedPane.getSelectedIndex()) == -1) {
            return;
        }
        Rectangle r = (Rectangle)tabbedPane.getClientProperty("JTabbedPane.visibleSelectedTabRect");
        if (r == null) {
            r = tabbedPane.getBoundsAt(selectedTab);
        }
        String propertyKey = "tabbedPane.tab.selected";
        if (placement == 1) {
            propertyKey = String.valueOf(propertyKey) + ".top";
        } else if (placement == 2) {
            propertyKey = String.valueOf(propertyKey) + ".left";
        } else if (placement == 3) {
            propertyKey = String.valueOf(propertyKey) + ".bottom";
        } else if (placement == 4) {
            propertyKey = String.valueOf(propertyKey) + ".right";
        }
        Insets sInsets = SyntheticaLookAndFeel.getInsets(propertyKey, "insets", SyntheticaLookAndFeel.getStyleName(tabbedPane), true);
        sInsets = (Insets)sInsets.clone();
        if (r.width < sInsets.left + sInsets.right || r.height < sInsets.top + sInsets.bottom) {
            return;
        }
        if (placement == 3) {
            sInsets = new Insets(sInsets.bottom, sInsets.left, sInsets.top, sInsets.right);
        } else if (placement == 4) {
            sInsets = new Insets(sInsets.top, sInsets.right, sInsets.bottom, sInsets.left);
        }
        Insets dInsets = new Insets(0, 0, 0, 0);
        int size = SyntheticaLookAndFeel.getInstance().scaleInteger(1);
        boolean useFillAsBorder = SyntheticaLookAndFeel.getBoolean("Synthetica.tabbedPane.tab.selected.useFillAsContentBorder", tabbedPane, true);
        if (placement == 1) {
            sInsets.top = image.getHeight(null) + (useFillAsBorder ? -sInsets.bottom - 1 : 0);
            dInsets.left = sInsets.left;
            dInsets.right = sInsets.right - rdb;
            x = r.x;
            w = r.width + rdb;
            h = size;
        } else if (placement == 3) {
            sInsets.bottom = image.getHeight(null) + (useFillAsBorder ? -sInsets.top - 1 : 0);
            dInsets.left = sInsets.left;
            dInsets.right = sInsets.right - rdb;
            x = r.x;
            y = y + h - size;
            w = r.width + rdb;
            h = size;
        } else if (placement == 2) {
            if (angle == 0) {
                sInsets.left = image.getWidth(null) + (useFillAsBorder ? -sInsets.right - 1 : 0);
                dInsets.top = sInsets.top;
                dInsets.bottom = sInsets.bottom - rdb;
            } else {
                sInsets.top = image.getHeight(null) + (useFillAsBorder ? -sInsets.bottom - 1 : 0);
                dInsets.left = sInsets.left;
                dInsets.right = sInsets.right - rdb;
            }
            x = r.x + r.width;
            y = angle == 0 ? r.y : r.y - rdb;
            w = angle == 0 ? size : r.height + rdb;
            h = angle == 0 ? r.height + rdb : size;
        } else if (placement == 4) {
            if (angle == 0) {
                sInsets.right = image.getWidth(null) + (useFillAsBorder ? -sInsets.left - 1 : 0);
                dInsets.top = sInsets.top;
                dInsets.bottom = sInsets.bottom - rdb;
            } else {
                sInsets.top = image.getHeight(null) + (useFillAsBorder ? -sInsets.bottom - 1 : 0);
                dInsets.left = sInsets.left;
                dInsets.right = sInsets.right - rdb;
            }
            x = r.x - size;
            y = r.y;
            w = angle == 0 ? size : r.height + rdb;
            h = angle == 0 ? r.height + rdb : size;
        }
        ImagePainter imagePainter = new ImagePainter(tabbedPane, null, -1, -1, -1, -1, g, x, y, w, h, imagePath, sInsets, dInsets, 0, 0, this.flipOnRTL(tabbedPane), false);
        imagePainter.setAngle(angle);
        if (angle != 0 || placement == 1 || placement == 3) {
            imagePainter.drawLeft();
            imagePainter.drawRight();
        } else {
            imagePainter.drawTopCenter();
            imagePainter.drawBottomCenter();
        }
        imagePainter.drawCenter();
    }

    public boolean paintTabbedPaneTabText(SynthContext sc, Graphics g, String text, int x, int y, int mnemonicIndex) {
        return true;
    }

    protected boolean flipOnRTL(JComponent c) {
        return c.getComponentOrientation() == ComponentOrientation.RIGHT_TO_LEFT && SyntheticaLookAndFeel.getBoolean("Synthetica.tabbedPane.horizontalFlipOnRTL.enabled", c);
    }

    protected int getSelectedRun(JTabbedPane tabbedPane) {
        if (!(tabbedPane.getUI() instanceof BasicTabbedPaneUI)) {
            return -1;
        }
        BasicTabbedPaneUI ui = (BasicTabbedPaneUI)tabbedPane.getUI();
        int tabIndex = tabbedPane.getSelectedIndex();
        int tabCount = tabbedPane.getTabCount();
        if (SyntheticaLookAndFeel.getJVMCompatibilityMode() == SyntheticaLookAndFeel.JVMCompatibilityMode.SUN) {
            try {
                Class<?> clazz = Class.forName("javax.swing.plaf.basic.BasicTabbedPaneUI");
                Method m = clazz.getDeclaredMethod("getRunForTab", Integer.TYPE, Integer.TYPE);
                m.setAccessible(true);
                return (Integer)m.invoke((Object)ui, tabCount, tabIndex);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return -1;
    }

    @Override
    public Cacheable.ScaleType getCacheScaleType(String id) {
        if (id.equals("paintTabbedPaneBorder") || id.equals("paintTabbedPaneBackground") || id.equals("paintTabbedPaneContentBorder") || id.equals("paintTabbedPaneContentBackground")) {
            return Cacheable.ScaleType.NINE_SQUARE;
        }
        return super.getCacheScaleType(id);
    }

    @Override
    public int getCacheHash(SynthContext sc, int w, int h, int meta, String id) {
        if (id.equals("paintTabbedPaneBorder") || id.equals("paintTabbedPaneBackground") || id.equals("paintTabbedPaneContentBorder") || id.equals("paintTabbedPaneContentBackground")) {
            return -1;
        }
        JTabbedPane tb = (JTabbedPane)sc.getComponent();
        int hash = super.getCacheHash(sc, w, h, meta, id);
        if (id.equals("paintTabbedPaneTabBackground") || id.equals("paintTabbedPaneTabBorder")) {
            hash = hash * 31 + tb.getTabPlacement();
            hash = hash * 31 + this.getTabPosition(tb, meta);
            Integer hoverTab = (Integer)tb.getClientProperty("Synthetica.MOUSE_OVER");
            hash = hash * 31 + (hoverTab == null ? 1000 : hoverTab);
        }
        return hash;
    }
}

