/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica.painter;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.painter.Cacheable;
import de.javasoft.plaf.synthetica.painter.ImagePainter;
import de.javasoft.plaf.synthetica.painter.SyntheticaComponentPainter;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.synth.SynthContext;

public class TreePainter
extends SyntheticaComponentPainter {
    public static final String UI_KEY = "Synthetica.TreePainter";
    private static boolean cellRendererSelectionBackgroundEnabled;

    protected TreePainter() {
    }

    public static TreePainter getInstance() {
        return TreePainter.getInstance(null);
    }

    public static TreePainter getInstance(SynthContext sc) {
        SyntheticaComponentPainter instance = (SyntheticaComponentPainter)instances.get(TreePainter.getPainterClassName(sc, TreePainter.class, UI_KEY));
        if (instance == null) {
            instance = TreePainter.getInstance(sc, TreePainter.class, UI_KEY);
        }
        return (TreePainter)instance;
    }

    public static void reinitialize() {
        cellRendererSelectionBackgroundEnabled = SyntheticaLookAndFeel.getBoolean("Synthetica.cellRenderer.selectionBackground.enabled", null, false);
    }

    public void paintTreeBorder(SynthContext sc, Graphics g, int x, int y, int w, int h) {
    }

    public void paintTreeBackground(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        JComponent c = sc.getComponent();
        Color background = c.getBackground();
        if (background != null && !(background instanceof ColorUIResource) && c.isOpaque()) {
            g.setColor(background);
            g.fillRect(x, y, w, h);
        }
    }

    public void paintTreeCellBorder(SynthContext sc, Graphics g, int x, int y, int w, int h) {
    }

    public void paintTreeCellBackground(SynthContext sc, Graphics g, int x, int y, int w, int h) {
        JComponent c = sc.getComponent();
        if (cellRendererSelectionBackgroundEnabled) {
            String imagePath;
            boolean focused = true;
            boolean cellRendererRespectsFocus = SyntheticaLookAndFeel.getBoolean("Synthetica.cellRenderer.respectFocus", c, false);
            if (cellRendererRespectsFocus) {
                focused = c.getParent() instanceof CellRendererPane ? c.getParent().getParent().hasFocus() : c.hasFocus();
            }
            if ((imagePath = this.resolveImagePath(focused ? "Synthetica.tree.selectionBackground" : "Synthetica.tree.selectionBackground.inactive", c)) != null) {
                Insets sInsets = this.getImageInsets("Synthetica.tree.selectionBackground.insets", c);
                ImagePainter imagePainter = new ImagePainter(g, x, y, w, h, imagePath, sInsets, sInsets, 0, 0);
                imagePainter.draw();
            }
        }
    }

    @Override
    public Cacheable.ScaleType getCacheScaleType(String id) {
        return Cacheable.ScaleType.NINE_SQUARE;
    }

    @Override
    public int getCacheHash(SynthContext sc, int w, int h, int meta, String id) {
        return -1;
    }
}

