/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica.styles;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.styles.StyleWrapper;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthStyle;

public class ButtonStyle
extends StyleWrapper {
    private static ButtonStyle instance = new ButtonStyle();

    private ButtonStyle() {
    }

    public static SynthStyle getStyle(SynthStyle style, JComponent c, Region region) {
        if (SyntheticaLookAndFeel.getStyleName(c) == null) {
            instance.setStyle(style);
            return instance;
        }
        ButtonStyle sw = new ButtonStyle();
        sw.setStyle(style);
        return sw;
    }

    @Override
    public Object get(SynthContext sc, Object key) {
        Object val = super.get(sc, key);
        if ("Button.margin".equals(key) && val != null) {
            val = SyntheticaLookAndFeel.getInstance().scaleInsets((Insets)val);
        } else if ("Button.iconTextGap".equals(key) && val != null) {
            val = SyntheticaLookAndFeel.getInstance().scaleInteger((Integer)val);
        }
        return val;
    }

    @Override
    public Color getColor(SynthContext sc, ColorType type) {
        JComponent c = sc.getComponent();
        if (type == ColorType.TEXT_FOREGROUND && !(c.getForeground() instanceof ColorUIResource)) {
            return c.getForeground();
        }
        return super.getColor(sc, type);
    }

    @Override
    public Font getFont(SynthContext sc) {
        Font font = super.getFont(sc);
        JComponent c = sc.getComponent();
        String key = "Synthetica.button.font";
        if (c instanceof JButton && ((JButton)c).isDefaultButton()) {
            key = "Synthetica.button.default.font";
        }
        if (SyntheticaLookAndFeel.get(String.valueOf(key) + ".style", c) != null) {
            float size;
            int style = 0;
            String fontStyle = SyntheticaLookAndFeel.getString(String.valueOf(key) + ".style", c);
            if (fontStyle.contains("BOLD")) {
                style |= 1;
            }
            if (fontStyle.contains("ITALIC")) {
                style |= 2;
            }
            if ((size = SyntheticaLookAndFeel.getInstance().scaleFontSize(SyntheticaLookAndFeel.getInt(String.valueOf(key) + ".size", (Component)c, 0))) == 0.0f) {
                size = font.getSize2D();
            }
            font = new FontUIResource(font.deriveFont(style, size));
        }
        return font;
    }
}

