/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica.styles;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.styles.StyleWrapper;
import java.awt.Color;
import java.awt.Container;
import javax.swing.CellRendererPane;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthStyle;

public class LabelStyle
extends StyleWrapper {
    private static LabelStyle instance = new LabelStyle();

    private LabelStyle() {
    }

    public static SynthStyle getStyle(SynthStyle style, JComponent c, Region region) {
        if (SyntheticaLookAndFeel.getStyleName(c) == null) {
            instance.setStyle(style);
            return instance;
        }
        LabelStyle sw = new LabelStyle();
        sw.setStyle(style);
        return sw;
    }

    @Override
    public Color getColor(SynthContext sc, ColorType type) {
        JComponent c = sc.getComponent();
        Container parent = c.getParent();
        if (parent != null && parent instanceof JComponent) {
            Color color = null;
            if (((JComponent)parent).getUIClassID().equals("StatusBarUI")) {
                color = SyntheticaLookAndFeel.getColor("Synthetica.statusBar.label.foreground", c);
            } else if (parent instanceof JToolBar) {
                color = SyntheticaLookAndFeel.getColor("Synthetica.toolBar.label.foreground", c);
            }
            if (color != null) {
                return color;
            }
        } else if (type == ColorType.TEXT_FOREGROUND && parent instanceof CellRendererPane && parent.getParent() instanceof JComboBox) {
            JComboBox cb = (JComboBox)parent.getParent();
            Color textColor = null;
            if (!cb.isEnabled()) {
                textColor = SyntheticaLookAndFeel.getColor("Synthetica.comboBox.disabled.textColor", cb);
            } else if (cb.getForeground() != null && !(cb.getForeground() instanceof ColorUIResource)) {
                textColor = cb.getForeground();
            } else if (cb.hasFocus()) {
                textColor = SyntheticaLookAndFeel.getColor("Synthetica.comboBox.focused.textColor", cb);
            } else if (!cb.isEditable()) {
                textColor = SyntheticaLookAndFeel.getColor("Synthetica.comboBox.locked.textColor", cb);
            }
            return textColor;
        }
        return this.synthStyle.getColor(sc, type);
    }
}

