/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica.util;

import de.javasoft.plaf.synthetica.util.Synthetica2DUtils;
import java.awt.Composite;
import java.awt.CompositeContext;
import java.awt.RenderingHints;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;

public class LuminosityComposite
implements Composite,
CompositeContext {
    public static final LuminosityComposite Luminosity = new LuminosityComposite();

    @Override
    public void compose(Raster src, Raster dstIn, WritableRaster dstOut) {
        int width = Math.min(src.getWidth(), dstIn.getWidth());
        int height = Math.min(src.getHeight(), dstIn.getHeight());
        int[] srcPixels = new int[width];
        int[] dstPixels = new int[width];
        int y = 0;
        while (y < height) {
            src.getDataElements(0, y, width, 1, srcPixels);
            dstIn.getDataElements(0, y, width, 1, dstPixels);
            int x = 0;
            while (x < width) {
                dstPixels[x] = LuminosityComposite.luminostyRGB(dstPixels[x], srcPixels[x]);
                ++x;
            }
            dstOut.setDataElements(0, y, width, 1, dstPixels);
            ++y;
        }
    }

    static int luminostyRGB(int rgb1, int rgb2) {
        int b1 = rgb1 & 0xFF;
        int b2 = rgb2 & 0xFF;
        int g1 = rgb1 >> 8 & 0xFF;
        int g2 = rgb2 >> 8 & 0xFF;
        int r1 = rgb1 >> 16 & 0xFF;
        int r2 = rgb2 >> 16 & 0xFF;
        int a1 = rgb1 >> 24 & 0xFF;
        int a2 = rgb2 >> 24 & 0xFF;
        float[] srcHSL = Synthetica2DUtils.RGBtoHSL(r1, g1, b1);
        float[] dstHSL = Synthetica2DUtils.RGBtoHSL(r2, g2, b2);
        int[] result = Synthetica2DUtils.HSLtoRGB(dstHSL[0], dstHSL[1], srcHSL[2]);
        int a = Math.min(255, a2 + a1 - a2 * a1 / 255);
        return result[2] | result[1] << 8 | result[0] << 16 | a << 24;
    }

    @Override
    public CompositeContext createContext(ColorModel srcColorModel, ColorModel dstColorModel, RenderingHints hints) {
        return this;
    }

    @Override
    public void dispose() {
    }
}

