/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica.util;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.util.ColorBurnComposite;
import de.javasoft.plaf.synthetica.util.LinearLightComposite;
import de.javasoft.plaf.synthetica.util.LuminosityComposite;
import de.javasoft.plaf.synthetica.util.MultiplyComposite;
import de.javasoft.plaf.synthetica.util.OverlayComposite;
import de.javasoft.plaf.synthetica.util.SoftBurnComposite;
import de.javasoft.plaf.synthetica.util.SoftLightComposite;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;

public class Synthetica2DUtils {
    private static final String SYNTHETICA_DEFAULT_BLEND_MODE = "Synthetica.background.defaultBlendMode";

    public static BufferedImage createBlurredImage(BufferedImage src, int size) {
        ConvolveOp co = Synthetica2DUtils.createBlurOp(size);
        BufferedImage dest = co.createCompatibleDestImage(src, src.getColorModel());
        co.filter(src, dest);
        return dest;
    }

    public static ConvolveOp createBlurOp(int size) {
        float[] data = new float[size * size];
        float value = 1.0f / (float)(size * size);
        int i = 0;
        while (i < data.length) {
            data[i] = value;
            ++i;
        }
        return new ConvolveOp(new Kernel(size, size, data));
    }

    public static BufferedImage createAlphaImage(BufferedImage src, float alpha) {
        BufferedImage dest = new BufferedImage(src.getWidth(), src.getHeight(), 2);
        Graphics2D g2d = (Graphics2D)dest.getGraphics();
        g2d.setComposite(AlphaComposite.getInstance(3, alpha));
        g2d.drawImage((Image)src, 0, 0, null);
        g2d.dispose();
        return dest;
    }

    public static BufferedImage createColorizedImage(BufferedImage src, Color color, float alpha) {
        BufferedImage dest = new BufferedImage(src.getWidth(), src.getHeight(), 2);
        Synthetica2DUtils.colorizeImage(src, dest, color, alpha);
        return dest;
    }

    public static void colorizeImage(BufferedImage src, BufferedImage dest, Color color, float alpha) {
        Graphics2D g2d = (Graphics2D)dest.getGraphics();
        g2d.drawImage((Image)src, 0, 0, null);
        g2d.setComposite(AlphaComposite.getInstance(10, alpha));
        g2d.setColor(color);
        g2d.fillRect(0, 0, dest.getWidth(), dest.getHeight());
        g2d.dispose();
    }

    public static BufferedImage createColorizedImage(BufferedImage src, Color color, String blendMode) {
        BufferedImage dest = new BufferedImage(src.getWidth(), src.getHeight(), 2);
        Synthetica2DUtils.colorizeImage(src, dest, color, blendMode);
        return dest;
    }

    public static void colorizeImage(BufferedImage src, BufferedImage dest, Color color, String blendMode) {
        Graphics2D g2d = (Graphics2D)dest.getGraphics();
        g2d.drawImage((Image)src, 0, 0, null);
        if (blendMode == null || BlendMode.MULTIPLY.toString().equals(blendMode)) {
            g2d.setComposite(MultiplyComposite.Multiply);
        } else if (BlendMode.COLOR_BURN.toString().equals(blendMode)) {
            g2d.setComposite(ColorBurnComposite.ColorBurn);
        } else if (BlendMode.LUMINOSITY.toString().equals(blendMode)) {
            g2d.setComposite(LuminosityComposite.Luminosity);
        } else if (BlendMode.OVERLAY.toString().equals(blendMode)) {
            g2d.setComposite(OverlayComposite.Overlay);
        } else if (BlendMode.SOFT_BURN.toString().equals(blendMode)) {
            g2d.setComposite(SoftBurnComposite.SolftBurn);
        } else if (BlendMode.SOFT_LIGHT.toString().equals(blendMode)) {
            g2d.setComposite(SoftLightComposite.SoftLight);
        } else if (BlendMode.LINEAR_LIGHT.toString().equals(blendMode)) {
            g2d.setComposite(LinearLightComposite.LinearLight);
        }
        Color col = new Color(color.getRed(), color.getGreen(), color.getBlue(), 0);
        g2d.setColor(col);
        g2d.fillRect(0, 0, dest.getWidth(), dest.getHeight());
        g2d.dispose();
    }

    public static Image flipHorizontal(Image image) {
        BufferedImage bi = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
        Graphics2D g2 = (Graphics2D)bi.getGraphics();
        g2.scale(-1.0, 1.0);
        g2.translate(-image.getWidth(null), 0);
        g2.drawImage(image, 0, 0, null);
        g2.dispose();
        return bi;
    }

    public static Image flipVertical(Image image) {
        BufferedImage bi = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
        Graphics2D g2 = (Graphics2D)bi.getGraphics();
        g2.scale(1.0, -1.0);
        g2.translate(0, -image.getHeight(null));
        g2.drawImage(image, 0, 0, null);
        g2.dispose();
        return bi;
    }

    public static Color blend(Color col1, Color col2, BlendMode blendMode) {
        int rgb = 0;
        if (blendMode == null) {
            if (col2.getAlpha() == 255) {
                BlendMode bm = BlendMode.valueOf(SyntheticaLookAndFeel.getString(SYNTHETICA_DEFAULT_BLEND_MODE, null, BlendMode.MULTIPLY.toString()));
                rgb = Synthetica2DUtils.blend(col1, col2, bm).getRGB();
            } else {
                rgb = Synthetica2DUtils.alphaBlend(col1.getRGB(), col2.getRGB());
            }
        } else if (blendMode == BlendMode.ALPHA) {
            rgb = Synthetica2DUtils.alphaBlend(col1.getRGB(), col2.getRGB());
        } else if (blendMode == BlendMode.COLOR_BURN) {
            rgb = Synthetica2DUtils.colorBurnBlend(col1.getRGB(), col2.getRGB());
        } else if (blendMode == BlendMode.LUMINOSITY) {
            rgb = Synthetica2DUtils.luminosityBlend(col1.getRGB(), col2.getRGB());
        } else if (blendMode == BlendMode.MULTIPLY) {
            rgb = Synthetica2DUtils.multiplyBlend(col1.getRGB(), col2.getRGB());
        } else if (blendMode == BlendMode.OVERLAY) {
            rgb = Synthetica2DUtils.overlayBlend(col1.getRGB(), col2.getRGB());
        } else if (blendMode == BlendMode.SOFT_BURN) {
            rgb = Synthetica2DUtils.softBurnBlend(col1.getRGB(), col2.getRGB());
        } else if (blendMode == BlendMode.SOFT_LIGHT) {
            rgb = Synthetica2DUtils.softLightBlend(col1.getRGB(), col2.getRGB());
        } else if (blendMode == BlendMode.LINEAR_LIGHT) {
            rgb = Synthetica2DUtils.linearLightBlend(col1.getRGB(), col2.getRGB());
        }
        return new Color(rgb);
    }

    private static int luminosityBlend(int rgb1, int rgb2) {
        return LuminosityComposite.luminostyRGB(rgb1, rgb2);
    }

    private static int multiplyBlend(int rgb1, int rgb2) {
        return MultiplyComposite.multiplyRGB(rgb1, rgb2);
    }

    private static int alphaBlend(int rgb1, int rgb2) {
        int a2 = rgb2 >> 24 & 0xFF;
        int b1 = rgb1 & 0xFF;
        int b2 = rgb2 & 0xFF;
        int b = (b2 * a2 + b1 * (255 - a2)) / 255;
        int g1 = rgb1 >> 8 & 0xFF;
        int g2 = rgb2 >> 8 & 0xFF;
        int g = (g2 * a2 + g1 * (255 - a2)) / 255;
        int r1 = rgb1 >> 16 & 0xFF;
        int r2 = rgb2 >> 16 & 0xFF;
        int r = (r2 * a2 + r1 * (255 - a2)) / 255;
        return b | g << 8 | r << 16 | 0xFF000000;
    }

    private static int colorBurnBlend(int rgb1, int rgb2) {
        return ColorBurnComposite.colorBurnRGB(rgb2, rgb1);
    }

    private static int overlayBlend(int rgb1, int rgb2) {
        return OverlayComposite.overlayRGB(rgb2, rgb1);
    }

    private static int softBurnBlend(int rgb1, int rgb2) {
        return SoftBurnComposite.softBurnRGB(rgb2, rgb1);
    }

    private static int softLightBlend(int rgb1, int rgb2) {
        return SoftLightComposite.softLightRGB(rgb2, rgb1);
    }

    private static int linearLightBlend(int rgb1, int rgb2) {
        return LinearLightComposite.linearLightRGB(rgb2, rgb1);
    }

    public static float[] RGBtoHSL(int r, int g, int b) {
        float S;
        float H;
        float max_;
        float min_;
        float[] hsl = new float[3];
        float r_ = (float)r / 255.0f;
        float g_ = (float)g / 255.0f;
        float b_ = (float)b / 255.0f;
        if (r_ > g_) {
            min_ = g_;
            max_ = r_;
        } else {
            min_ = r_;
            max_ = g_;
        }
        if (b_ > max_) {
            max_ = b_;
        }
        if (b_ < min_) {
            min_ = b_;
        }
        float max = max_ - min_;
        float L = (max_ + min_) / 2.0f;
        if (max - 0.01f <= 0.0f) {
            H = 0.0f;
            S = 0.0f;
        } else {
            S = L < 0.5f ? max / (max_ + min_) : max / (2.0f - max_ - min_);
            float del_R = ((max_ - r_) / 6.0f + max / 2.0f) / max;
            float del_G = ((max_ - g_) / 6.0f + max / 2.0f) / max;
            float del_B = ((max_ - b_) / 6.0f + max / 2.0f) / max;
            H = r_ == max_ ? del_B - del_G : (g_ == max_ ? 0.33333334f + del_R - del_B : 0.6666667f + del_G - del_R);
            if (H < 0.0f) {
                H += 1.0f;
            }
            if (H > 1.0f) {
                H -= 1.0f;
            }
        }
        hsl[0] = H;
        hsl[1] = S;
        hsl[2] = L;
        return hsl;
    }

    public static int[] HSLtoRGB(float h, float s, float l) {
        int b;
        int g;
        int r;
        int[] rgb = new int[3];
        if (s - 0.01f <= 0.0f) {
            r = (int)(l * 255.0f);
            g = (int)(l * 255.0f);
            b = (int)(l * 255.0f);
        } else {
            float val2 = l < 0.5f ? l * (1.0f + s) : l + s - s * l;
            float val1 = 2.0f * l - val2;
            r = (int)(255.0f * Synthetica2DUtils.hue2RGB(val1, val2, h + 0.33333334f));
            g = (int)(255.0f * Synthetica2DUtils.hue2RGB(val1, val2, h));
            b = (int)(255.0f * Synthetica2DUtils.hue2RGB(val1, val2, h - 0.33333334f));
        }
        rgb[0] = r;
        rgb[1] = g;
        rgb[2] = b;
        return rgb;
    }

    private static float hue2RGB(float v1, float v2, float vH) {
        if (vH < 0.0f) {
            vH += 1.0f;
        }
        if (vH > 1.0f) {
            vH -= 1.0f;
        }
        if (6.0f * vH < 1.0f) {
            return v1 + (v2 - v1) * 6.0f * vH;
        }
        if (2.0f * vH < 1.0f) {
            return v2;
        }
        if (3.0f * vH < 2.0f) {
            return v1 + (v2 - v1) * (0.6666667f - vH) * 6.0f;
        }
        return v1;
    }

    public static int rgb2lum(int rgb) {
        int b1 = rgb & 0xFF;
        int g1 = rgb >> 8 & 0xFF;
        int r1 = rgb >> 16 & 0xFF;
        return Math.min(255, (int)((float)b1 * 0.11f + (float)g1 * 0.59f + (float)r1 * 0.3f));
    }

    public static enum BlendMode {
        ALPHA,
        COLOR_BURN,
        LUMINOSITY,
        MULTIPLY,
        OVERLAY,
        SOFT_BURN,
        SOFT_LIGHT,
        LINEAR_LIGHT;

    }
}

