/*
 * Decompiled with CFR 0.152.
 */
package com.treemap;

import com.macrofocus.geom.Rectangle2D;
import com.macrofocus.geom.Shape;
import com.treemap.AbstractAlgorithm;
import com.treemap.MutableTreeMapNode;
import com.treemap.TreeMapModel;
import com.treemap.TreeMapWorker;

public class BarAlgorithm<N, Row, Column, Color, Font>
extends AbstractAlgorithm<N, Row, Column, Color, Font> {
    private final Orientation a;
    private final double b;

    public BarAlgorithm() {
        this(0.0, Orientation.Horizontal);
    }

    public BarAlgorithm(double marginProportion, Orientation orientation) {
        this.b = marginProportion;
        this.a = orientation;
    }

    @Override
    public Iterable<N> iterator(TreeMapModel<N, Row, Column, Color, Font> model, N root) {
        return model.depthFirstIterator(root);
    }

    @Override
    public boolean breadthFirstLayout(Shape shape, MutableTreeMapNode parent, MutableTreeMapNode[] children, double sumSizes, int horizontalVanishingPoint, int verticalVanishingPoint, TreeMapWorker worker) {
        Rectangle2D rectangle2D = shape.getBounds2D();
        double d2 = 0.0;
        int n2 = 0;
        for (MutableTreeMapNode mutableTreeMapNode : children) {
            if (mutableTreeMapNode.getSize() > d2) {
                d2 = mutableTreeMapNode.getSize();
            }
            if (!(mutableTreeMapNode.getSize() > 0.0)) continue;
            ++n2;
        }
        switch (this.a) {
            case Vertical: {
                double d3 = rectangle2D.getHeight() * this.b / (double)n2;
                double d4 = rectangle2D.getHeight() * (1.0 - this.b) / (double)n2;
                double d5 = rectangle2D.getMinY() + d3 / 2.0;
                for (MutableTreeMapNode mutableTreeMapNode : children) {
                    if (mutableTreeMapNode.getSize() > 0.0) {
                        double d6 = rectangle2D.getWidth() * mutableTreeMapNode.getSize() / d2;
                        mutableTreeMapNode.setShape((Shape)new Rectangle2D.Double(0.0, d5, d6, d4));
                        d5 += d4 + d3;
                        continue;
                    }
                    mutableTreeMapNode.setShape(null);
                }
                break;
            }
            case Horizontal: {
                double d7 = rectangle2D.getWidth() * this.b / (double)n2;
                double d8 = rectangle2D.getWidth() * (1.0 - this.b) / (double)n2;
                double d9 = rectangle2D.getMinX() + d7 / 2.0;
                for (MutableTreeMapNode mutableTreeMapNode : children) {
                    if (mutableTreeMapNode.getSize() > 0.0) {
                        double d10 = rectangle2D.getHeight() * mutableTreeMapNode.getSize() / d2;
                        mutableTreeMapNode.setShape((Shape)new Rectangle2D.Double(d9, rectangle2D.getMaxY() - d10, d8, d10));
                        d9 += d8 + d7;
                        continue;
                    }
                    mutableTreeMapNode.setShape(null);
                }
                break;
            }
        }
        return false;
    }

    @Override
    public boolean isCompatible(Shape shape) {
        return shape instanceof Rectangle2D;
    }

    @Override
    public boolean isSpaceFilling() {
        return false;
    }

    public String toString() {
        return "Bar";
    }

    public static enum Orientation {
        Vertical,
        Horizontal;

    }
}

