/*
 * Decompiled with CFR 0.152.
 */
package com.treemap;

import com.macrofocus.common.properties.MutableProperties;
import com.macrofocus.geom.AffineTransform;
import com.macrofocus.geom.Ellipse2D;
import com.macrofocus.geom.Point2D;
import com.macrofocus.geom.Rectangle2D;
import com.macrofocus.geom.Shape;
import com.treemap.Algorithm;
import com.treemap.EqualCirclesInCircle;
import com.treemap.MutableTreeMapNode;
import com.treemap.TreeMapModel;
import com.treemap.TreeMapWorker;
import java.util.ArrayList;
import java.util.Collections;

class CircularAlgorithm<N, Row, Column, Color, Font>
implements Algorithm<N, Row, Column, Color, Font> {
    protected int verticalAlignment = 0;
    protected int horizontalAlignment = 0;

    @Override
    public MutableProperties getProperties() {
        return null;
    }

    @Override
    public Iterable iterator(TreeMapModel<N, Row, Column, Color, Font> model, N root) {
        return model.depthFirstIterator(root);
    }

    @Override
    public void startLayout(Rectangle2D bounds, TreeMapModel<N, Row, Column, Color, Font> model, N root, TreeMapWorker worker) {
    }

    @Override
    public boolean depthFirstLayout(Shape shape, MutableTreeMapNode parent, MutableTreeMapNode[] children, double sumSizes, int horizontalVanishingPoint, int verticalVanishingPoint, TreeMapWorker worker) {
        Object object;
        Object object2;
        Circle circle;
        boolean bl = true;
        Double d2 = null;
        ArrayList<Circle> arrayList = new ArrayList<Circle>();
        for (MutableTreeMapNode mutableTreeMapNode : children) {
            circle = new Circle();
            if (mutableTreeMapNode.hasNoChildren()) {
                circle.radius = Math.max(0.0, Math.sqrt(mutableTreeMapNode.getSize() / Math.PI));
            } else {
                Shape shape2 = mutableTreeMapNode.getShape();
                if (shape2 != null) {
                    if (shape2 instanceof Ellipse2D) {
                        object2 = (Ellipse2D)shape2;
                        circle.radius = object2.getWidth() / 2.0;
                    } else {
                        circle.radius = Math.max(0.0, Math.sqrt(mutableTreeMapNode.getSize() / Math.PI));
                    }
                } else {
                    circle.radius = Math.max(0.0, Math.sqrt(mutableTreeMapNode.getSize() / Math.PI));
                }
            }
            if (bl) {
                if (d2 == null) {
                    d2 = circle.radius;
                } else if (d2 != circle.radius) {
                    bl = false;
                }
            }
            arrayList.add(circle);
        }
        if (bl && arrayList.size() > 1 && arrayList.size() <= EqualCirclesInCircle.a.length) {
            object = EqualCirclesInCircle.a[arrayList.size() - 1];
            double d3 = EqualCirclesInCircle.b[arrayList.size() - 1];
            double d4 = d2;
            for (int i2 = 0; i2 < arrayList.size(); ++i2) {
                object2 = arrayList.get(i2);
                object2.cx = (double)object[i2 * 2] / d3 * d4;
                object2.cy = (double)object[i2 * 2 + 1] / d3 * d4;
            }
        } else {
            CircularAlgorithm.a(arrayList);
        }
        object = CircularAlgorithm.b(arrayList);
        for (Circle circle2 : arrayList) {
            circle2.cx -= ((Circle)object).cx;
            circle2.cy -= ((Circle)object).cy;
        }
        object = CircularAlgorithm.b(arrayList);
        if (shape == null) {
            if (object != null && !Double.isNaN(((Circle)object).radius)) {
                Rectangle2D rectangle2D = ((Circle)object).getBounds2D();
                parent.setShape((Shape)new Ellipse2D.Double(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight()));
            } else {
                parent.setShape(null);
            }
        }
        for (int i3 = 0; i3 < children.length; ++i3) {
            Circle circle3 = arrayList.get(i3);
            MutableTreeMapNode mutableTreeMapNode = children[i3];
            if (circle3 != null && !Double.isNaN(circle3.radius) && circle3.radius > 0.0) {
                circle = circle3.getBounds2D();
                mutableTreeMapNode.setShape((Shape)new Ellipse2D.Double(circle.getX(), circle.getY(), circle.getWidth(), circle.getHeight()));
                continue;
            }
            mutableTreeMapNode.setShape(null);
        }
        return false;
    }

    @Override
    public boolean breadthFirstLayout(Shape shape, MutableTreeMapNode parent, MutableTreeMapNode[] children, double sumSizes, int horizontalVanishingPoint, int verticalVanishingPoint, TreeMapWorker worker) {
        Rectangle2D rectangle2D = shape.getBounds2D();
        Rectangle2D rectangle2D2 = this.a(children);
        if (rectangle2D2 != null) {
            double d2 = Math.min(rectangle2D.getWidth(), rectangle2D.getHeight());
            double d3 = d2 / rectangle2D2.getWidth();
            double d4 = d2 / rectangle2D2.getHeight();
            for (MutableTreeMapNode mutableTreeMapNode : children) {
                double d5 = -rectangle2D2.getMinX() * d3 + rectangle2D.getX();
                double d6 = -rectangle2D2.getMinY() * d4 + rectangle2D.getY();
                switch (this.horizontalAlignment) {
                    case 0: {
                        d5 += (rectangle2D.getWidth() - d2) / 2.0;
                        break;
                    }
                    case 2: {
                        d5 += rectangle2D.getWidth() - d2;
                    }
                }
                switch (this.verticalAlignment) {
                    case 0: {
                        d6 += (rectangle2D.getHeight() - d2) / 2.0;
                        break;
                    }
                    case 3: {
                        d6 += rectangle2D.getHeight() - d2;
                    }
                }
                AffineTransform affineTransform = new AffineTransform(d3, 0.0, 0.0, d4, d5, d6);
                Shape shape2 = mutableTreeMapNode.getShape();
                if (shape2 != null) {
                    Rectangle2D rectangle2D3 = shape2.getBounds2D();
                    Shape shape3 = affineTransform.createTransformedShape((Shape)rectangle2D3);
                    Rectangle2D rectangle2D4 = shape3.getBounds2D();
                    mutableTreeMapNode.setShape((Shape)new Ellipse2D.Double(rectangle2D4.getX(), rectangle2D4.getY(), rectangle2D4.getWidth(), rectangle2D4.getHeight()));
                    continue;
                }
                mutableTreeMapNode.setShape(null);
            }
        } else {
            for (MutableTreeMapNode mutableTreeMapNode : children) {
                mutableTreeMapNode.setShape(null);
            }
        }
        return false;
    }

    private Rectangle2D a(MutableTreeMapNode[] mutableTreeMapNodeArray) {
        ArrayList<Circle> arrayList = new ArrayList<Circle>();
        for (MutableTreeMapNode mutableTreeMapNode : mutableTreeMapNodeArray) {
            Shape shape = mutableTreeMapNode.getShape();
            if (shape == null || !(shape instanceof Ellipse2D)) continue;
            Ellipse2D ellipse2D = (Ellipse2D)shape;
            Circle circle = new Circle(ellipse2D.getCenterX(), ellipse2D.getCenterY(), ellipse2D.getWidth() / 2.0);
            arrayList.add(circle);
        }
        if (arrayList.size() > 0) {
            Circle circle = CircularAlgorithm.b(arrayList);
            Rectangle2D rectangle2D = circle.getBounds2D();
            return new Ellipse2D.Double(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight()).getBounds2D();
        }
        return null;
    }

    @Override
    public void finishLayout(Rectangle2D bounds, TreeMapModel<N, Row, Column, Color, Font> model, N root) {
    }

    @Override
    public boolean isCompatible(Shape shape) {
        return shape instanceof Rectangle2D || shape instanceof Ellipse2D;
    }

    @Override
    public boolean isRenderingLeafLabelsSupported() {
        return true;
    }

    @Override
    public boolean isRenderingParentLabelSupported() {
        return true;
    }

    @Override
    public boolean isChildContained() {
        return true;
    }

    @Override
    public boolean isColorParent() {
        return false;
    }

    @Override
    public boolean isSpaceFilling() {
        return false;
    }

    String a() {
        return "Circular";
    }

    public String toString() {
        return this.a();
    }

    private static void a(ArrayList<Circle> arrayList) {
        double d2 = 0.01;
        switch (arrayList.size()) {
            case 0: {
                break;
            }
            case 1: {
                Circle circle = arrayList.get(0);
                circle.cx = 0.0;
                circle.cy = 0.0;
                break;
            }
            case 2: {
                Circle circle = arrayList.get(0);
                Circle circle2 = arrayList.get(1);
                double d3 = circle.radius + circle2.radius;
                circle.cx = circle.radius - d3;
                circle2.cx = d3 - circle2.radius;
                circle2.cy = 0.0;
                circle.cy = 0.0;
                break;
            }
            case 4: {
                ArrayList arrayList2 = (ArrayList)arrayList.clone();
                Collections.sort(arrayList2);
                if (((Circle)arrayList2.get((int)0)).radius / ((Circle)arrayList2.get((int)3)).radius < 1.3) {
                    Circle circle = (Circle)arrayList2.get(0);
                    Circle circle3 = (Circle)arrayList2.get(1);
                    Circle circle4 = (Circle)arrayList2.get(2);
                    Circle circle5 = (Circle)arrayList2.get(3);
                    circle.cx = circle.cy = -circle.radius;
                    circle3.cx = circle3.cy = circle3.radius;
                    circle4.cx = circle4.radius;
                    circle4.cy = -circle4.radius;
                    circle5.cx = -circle5.radius;
                    circle5.cy = circle5.radius;
                    break;
                }
            }
            default: {
                ArrayList arrayList2 = (ArrayList)arrayList.clone();
                Collections.sort(arrayList2);
                Circle circle = (Circle)arrayList2.get(0);
                Circle circle6 = (Circle)arrayList2.get(1);
                Circle circle7 = (Circle)arrayList2.get(2);
                double d4 = circle.radius + circle7.radius;
                double d5 = circle.radius + circle6.radius;
                double d6 = Math.sqrt(circle.radius * circle6.radius * circle7.radius * (circle.radius + circle6.radius + circle7.radius));
                double d7 = 2.0 * d6 / d5;
                circle.cx = -circle.radius;
                circle.cy = 0.0;
                circle6.cx = circle6.radius;
                circle6.cy = 0.0;
                circle7.cx = circle.cx + Math.sqrt(d4 * d4 - d7 * d7);
                circle7.cy = d7;
                Point2D.Double double_ = new Point2D.Double();
                AffineTransform affineTransform = new AffineTransform();
                double d8 = circle.radius - circle6.radius;
                circle.cx += d8;
                circle6.cx += d8;
                circle7.cx += d8;
                if (arrayList2.size() <= 3) break;
                double d9 = ((Circle)arrayList2.get((int)(arrayList2.size() - 1))).radius;
                ArrayList<Pair> arrayList3 = new ArrayList<Pair>();
                arrayList3.add(new Pair(circle6, circle));
                arrayList3.add(new Pair(circle, circle7));
                arrayList3.add(new Pair(circle7, circle6));
                double d10 = CircularAlgorithm.a(circle.radius, circle6.radius, circle7.radius);
                if (d10 >= d9) {
                    arrayList3.add(new Pair(circle, circle6, d10));
                    arrayList3.add(new Pair(circle7, circle, d10));
                    arrayList3.add(new Pair(circle6, circle7, d10));
                }
                Point2D.Double double_2 = new Point2D.Double();
                for (int i2 = 3; i2 < arrayList2.size(); ++i2) {
                    circle7 = (Circle)arrayList2.get(i2);
                    double_2.x = Double.MAX_VALUE;
                    double_2.y = Double.MAX_VALUE;
                    int n2 = -1;
                    for (int i3 = 0; i3 < arrayList3.size(); ++i3) {
                        boolean bl;
                        Pair pair = (Pair)arrayList3.get(i3);
                        if (pair.innerSoddyRadius < circle7.radius - 0.01) {
                            bl = true;
                        } else {
                            circle = pair.ca;
                            circle6 = pair.cb;
                            d4 = circle.radius + circle7.radius;
                            d5 = circle.radius + circle6.radius;
                            d6 = Math.sqrt(circle.radius * circle6.radius * circle7.radius * (circle.radius + circle6.radius + circle7.radius));
                            d7 = 2.0 * d6 / d5;
                            double_.x = Math.sqrt(d4 * d4 - d7 * d7);
                            double_.y = d7;
                            double d11 = Math.atan2(circle6.cy - circle.cy, circle6.cx - circle.cx);
                            affineTransform.setToIdentity();
                            affineTransform.translate(circle.cx, circle.cy);
                            affineTransform.rotate(d11);
                            affineTransform.transform((Point2D)double_, (Point2D)double_);
                            if (double_.x * double_.x + double_.y * double_.y >= double_2.x * double_2.x + double_2.y * double_2.y) {
                                bl = true;
                            } else {
                                bl = false;
                                circle7.cx = double_.x;
                                circle7.cy = double_.y;
                                for (int i4 = 0; i4 < i2; ++i4) {
                                    if (!circle7.intersects((Circle)arrayList2.get(i4), 0.01)) continue;
                                    pair.innerSoddyRadius = circle7.getIntersectionRadius((Circle)arrayList2.get(i4));
                                    bl = true;
                                    break;
                                }
                            }
                        }
                        if (bl || !(circle7.cx * circle7.cx + circle7.cy * circle7.cy < double_2.x * double_2.x + double_2.y * double_2.y)) continue;
                        double_2.x = circle7.cx;
                        double_2.y = circle7.cy;
                        n2 = i3;
                    }
                    if (n2 < 0) continue;
                    circle7.cx = double_2.x;
                    circle7.cy = double_2.y;
                    circle = ((Pair)arrayList3.get((int)n2)).ca;
                    circle6 = ((Pair)arrayList3.get((int)n2)).cb;
                    d10 = CircularAlgorithm.a(circle.radius, circle6.radius, circle7.radius);
                    if (d10 >= d9) {
                        ((Pair)arrayList3.get((int)n2)).innerSoddyRadius = d10;
                        arrayList3.add(new Pair(circle7, circle, d10));
                        arrayList3.add(new Pair(circle6, circle7, d10));
                    } else {
                        arrayList3.remove(n2);
                    }
                    arrayList3.add(new Pair(circle, circle7));
                    arrayList3.add(new Pair(circle7, circle6));
                }
            }
        }
    }

    private static double a(double d2, double d3, double d4) {
        return d2 * d3 * d4 / (d2 * d4 + d2 * d3 + d3 * d4 + Math.sqrt(4.0 * d2 * d3 * d4 * (d2 + d3 + d4)));
    }

    private static Circle a(Circle circle, Circle circle2, Circle circle3) {
        double d2 = circle.radius;
        double d3 = circle2.radius;
        double d4 = circle3.radius;
        double d5 = 1.0 / d2;
        double d6 = 1.0 / d3;
        double d7 = 1.0 / d4;
        double d8 = Math.abs(d5 + d6 + d7 - 2.0 * Math.sqrt(d5 * d6 + d6 * d7 + d7 * d5));
        a a2 = new a(d5, 0.0).c(new a(circle.cx, circle.cy));
        a a3 = new a(d6, 0.0).c(new a(circle2.cx, circle2.cy));
        a a4 = new a(d7, 0.0).c(new a(circle3.cx, circle3.cy));
        a a5 = a2.a(a3).a(a4).b(new a(2.0, 0.0).c(a2.c(a3).a(a3.c(a4)).a(a4.c(a2)).e()));
        a a6 = a5.d(new a(d8, 0.0));
        if (a6.f() || Double.isNaN(1.0 / d8)) {
            return new Circle();
        }
        return new Circle(-a6.a(), -a6.b(), 1.0 / d8);
    }

    private static Circle b(ArrayList<Circle> arrayList) {
        Circle circle3;
        Circle circle2 = null;
        if (arrayList.size() >= 3) {
            circle2 = CircularAlgorithm.a(arrayList.get(0), arrayList.get(1), arrayList.get(2));
            for (Circle circle3 : arrayList) {
                double d2 = Math.sqrt((circle2.cx - circle3.cx) * (circle2.cx - circle3.cx) + (circle2.cy - circle3.cy) * (circle2.cy - circle3.cy));
                circle2.radius = Math.max(circle2.radius, d2 + circle3.radius);
            }
        }
        Rectangle2D.Double double_ = CircularAlgorithm.c(arrayList);
        circle3 = new Circle(double_.getCenterX(), double_.getCenterY(), Math.max(double_.getWidth(), double_.getHeight()) / 2.0);
        for (Circle circle4 : arrayList) {
            double d3 = Math.sqrt((circle3.cx - circle4.cx) * (circle3.cx - circle4.cx) + (circle3.cy - circle4.cy) * (circle3.cy - circle4.cy));
            circle3.radius = Math.max(circle3.radius, d3 + circle4.radius);
        }
        return circle2 == null || circle3.radius < circle2.radius ? circle3 : circle2;
    }

    private static Rectangle2D.Double c(ArrayList<Circle> arrayList) {
        double d2 = Double.MAX_VALUE;
        double d3 = Double.MIN_VALUE;
        double d4 = Double.MAX_VALUE;
        double d5 = Double.MIN_VALUE;
        for (Circle circle : arrayList) {
            d2 = Math.min(d2, circle.cx - circle.radius);
            d3 = Math.max(d3, circle.cx + circle.radius);
            d4 = Math.min(d4, circle.cy - circle.radius);
            d5 = Math.max(d5, circle.cy + circle.radius);
        }
        return new Rectangle2D.Double(d2, d4, d3 - d2, d5 - d4);
    }

    private static final class a {
        private final double a;
        private final double b;

        public a(double d2, double d3) {
            this.a = d2;
            this.b = d3;
        }

        public double a() {
            return this.a;
        }

        public double b() {
            return this.b;
        }

        public a a(a a2) {
            return new a(this.a + a2.a, this.b + a2.b);
        }

        public a b(a a2) {
            return new a(this.a - a2.a, this.b - a2.b);
        }

        public a c(a a2) {
            return new a(this.a * a2.a - this.b * a2.b, this.a * a2.b + this.b * a2.a);
        }

        public a d(a a2) {
            return new a((this.a * a2.a + this.b * a2.b) / (a2.a * a2.a + a2.b * a2.b), (this.b * a2.a - this.a * a2.b) / (a2.a * a2.a + a2.b * a2.b));
        }

        double c() {
            return Math.atan2(this.b, this.a);
        }

        double d() {
            return Math.sqrt(this.a * this.a + this.b * this.b);
        }

        public a e() {
            double d2 = Math.sqrt(this.d());
            double d3 = this.c() / 2.0;
            return new a(d2 * Math.cos(d3), d2 * Math.sin(d3));
        }

        public boolean equals(Object o2) {
            if (o2 instanceof a) {
                a a2 = (a)o2;
                return a2.a == this.a && a2.b == this.b;
            }
            return false;
        }

        public int hashCode() {
            long l2 = Double.doubleToLongBits(this.a);
            return (int)(l2 ^= Double.doubleToLongBits(this.b) * 31L) ^ (int)(l2 >> 32);
        }

        public String toString() {
            if (this.b >= 0.0) {
                return "(" + this.a + "+" + this.b + "i)";
            }
            return "(" + this.a + "" + this.b + "i)";
        }

        public boolean f() {
            return Double.isNaN(this.a) || Double.isNaN(this.b);
        }
    }

    private static final class Circle
    implements Comparable<Circle> {
        public double cx;
        public double cy;
        public double radius;

        public Circle() {
        }

        public Circle(double cx, double cy, double r2) {
            this.cx = cx;
            this.cy = cy;
            this.radius = r2;
        }

        public boolean intersects(Circle that, double error) {
            double d2 = (this.cx - that.cx) * (this.cx - that.cx) + (this.cy - that.cy) * (this.cy - that.cy);
            return d2 < (this.radius + that.radius) * (this.radius + that.radius) - error;
        }

        public double getIntersectionRadius(Circle that) {
            double d2 = (this.cx - that.cx) * (this.cx - that.cx) + (this.cy - that.cy) * (this.cy - that.cy);
            return Math.sqrt(d2) - that.radius;
        }

        public Rectangle2D getBounds2D() {
            return new Rectangle2D.Double(this.cx - this.radius, this.cy - this.radius, this.radius * 2.0, this.radius * 2.0);
        }

        @Override
        public int compareTo(Circle c2) {
            double d2 = this.radius - c2.radius;
            return d2 < 0.0 ? 1 : (d2 > 0.0 ? -1 : 0);
        }

        public String toString() {
            return this.getClass() + "[x:" + this.cx + ",y:" + this.cy + ",r:" + this.radius + "]";
        }
    }

    private static class Pair {
        public final Circle ca;
        public final Circle cb;
        public double innerSoddyRadius = Double.MAX_VALUE;

        public Pair(Circle ca, Circle cb) {
            this.ca = ca;
            this.cb = cb;
        }

        public Pair(Circle ca, Circle cb, double innerSoddyRadius) {
            this.ca = ca;
            this.cb = cb;
            this.innerSoddyRadius = innerSoddyRadius;
        }
    }
}

