/*
 * Decompiled with CFR 0.152.
 */
package com.treemap;

import com.macrofocus.common.geom.Dimension;
import com.macrofocus.data.type.HtmlString;
import com.macrofocus.igraphics.Insets;
import com.macrofocus.labeling.EnhancedLabel;
import com.treemap.TreeMapField;
import com.treemap.TreeMapFieldSettings;
import com.treemap.TreeMapLabelRenderer;
import com.treemap.TreeMapView;

public class DefaultTreeMapLabelRenderer<C, N, Row, Column, Color, Font>
extends EnhancedLabel<Color, Font>
implements TreeMapLabelRenderer<C, N, Row, Column, Color, Font> {
    private static final Insets a = new Insets(0, 2, 0, 1);

    public DefaultTreeMapLabelRenderer() {
        this.setOpaque(false);
        this.setName("TreeMap.labelRenderer");
        this.setEffect(EnhancedLabel.Effect.Plain);
        this.setHorizontalAlignment(2);
        this.setRendering(EnhancedLabel.Rendering.Clip);
    }

    @Override
    public EnhancedLabel<Color, Font> getTreeMapLabelRendererComponent(TreeMapView<C, N, Row, Column, Color, Font> view, TreeMapField<N, Column> field, N node, Dimension dimension) {
        Float f2;
        Integer n2;
        EnhancedLabel.Rendering rendering;
        Integer n3;
        Integer n4;
        String string = view.getModel().getStringValue(node, field);
        this.setInsets(DefaultTreeMapLabelRenderer.a.top, DefaultTreeMapLabelRenderer.a.left, DefaultTreeMapLabelRenderer.a.bottom, DefaultTreeMapLabelRenderer.a.right);
        this.setText(string);
        this.setHTML(field.getType() == HtmlString.class);
        TreeMapFieldSettings<Color, Font> treeMapFieldSettings = view.getModel().getSettings().getFieldSettings(field);
        EnhancedLabel.Effect effect = treeMapFieldSettings.getLabelingEffect();
        if (effect != null) {
            this.setEffect(effect);
        }
        if ((n4 = Integer.valueOf(treeMapFieldSettings.getLabelingHorizontalAlignment())) != null) {
            this.setHorizontalAlignment(n4);
        }
        if ((n3 = Integer.valueOf(treeMapFieldSettings.getLabelingVerticalAlignment())) != null) {
            this.setVerticalAlignment(n3);
        }
        if ((rendering = treeMapFieldSettings.getLabelingRendering()) != null) {
            this.setRendering(rendering);
        }
        if ((n2 = treeMapFieldSettings.getLabelingMinimumCharactersToDisplay()) != null) {
            this.setMinimumCharactersToDisplay(n2);
        }
        if ((f2 = treeMapFieldSettings.getLabelingEffectOpacity()) != null) {
            this.setEffectOpacity(f2.floatValue());
        }
        this.setDesiredWidth(dimension.width);
        this.setDesiredHeight(dimension.height);
        return this;
    }
}

