/*
 * Decompiled with CFR 0.152.
 */
package com.treemap;

import com.macrofocus.common.geom.Dimension;
import com.macrofocus.geom.Arc2D;
import com.macrofocus.geom.Point2D;
import com.macrofocus.geom.Rectangle;
import com.macrofocus.geom.Shape;
import com.macrofocus.igraphics.CPColor;
import com.macrofocus.igraphics.CPFont;
import com.macrofocus.labeling.EnhancedLabel;
import com.treemap.AbstractLabeling;
import com.treemap.TreeMapFieldSettings;
import com.treemap.TreeMapModel;
import com.treemap.TreeMapView;
import com.treemap.crossplatform.TGraphics;
import jsinterop.annotations.JsType;

@JsType
public class OverlayLabeling<N, Row, Column, Color, Font>
extends AbstractLabeling<N, Row, Column, Color, Font> {
    @Override
    public void paintParent(TGraphics<Color, Font> g2, Rectangle bounds, N node, TreeMapView view, int pass, int passes) {
        if (pass == passes - 1) {
            Rectangle rectangle;
            TreeMapModel treeMapModel = view.getModel();
            TreeMapFieldSettings treeMapFieldSettings = treeMapModel.getSettings().getFieldSettings(treeMapModel.getGroupByField(node));
            CPFont cPFont = treeMapFieldSettings.getHeaderFont();
            double d2 = cPFont.getSize2D() * (double)(1.0f + (view.getZoomFactor() - 1.0f) * 0.15f);
            EnhancedLabel enhancedLabel = view.getHeaderRenderer().getTreeMapHeaderRendererComponent(treeMapModel, node, new Dimension(bounds.width, bounds.height));
            CPColor cPColor = treeMapFieldSettings.getHeaderForeground();
            CPColor cPColor2 = treeMapFieldSettings.getHeaderEffectColor();
            CPFont cPFont2 = d2 != cPFont.getSize2D() ? cPFont.deriveFontSize(d2) : cPFont;
            enhancedLabel.setFont(cPFont2);
            enhancedLabel.setForeground(cPColor);
            enhancedLabel.setBackground(cPColor2 == null ? null : cPColor2.brighter());
            Shape shape = treeMapModel.getShape(node);
            Point2D point2D = shape instanceof Arc2D ? OverlayLabeling.getCentroid(shape) : null;
            if (point2D != null) {
                Dimension dimension = g2.sizeLabel(enhancedLabel, bounds.width, bounds.height).getPreferredSize();
                int n2 = dimension.width;
                if (shape instanceof Arc2D) {
                    Arc2D arc2D = (Arc2D)shape;
                    Point2D point2D2 = arc2D.getStartPoint();
                    Point2D point2D3 = arc2D.getEndPoint();
                    Point2D.Double double_ = new Point2D.Double((double)view.worldToScreenX(point2D2.getX()), (double)view.worldToScreenY(point2D2.getY()));
                    Point2D.Double double_2 = new Point2D.Double((double)view.worldToScreenX(point2D3.getX()), (double)view.worldToScreenY(point2D3.getY()));
                    n2 = (int)Math.min(double_.distance((Point2D)double_2), (double)n2);
                }
                int n3 = dimension.height;
                int n4 = view.worldToScreenX(point2D.getX()) - n2 / 2;
                int n5 = view.worldToScreenY(point2D.getY()) - n3 / 2;
                rectangle = new Rectangle(n4, n5, n2, n3).intersection(bounds);
            } else {
                Shape shape2 = treeMapModel.getNestedShape(node);
                rectangle = view.worldToScreenRectangle(shape2.getBounds2D());
            }
            g2.paintLabel(enhancedLabel, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    @Override
    public double getTopHeaderSpacing(N parent, N node, TreeMapView view, TreeMapModel model) {
        TreeMapFieldSettings treeMapFieldSettings;
        Integer n2;
        if (!model.isRoot(parent) && (n2 = (treeMapFieldSettings = model.getSettings().getFieldSettings(model.getGroupByField(parent))).getHeaderVerticalAlignment()) == 1 && model.getNestedShape(parent).getBounds2D().getY() == model.getBounds(node).getY()) {
            CPFont cPFont = treeMapFieldSettings.getHeaderFont();
            double d2 = cPFont.getSize2D() * (double)(1.0f + (view.getZoomFactor() - 1.0f) * 0.15f);
            if (cPFont.getSize2D() != d2) {
                cPFont = cPFont.deriveFontSize(d2);
            }
            return cPFont.getSize2D();
        }
        return 0.0;
    }

    public String toString() {
        return "Overlay";
    }
}

