/*
 * Decompiled with CFR 0.152.
 */
package com.treemap;

import com.macrofocus.geom.Arc2D;
import com.macrofocus.geom.Ellipse2D;
import com.macrofocus.geom.Rectangle2D;
import com.macrofocus.geom.Shape;
import com.treemap.AbstractAlgorithm;
import com.treemap.MutableTreeMapNode;
import com.treemap.TreeMapModel;
import com.treemap.TreeMapWorker;

public class PieAlgorithm<N, Row, Column, Color, Font>
extends AbstractAlgorithm<N, Row, Column, Color, Font> {
    @Override
    public Iterable<N> iterator(TreeMapModel<N, Row, Column, Color, Font> model, N root) {
        return model.depthFirstIterator(root);
    }

    @Override
    public boolean breadthFirstLayout(Shape shape, MutableTreeMapNode parent, MutableTreeMapNode[] children, double sumSizes, int horizontalVanishingPoint, int verticalVanishingPoint, TreeMapWorker worker) {
        Rectangle2D rectangle2D = shape.getBounds2D();
        double d2 = Math.min(rectangle2D.getWidth(), rectangle2D.getHeight());
        double d3 = (rectangle2D.getWidth() - d2) / 2.0;
        double d4 = (rectangle2D.getHeight() - d2) / 2.0;
        rectangle2D = new Rectangle2D.Double(rectangle2D.getX() + d3, rectangle2D.getY() + d4, d2, d2);
        double d5 = 90.0;
        for (MutableTreeMapNode mutableTreeMapNode : children) {
            double d6 = mutableTreeMapNode.getSize() * 360.0 / sumSizes;
            mutableTreeMapNode.setShape((Shape)new Arc2D.Double(rectangle2D, d5, -d6, 2));
            d5 -= d6;
        }
        return false;
    }

    @Override
    public boolean isCompatible(Shape shape) {
        return shape instanceof Rectangle2D || shape instanceof Ellipse2D;
    }

    @Override
    public boolean isSpaceFilling() {
        return false;
    }

    public String toString() {
        return "Pie";
    }
}

