/*
 * Decompiled with CFR 0.152.
 */
package com.treemap;

import com.macrofocus.common.annotations.GwtIncompatible;
import com.macrofocus.common.properties.MutableProperties;
import com.macrofocus.common.properties.MutableProperty;
import com.macrofocus.common.properties.SimpleProperties;
import com.macrofocus.geom.Rectangle2D;
import com.macrofocus.geom.Shape;
import com.treemap.AbstractAlgorithm;
import com.treemap.AbstractTreeMapNode;
import com.treemap.Algorithm;
import com.treemap.LeafTreeMapNode;
import com.treemap.MutableTreeMapNode;
import com.treemap.SquarifiedAlgorithm;
import com.treemap.TreeMapNode;
import com.treemap.TreeMapWorker;

public class SquarifiedPlusAlgorithm
extends AbstractAlgorithm {
    private final MutableProperties a = new SimpleProperties();
    private final MutableProperty<Double> b = this.a.createProperty((Object)"desiredAspectRatio", (Object)1.0);

    @Override
    public MutableProperties getProperties() {
        return this.a;
    }

    @Override
    public boolean breadthFirstLayout(Shape shape, MutableTreeMapNode parent, MutableTreeMapNode[] children, double sumSize, int horizontalVanishingPoint, int verticalVanishingPoint, TreeMapWorker worker) {
        Rectangle2D rectangle2D = shape.getBounds2D();
        int n2 = horizontalVanishingPoint == 0 ? 4 : horizontalVanishingPoint;
        int n3 = verticalVanishingPoint == 0 ? 3 : verticalVanishingPoint;
        double d2 = rectangle2D.getWidth() * rectangle2D.getHeight() / sumSize;
        int n4 = 0;
        while (n4 < children.length) {
            double d3;
            double d4;
            int n5;
            double d5;
            double d6 = 0.0;
            double d7 = Double.POSITIVE_INFINITY;
            double d8 = 0.0;
            boolean bl = rectangle2D.getWidth() > rectangle2D.getHeight() * (Double)this.b.getValue();
            double d9 = bl ? rectangle2D.getHeight() : rectangle2D.getWidth();
            double d10 = d5 = bl ? rectangle2D.getWidth() : rectangle2D.getHeight();
            for (n5 = n4; n5 < children.length; ++n5) {
                d4 = children[n5].getSize() * d2;
                d8 = (d6 += d4) / d9;
                d3 = children[n4].getSize() * d2;
                double d11 = this.a(d4, d8);
                double d12 = this.a(d3, d8);
                double d13 = !Double.isInfinite(d12) ? Math.max(d12, d11) : d11;
                if (d13 > d7) {
                    double d14;
                    double d15;
                    d8 = (d6 -= d4) / d9;
                    double d16 = d6 / d5;
                    if (!this.b(d15 = this.a(children, n4, --n5, d8, d2), d14 = this.a(children, n4, n5, d16, d2))) break;
                    d8 = d16;
                    bl = !bl;
                    break;
                }
                if (Double.isNaN(d13)) continue;
                d7 = d13;
            }
            if (n5 == children.length) {
                --n5;
            }
            d4 = rectangle2D.getX();
            d3 = rectangle2D.getY();
            block26: for (int i2 = n4; i2 <= n5; ++i2) {
                double d17 = children[i2].getSize() * d2 / d8;
                if (bl) {
                    switch (n2) {
                        case 2: {
                            children[i2].setShape((Shape)new Rectangle2D.Double(d4 + rectangle2D.getWidth() - d8, d3, d8, d17));
                            break;
                        }
                        case 4: {
                            children[i2].setShape((Shape)new Rectangle2D.Double(d4, d3, d8, d17));
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException();
                        }
                    }
                    d3 += d17;
                    continue;
                }
                switch (n3) {
                    case 1: {
                        switch (n2) {
                            case 2: {
                                children[i2].setShape((Shape)new Rectangle2D.Double(d4 + rectangle2D.getWidth() - d17, d3 + rectangle2D.getHeight() - d8, d17, d8));
                                d4 -= d17;
                                continue block26;
                            }
                            case 4: {
                                children[i2].setShape((Shape)new Rectangle2D.Double(d4, d3 + rectangle2D.getHeight() - d8, d17, d8));
                                d4 += d17;
                                continue block26;
                            }
                        }
                        throw new IllegalArgumentException();
                    }
                    case 3: {
                        switch (n2) {
                            case 2: {
                                children[i2].setShape((Shape)new Rectangle2D.Double(d4 + rectangle2D.getWidth() - d17, d3, d17, d8));
                                d4 -= d17;
                                continue block26;
                            }
                            case 4: {
                                children[i2].setShape((Shape)new Rectangle2D.Double(d4, d3, d17, d8));
                                d4 += d17;
                                continue block26;
                            }
                        }
                        throw new IllegalArgumentException();
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
            }
            n4 = n5 + 1;
            if (bl) {
                switch (n2) {
                    case 2: {
                        rectangle2D = new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), Math.max(0.0, rectangle2D.getWidth() - d8), rectangle2D.getHeight());
                        break;
                    }
                    case 4: {
                        rectangle2D = new Rectangle2D.Double(rectangle2D.getX() + d8, rectangle2D.getY(), Math.max(0.0, rectangle2D.getWidth() - d8), rectangle2D.getHeight());
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
                if (horizontalVanishingPoint != 0) continue;
                n2 = n2 == 2 ? 4 : 2;
                continue;
            }
            switch (n3) {
                case 1: {
                    rectangle2D = new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), Math.max(0.0, rectangle2D.getHeight() - d8));
                    break;
                }
                case 3: {
                    rectangle2D = new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY() + d8, rectangle2D.getWidth(), Math.max(0.0, rectangle2D.getHeight() - d8));
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            if (verticalVanishingPoint != 0) continue;
            n3 = n3 == 3 ? 1 : 3;
        }
        return false;
    }

    private double a(TreeMapNode[] treeMapNodeArray, int n2, int n3, double d2, double d3) {
        if (treeMapNodeArray == null || treeMapNodeArray.length == 0) {
            return Double.MAX_VALUE;
        }
        double d4 = 0.0;
        for (int i2 = n2; i2 <= n3; ++i2) {
            TreeMapNode treeMapNode = treeMapNodeArray[i2];
            double d5 = this.a(treeMapNode.getSize() * d3, d2);
            if (!(d5 > d4)) continue;
            d4 = d5;
        }
        return d4;
    }

    private double a(double d2, double d3) {
        double d4 = d2 / (d3 * d3 * (Double)this.b.getValue());
        if (d4 < 1.0) {
            d4 = 1.0 / d4;
        }
        return d4;
    }

    private boolean b(double d2, double d3) {
        double d4;
        if (d2 == 0.0) {
            return true;
        }
        if (d3 == 0.0) {
            return false;
        }
        double d5 = Math.abs(d2 - (Double)this.b.getValue());
        return d5 > (d4 = Math.abs(d3 - (Double)this.b.getValue()));
    }

    @Override
    public boolean isCompatible(Shape shape) {
        return shape instanceof Rectangle2D;
    }

    private static String a() {
        return "Squarified+";
    }

    public String toString() {
        return SquarifiedPlusAlgorithm.a();
    }

    @GwtIncompatible
    public static void main(String[] args) {
        SquarifiedAlgorithm squarifiedAlgorithm = new SquarifiedAlgorithm();
        SquarifiedAlgorithm squarifiedAlgorithm2 = new SquarifiedAlgorithm();
        squarifiedAlgorithm2.getProperties().getProperty((Object)"desiredAspectRatio").setValue((Object)(0.5 * (1.0 + Math.sqrt(5.0))));
        SquarifiedPlusAlgorithm squarifiedPlusAlgorithm = new SquarifiedPlusAlgorithm();
        squarifiedPlusAlgorithm.getProperties().getProperty((Object)"desiredAspectRatio").setValue((Object)(0.5 * (1.0 + Math.sqrt(5.0))));
        Algorithm[] algorithmArray = new Algorithm[]{squarifiedAlgorithm, squarifiedAlgorithm2, squarifiedPlusAlgorithm};
        MutableTreeMapNode[] mutableTreeMapNodeArray = new LeafTreeMapNode[]{new LeafTreeMapNode(null, null), new LeafTreeMapNode(null, null), new LeafTreeMapNode(null, null), new LeafTreeMapNode(null, null), new LeafTreeMapNode(null, null), new LeafTreeMapNode(null, null), new LeafTreeMapNode(null, null)};
        mutableTreeMapNodeArray[0].setSize(6.0);
        mutableTreeMapNodeArray[1].setSize(6.0);
        mutableTreeMapNodeArray[2].setSize(4.0);
        mutableTreeMapNodeArray[3].setSize(3.0);
        mutableTreeMapNodeArray[4].setSize(2.0);
        mutableTreeMapNodeArray[5].setSize(2.0);
        mutableTreeMapNodeArray[6].setSize(1.0);
        for (Algorithm algorithm : algorithmArray) {
            algorithm.breadthFirstLayout((Shape)new Rectangle2D.Double(0.0, 0.0, 30.4, 20.0), null, mutableTreeMapNodeArray, 24.0, 4, 3, null);
            System.out.println(algorithm + ": " + algorithm.getProperties().getProperty((Object)"desiredAspectRatio"));
            for (int i2 = 0; i2 < mutableTreeMapNodeArray.length; ++i2) {
                MutableTreeMapNode mutableTreeMapNode = mutableTreeMapNodeArray[i2];
                Rectangle2D rectangle2D = ((AbstractTreeMapNode)mutableTreeMapNode).getShape().getBounds2D();
                System.out.println(i2 + ": " + ((AbstractTreeMapNode)mutableTreeMapNode).getSize() + ", " + rectangle2D + ", " + rectangle2D.getHeight() / rectangle2D.getWidth() + ", " + SquarifiedPlusAlgorithm.a(rectangle2D));
            }
        }
    }

    private static double a(Rectangle2D rectangle2D) {
        if (rectangle2D.getWidth() > rectangle2D.getHeight()) {
            return rectangle2D.getWidth() / rectangle2D.getHeight();
        }
        return rectangle2D.getHeight() / rectangle2D.getWidth();
    }
}

