/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.treeplot;

import com.macrofocus.common.geom.Dimension;
import com.macrofocus.geom.Point;
import com.macrofocus.geom.Rectangle;
import com.macrofocus.geom.Rectangle2D;
import com.macrofocus.geom.Shape;
import com.macrofocus.igraphics.CPColor;
import com.macrofocus.igraphics.Insets;
import com.treemap.TreeMapPopup;
import com.treemap.TreeMapToolTip;
import com.treemap.crossplatform.TGraphics;
import com.treemap.treeplot.DefaultTreePlotPopup;
import com.treemap.treeplot.ToolTipTreePlotRenderer;
import com.treemap.treeplot.TreePlotModel;
import com.treemap.treeplot.TreePlotView;

public abstract class AbstractTreePlotToolTip<N, Row, Column, Component, Color, Font>
implements TreeMapToolTip<N, Row, Column, Color, Font> {
    protected TreePlotView<Component, N, Row, Column, Color, Font> view;
    protected N node;
    protected TreeMapPopup popup;
    protected static final int topShift = 7;
    protected static final int leftShift = 30;
    private int a = 230;
    private ToolTipTreePlotRenderer b = new ToolTipTreePlotRenderer();

    public AbstractTreePlotToolTip(TreePlotView<Component, N, Row, Column, Color, Font> view) {
        this.view = view;
    }

    public ToolTipTreePlotRenderer getRenderer() {
        return this.b;
    }

    public void setRenderer(ToolTipTreePlotRenderer renderer) {
        this.b = renderer;
    }

    public Insets getInsets() {
        return new Insets(2, 2, 2, 2);
    }

    @Override
    public Dimension getPreferredSize(TGraphics<Color, Font> g2) {
        TreePlotModel<N, Row, Column, Color, Font> treePlotModel = this.view.getModel();
        if (treePlotModel != null && this.node != null) {
            Rectangle rectangle = this.getRenderer().drawToolTip(g2, this.view, treePlotModel, this.node, this.getPreferredWidth(), 30, 7, false);
            if (rectangle != null) {
                Insets insets = this.getInsets();
                return new Dimension(rectangle.width + 1 + insets.left + insets.right, rectangle.height + 1 + insets.top + insets.bottom);
            }
            return null;
        }
        return null;
    }

    protected CPColor<Color> getBorderColor() {
        CPColor<Color> cPColor = this.view.getModel().getSettings().getProbingColor();
        if (cPColor != null) {
            return cPColor.alpha(0.5f);
        }
        return null;
    }

    @Override
    public void paintBackground(TGraphics<Color, Font> g2) {
        CPColor<Color> cPColor = this.view.getModel().getSettings().getTooltipBackground();
        if (cPColor != null) {
            Insets insets = this.getInsets();
            int n2 = insets.left;
            int n3 = insets.top;
            int n4 = this.getWidth() - insets.left - insets.right;
            int n5 = this.getHeight() - insets.top - insets.bottom;
            g2.setFill(cPColor);
            g2.fillRoundRect(n2, n3, n4, n5, 10.0, 10.0);
            CPColor<Color> cPColor2 = this.getBorderColor();
            if (cPColor2 != null) {
                g2.setStroke(cPColor2);
                float f2 = insets.left;
                g2.setLineWidth(f2);
                g2.strokeRoundRect(f2 / 2.0f, f2 / 2.0f, (float)this.getWidth() - f2, (float)this.getHeight() - f2, 10.0, 10.0);
            }
        }
    }

    @Override
    public void paintText(TGraphics<Color, Font> g2) {
        Insets insets = this.getInsets();
        int n2 = insets.left;
        int n3 = insets.top;
        int n4 = this.getWidth() - insets.left - insets.right;
        int n5 = this.getHeight() - insets.top - insets.bottom;
        g2.save();
        g2.translate(n2, n3);
        g2.clip((Shape)new Rectangle2D.Double(0.0, 0.0, (double)n4, (double)n5));
        g2.setAntialias(true);
        this.getRenderer().paint(g2, this.view, this.node, this.getPreferredWidth(), 30, 7, null);
        g2.restore();
    }

    protected TreePlotView<Component, N, Row, Column, Color, Font> getView() {
        return this.view;
    }

    @Override
    public N getNode() {
        return this.node;
    }

    @Override
    public synchronized void setNode(N node) {
        if (this.node != node) {
            this.node = node;
            if (this.node == null) {
                this.hidePopup();
            }
        }
    }

    @Override
    public int getPreferredWidth() {
        return this.a;
    }

    @Override
    public void setPreferredWidth(int width) {
        this.a = width;
    }

    @Override
    public Point getPopupLocation() {
        if (this.popup != null) {
            return this.popup.getAnchor();
        }
        return null;
    }

    public TreeMapPopup getPopup() {
        if (this.popup == null) {
            this.popup = this.createPopup();
        }
        return this.popup;
    }

    protected TreeMapPopup createPopup() {
        DefaultTreePlotPopup<Component> defaultTreePlotPopup = new DefaultTreePlotPopup<Component>(this.view);
        return defaultTreePlotPopup;
    }

    @Override
    public synchronized void showNode(N node) {
        if (this.node != node) {
            TreeMapPopup treeMapPopup;
            this.setNode(node);
            Point point = this.getPreferredLocation();
            Dimension dimension = this.getPreferredSize(null);
            if (point != null && dimension != null && (treeMapPopup = this.getPopup()) != null) {
                this.showPopup(point.x, point.y);
            }
            if (node == null) {
                this.hidePopup();
            }
            if (this.popup != null) {
                this.popup.repaint();
            }
        }
    }

    public Point getPreferredLocation(Point p2) {
        TreePlotModel<N, Row, Column, Color, Font> treePlotModel = this.view.getModel();
        if (treePlotModel != null && this.node != null) {
            Dimension dimension;
            Shape shape = null;
            if (p2 == null) {
                shape = this.view.getRenderedShape(this.node);
                if (shape != null) {
                    p2 = new Point((int)shape.getBounds2D().getCenterX(), (int)shape.getBounds2D().getCenterY());
                } else {
                    return null;
                }
            }
            int n2 = p2.x;
            int n3 = p2.y;
            if (p2 != null && (dimension = this.getPreferredSize(null)) != null) {
                int n4 = dimension.width;
                int n5 = dimension.height;
                Rectangle rectangle = new Rectangle(n2 + 30, n3 + 7, n4, n5);
                Dimension dimension2 = this.view.getSize();
                if (n2 > dimension2.width - 30 - n4) {
                    rectangle.x = n2 - (60 + n4);
                }
                if (n3 > dimension2.height - n5 - 7) {
                    rectangle.y = dimension2.height - n5 - 7;
                }
                return new Point(rectangle.x, rectangle.y);
            }
        }
        return null;
    }

    protected void showPopup(int x2, int y2) {
        TreeMapPopup treeMapPopup = this.getPopup();
        if (treeMapPopup != null) {
            treeMapPopup.showPopup(x2, y2, this.getView().getNativeComponent());
        }
    }

    protected void hidePopup() {
        TreeMapPopup treeMapPopup = this.getPopup();
        if (treeMapPopup != null) {
            treeMapPopup.hidePopup();
        }
    }
}

