/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.treeplot;

import com.macrofocus.common.collection.Iterables;
import com.macrofocus.common.selection.MutableSelection;
import com.macrofocus.common.selection.MutableSingleSelection;
import com.macrofocus.common.selection.Selection;
import com.macrofocus.common.selection.SimpleSingleSelection;
import com.macrofocus.crossplatform.CPHelper;
import com.macrofocus.filter.MutableFilter;
import com.macrofocus.geom.Ellipse2D;
import com.macrofocus.geom.GeneralPath;
import com.macrofocus.igraphics.CPColor;
import com.macrofocus.igraphics.CPColorFactory;
import com.macrofocus.igraphics.CPFontFactory;
import com.treemap.NoTreeMapField;
import com.treemap.ParentTreeMapNode;
import com.treemap.TreeMapField;
import com.treemap.TreeMapModel;
import com.treemap.treeplot.DefaultTreePlotSettings;
import com.treemap.treeplot.TreePlotModel;
import com.treemap.treeplot.TreePlotSettings;
import java.util.ArrayList;

public class DefaultTreePlotModel<N, Row, Column, Color, Font>
implements TreePlotModel<N, Row, Column, Color, Font> {
    private final TreeMapModel<N, Row, Column, Color, Font> a;
    private final TreePlotSettings<Color, Font> b;
    protected final MutableSingleSelection<TreeMapField<N, Column>> xVariable = new SimpleSingleSelection(new NoTreeMapField());
    protected final MutableSingleSelection<TreeMapField<N, Column>> yVariable = new SimpleSingleSelection(new NoTreeMapField());

    public DefaultTreePlotModel(TreeMapModel<N, Row, Column, Color, Font> tmm, CPColorFactory<Color> colorFactory, CPFontFactory<Font> fontFactory, CPHelper helper) {
        this.a = tmm;
        this.b = new DefaultTreePlotSettings<Color, Font>(tmm, colorFactory, fontFactory);
        TreeMapField treeMapField = null;
        TreeMapField treeMapField2 = null;
        for (int i2 = 0; i2 < this.getColumnCount(); ++i2) {
            TreeMapField<N, Column> treeMapField3 = this.getTreeMapField(i2);
            if (!helper.isNumericType(this.getColumnClass(treeMapField3.getIndex()))) continue;
            if (treeMapField == null) {
                treeMapField = tmm.getTreeMapField(i2);
                continue;
            }
            treeMapField2 = tmm.getTreeMapField(i2);
            break;
        }
        this.xVariable.setSelected(treeMapField);
        this.yVariable.setSelected(treeMapField2);
    }

    @Override
    public boolean isNumericType(TreeMapField<N, Column> field) {
        return this.a.isNumericType(field);
    }

    @Override
    public boolean isTemporalType(TreeMapField<N, Column> field) {
        return this.a.isTemporalType(field);
    }

    @Override
    public boolean isVisualType(TreeMapField<N, Column> field) {
        return this.a.isVisualType(field);
    }

    @Override
    public double getSize(N node) {
        return this.a.getSize(node);
    }

    @Override
    public double getMaximumSize() {
        return this.a.getMaximumSize();
    }

    @Override
    public double getMaximumSize(N parent) {
        double d2 = 0.0;
        for (N n2 : this.getChildren(parent)) {
            d2 = Math.max(this.getSize(n2), d2);
        }
        return d2;
    }

    @Override
    public TreeMapModel<N, Row, Column, Color, Font> getTreeMapModel() {
        return this.a;
    }

    @Override
    public MutableSingleSelection<TreeMapField<N, Column>> getXVariable() {
        return this.xVariable;
    }

    @Override
    public Iterable<TreeMapField<N, Column>> getXTreeMapFields() {
        return Iterables.conditional(this.getTreeMapFields(true), (Iterables.Condition)new Iterables.Condition<TreeMapField<N, Column>>(){

            public boolean a(TreeMapField<N, Column> treeMapField) {
                return treeMapField instanceof NoTreeMapField || DefaultTreePlotModel.this.isNumericType(treeMapField) || DefaultTreePlotModel.this.isTemporalType(treeMapField);
            }

            public /* synthetic */ boolean apply(Object object) {
                return this.a((TreeMapField)object);
            }
        });
    }

    @Override
    public MutableSingleSelection<TreeMapField<N, Column>> getYVariable() {
        return this.yVariable;
    }

    @Override
    public Iterable<TreeMapField<N, Column>> getYTreeMapFields() {
        return Iterables.conditional(this.getTreeMapFields(true), (Iterables.Condition)new Iterables.Condition<TreeMapField<N, Column>>(){

            public boolean a(TreeMapField<N, Column> treeMapField) {
                return treeMapField instanceof NoTreeMapField || DefaultTreePlotModel.this.isNumericType(treeMapField) || DefaultTreePlotModel.this.isTemporalType(treeMapField);
            }

            public /* synthetic */ boolean apply(Object object) {
                return this.a((TreeMapField)object);
            }
        });
    }

    protected Iterable<TreeMapField<N, Column>> getTreeMapFields(boolean includeNone) {
        ArrayList<TreeMapField<N, Column>> arrayList = new ArrayList<TreeMapField<N, Column>>();
        if (includeNone) {
            arrayList.add(new NoTreeMapField());
        }
        for (int i2 = 0; i2 < this.getColumnCount(); ++i2) {
            arrayList.add(this.getTreeMapField(i2));
        }
        return arrayList;
    }

    @Override
    public N getRoot() {
        return this.a.getRoot();
    }

    @Override
    public N getCurrentRoot() {
        return this.a.getCurrentRoot();
    }

    @Override
    public void setCurrentRoot(N currentRoot) {
        this.a.setCurrentRoot(currentRoot);
    }

    @Override
    public MutableSingleSelection<N> getProbing() {
        return this.a.getProbing();
    }

    @Override
    public Selection<N> getHighlighting() {
        return this.a.getHighlighting();
    }

    @Override
    public MutableSelection<N> getSelection() {
        return this.a.getSelection();
    }

    @Override
    public MutableFilter<N> getFilter() {
        return this.a.getFilter();
    }

    @Override
    public MutableFilter<N> getSearch() {
        return this.a.getSearch();
    }

    @Override
    public TreePlotSettings getSettings() {
        return this.b;
    }

    @Override
    public Double getNumericMax(TreeMapField<N, Column> columnIndex) {
        if (!this.getSettings().isHideFilterResults().booleanValue() || !this.getFilter().isActive() && this.getCurrentRoot() == this.getRoot()) {
            return this.a.getNumericMax(columnIndex);
        }
        Double d2 = null;
        for (N n2 : this.depthFirstIterator(this.getCurrentRoot())) {
            Object object;
            if (!this.isLeaf(n2) || this.getFilter().isFiltered(n2) || !((object = this.getValueAt(n2, columnIndex.getIndex())) instanceof Number) || object == null) continue;
            Number number = (Number)object;
            if (d2 == null) {
                d2 = number.doubleValue();
                continue;
            }
            d2 = Math.max(d2, number.doubleValue());
        }
        return d2;
    }

    @Override
    public Double getNumericMin(TreeMapField<N, Column> columnIndex) {
        if (!(this.getSettings().isHideFilterResults().booleanValue() && this.getFilter().isActive() || this.getCurrentRoot() != this.getRoot())) {
            return this.a.getNumericMin(columnIndex);
        }
        Double d2 = null;
        for (N n2 : this.depthFirstIterator(this.getCurrentRoot())) {
            Object object;
            if (!this.isLeaf(n2) || this.getFilter().isFiltered(n2) || !((object = this.getValueAt(n2, columnIndex.getIndex())) instanceof Number) || object == null) continue;
            Number number = (Number)object;
            if (d2 == null) {
                d2 = number.doubleValue();
                continue;
            }
            d2 = Math.min(d2, number.doubleValue());
        }
        return d2;
    }

    @Override
    public Double getNumericMax(TreeMapField columnIndex, N parent) {
        Double d2 = null;
        if (parent != null) {
            for (N n2 : this.getChildren(parent)) {
                Object object;
                if (this.getSettings().isHideFilterResults().booleanValue() && this.getFilter().isFiltered(n2) || !((object = this.getAggregateValue(n2, columnIndex)) instanceof Number) || object == null) continue;
                Number number = (Number)object;
                if (d2 == null) {
                    d2 = number.doubleValue();
                    continue;
                }
                d2 = Math.max(d2, number.doubleValue());
            }
        }
        return d2;
    }

    @Override
    public Double getNumericMin(TreeMapField columnIndex, N parent) {
        Double d2 = null;
        if (parent != null) {
            for (N n2 : this.getChildren(parent)) {
                Object object;
                if (this.getSettings().isHideFilterResults().booleanValue() && this.getFilter().isFiltered(n2) || !((object = this.getAggregateValue(n2, columnIndex)) instanceof Number) || object == null) continue;
                Number number = (Number)object;
                if (d2 == null) {
                    d2 = number.doubleValue();
                    continue;
                }
                d2 = Math.min(d2, number.doubleValue());
            }
        }
        return d2;
    }

    @Override
    public Iterable<N> depthFirstIterator(N parent) {
        return this.a.depthFirstIterator(parent);
    }

    @Override
    public TreeMapField<N, Column> getTreeMapField(int columnIndex) {
        return this.a.getTreeMapField(columnIndex);
    }

    @Override
    public TreeMapField getTreeMapField(String columnName) {
        return this.a.getTreeMapFieldByName(columnName);
    }

    @Override
    public boolean hasNoChildren(N node) {
        return this.a.hasNoChildren(node);
    }

    @Override
    public boolean isLeaf(N node) {
        return this.a.isLeaf(node);
    }

    @Override
    public N getParent(N node) {
        return this.a.getParent(node);
    }

    @Override
    public String getColumnName(Column columnIndex) {
        return this.a.getColumnName(columnIndex);
    }

    @Override
    public Object getValueAt(N node, Column columnIndex) {
        return this.a.getValueAt(node, columnIndex);
    }

    @Override
    public Object getAggregateValue(N node, TreeMapField field) {
        return this.a.getAggregateValue(node, field);
    }

    @Override
    public Iterable<N> getChildren(N parent) {
        return this.a.getChildren(parent);
    }

    @Override
    public CPColor<Color> getColor(N node) {
        return this.a.getColor(node);
    }

    @Override
    public String getStringValue(N node, TreeMapField field) {
        return this.a.getStringValue(node, field);
    }

    @Override
    public boolean isRoot(N node) {
        return this.a.isRoot(node);
    }

    @Override
    public int getColumnCount() {
        return this.a.getColumnCount();
    }

    @Override
    public Class<?> getColumnClass(Column columnIndex) {
        return this.a.getColumnClass(columnIndex);
    }

    @Override
    public Ellipse2D getMEC(N node, TreeMapField xVariable, TreeMapField yVariable) {
        if (node instanceof ParentTreeMapNode) {
            return ((ParentTreeMapNode)node).getMEC(xVariable, yVariable);
        }
        return null;
    }

    @Override
    public GeneralPath getCH(N node, TreeMapField xVariable, TreeMapField yVariable) {
        if (node instanceof ParentTreeMapNode) {
            return ((ParentTreeMapNode)node).getCH(xVariable, yVariable);
        }
        return null;
    }
}

