/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.treeplot;

import com.macrofocus.common.geom.Dimension;
import com.macrofocus.igraphics.Insets;
import com.macrofocus.labeling.EnhancedLabel;
import com.treemap.TreeMapField;
import com.treemap.TreeMapFieldSettings;
import com.treemap.treeplot.TreePlotTooltipRenderer;
import com.treemap.treeplot.TreePlotView;

public class DefaultTreePlotTooltipRenderer<C, N, Row, Column, Color, Font>
extends EnhancedLabel<Color, Font>
implements TreePlotTooltipRenderer<C, N, Row, Column, Color, Font> {
    private static final Insets a = new Insets(0, 2, 0, 1);

    public DefaultTreePlotTooltipRenderer() {
        this.setOpaque(false);
        this.setName("TreeMap.tooltipRenderer");
        this.setInsets(DefaultTreePlotTooltipRenderer.a.top, DefaultTreePlotTooltipRenderer.a.left, DefaultTreePlotTooltipRenderer.a.bottom, DefaultTreePlotTooltipRenderer.a.right);
        this.setEffect(EnhancedLabel.Effect.Plain);
        this.setHorizontalAlignment(2);
        this.setRendering(EnhancedLabel.Rendering.WordWrap);
    }

    @Override
    public EnhancedLabel<Color, Font> getTooltipRendererComponent(TreePlotView<C, N, Row, Column, Color, Font> view, TreeMapField<N, Column> field, N node, Dimension dimension) {
        String string = view.getModel().getStringValue(node, field);
        this.setText(string);
        TreeMapFieldSettings<Color, Font> treeMapFieldSettings = view.getModel().getSettings().getFieldSettings(field);
        EnhancedLabel.Rendering rendering = treeMapFieldSettings.getTooltipRendering();
        if (rendering != null) {
            this.setRendering(rendering);
        }
        if (view.getModel().isNumericType(field)) {
            this.setHorizontalAlignment(4);
        } else {
            this.setHorizontalAlignment(2);
        }
        this.setDesiredWidth(dimension.width);
        this.setDesiredHeight(dimension.height);
        return this;
    }
}

