/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.treeplot;

import com.macrofocus.common.geom.Dimension;
import com.macrofocus.geom.Rectangle;
import com.macrofocus.geom.Shape;
import com.macrofocus.igraphics.CPFont;
import com.macrofocus.labeling.EnhancedLabel;
import com.treemap.DefaultTreeMapTooltipRenderer;
import com.treemap.TreeMapField;
import com.treemap.crossplatform.TGraphics;
import com.treemap.treeplot.TreePlotModel;
import com.treemap.treeplot.TreePlotView;
import java.util.concurrent.Future;
import javax.swing.JComponent;

public class ToolTipTreePlotRenderer<N, Row, Column, Color, Font> {
    final EnhancedLabel<Color, Font> a = new EnhancedLabel();

    public ToolTipTreePlotRenderer() {
        this.a.setInsets(DefaultTreeMapTooltipRenderer.DEFAULT_BORDER.top, DefaultTreeMapTooltipRenderer.DEFAULT_BORDER.left, DefaultTreeMapTooltipRenderer.DEFAULT_BORDER.bottom, DefaultTreeMapTooltipRenderer.DEFAULT_BORDER.right);
    }

    public void paint(TGraphics<Color, Font> g2, TreePlotView<JComponent, N, Row, Column, Color, Font> view, N node, int width, int leftShift, int topShift, Future progress) {
        Shape shape;
        TreePlotModel<N, Row, Column, Color, Font> treePlotModel = view.getModel();
        if (node != null && (shape = view.getRenderedShape(node)) != null) {
            this.drawToolTip(g2, view, treePlotModel, node, width, leftShift, topShift, true);
        }
    }

    public Rectangle drawToolTip(TGraphics<Color, Font> g2, TreePlotView<JComponent, N, Row, Column, Color, Font> view, TreePlotModel<N, Row, Column, Color, Font> model, N node, int width, int leftShift, int topShift, boolean paint) {
        Rectangle rectangle = model.getSettings().getToolTipTreeMapFields();
        if (rectangle != null && ((TreeMapField[])rectangle).length >= 0) {
            Object object;
            CPFont<Font> cPFont;
            int n2 = 0;
            boolean bl = false;
            for (TreeMapField treeMapField : rectangle) {
                EnhancedLabel<Color, Font> enhancedLabel;
                if (!treeMapField.isValid() || (enhancedLabel = view.getTooltipRenderer().getTooltipRendererComponent(view, treeMapField, node, new Dimension(width, 1000))) == null) continue;
                Object object2 = view.getHeadless().sizeLabel(enhancedLabel, g2, width, 1000);
                cPFont = view.getModel().getSettings().getFieldSettings(treeMapField).getTooltipFont();
                object = cPFont.deriveFontWeight(CPFont.Weight.BOLD);
                enhancedLabel.setFont((CPFont)object);
                enhancedLabel.setForeground(view.getModel().getSettings().getFieldSettings(treeMapField).getTooltipForeground());
                enhancedLabel.setBackground(null);
                n2 = (int)((double)n2 + object2.getPreferredHeight());
            }
            Rectangle rectangle2 = new Rectangle(0, 0, width, n2);
            if (n2 <= 0) {
                return null;
            }
            int n3 = rectangle2.y;
            for (Object object2 : rectangle) {
                Rectangle rectangle3;
                if (!object2.isValid()) continue;
                cPFont = view.getTooltipRenderer().getTooltipRendererComponent(view, (TreeMapField<N, Column>)object2, node, new Dimension(width, 1000));
                object = view.getHeadless().sizeLabel((EnhancedLabel<Color, Font>)cPFont, g2, rectangle2.width, rectangle2.height);
                if (cPFont == null) continue;
                CPFont<Font> cPFont2 = view.getModel().getSettings().getFieldSettings((TreeMapField)object2).getTooltipFont();
                CPFont cPFont3 = cPFont2.deriveFontWeight(CPFont.Weight.BOLD);
                cPFont.setFont(cPFont3);
                cPFont.setForeground(view.getModel().getSettings().getFieldSettings((TreeMapField)object2).getTooltipForeground());
                cPFont.setBackground(null);
                Dimension dimension = object.getPreferredSize();
                if (n3 + dimension.height > rectangle2.y + rectangle2.height) break;
                int n4 = rectangle2.x + 2;
                int n5 = rectangle2.width - 2 - 1;
                if (model.getSettings().getFieldSettings((TreeMapField)object2).getShowLabel()) {
                    this.a.setFont(cPFont2);
                    this.a.setForeground(view.getModel().getSettings().getFieldSettings((TreeMapField)object2).getTooltipForeground());
                    this.a.setBackground(null);
                    this.a.setText(object2.getName() + ": ");
                    rectangle3 = view.getHeadless().sizeLabel(this.a, g2, width, 1000).getPreferredSize();
                    if (rectangle3.width + dimension.width > n5) {
                        rectangle3.width = Math.max(0, n5 - dimension.width);
                    }
                    Rectangle rectangle4 = new Rectangle(n4, n3, rectangle3.width, rectangle3.height);
                    if (paint && g2 != null) {
                        g2.paintLabel(this.a, rectangle4.x, rectangle4.y, rectangle4.width, rectangle4.height);
                    }
                    if (view.getModel().isNumericType((TreeMapField<N, Column>)object2)) {
                        n4 += rectangle3.width;
                        n5 -= rectangle3.width;
                    } else {
                        n4 += rectangle3.width;
                        n5 -= rectangle3.width;
                    }
                }
                rectangle3 = new Rectangle(n4, n3, n5, dimension.height);
                if (paint && g2 != null) {
                    g2.paintLabel((EnhancedLabel<Color, Font>)cPFont, rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
                }
                n3 += dimension.height;
            }
            return rectangle2;
        }
        return null;
    }
}

