/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.app.document;

import com.macrofocus.application.document.AbstractView;
import com.macrofocus.application.menu.CPMenu;
import com.macrofocus.application.menu.CPMenuBar;
import com.macrofocus.application.properties.DocumentBasedApplicationProperties;
import com.macrofocus.application.status.CPStatusBar;
import com.macrofocus.application.window.CPWindow;
import com.macrofocus.colormap.ColorMapFactory;
import com.macrofocus.colormap.editor.ColorMapEditorFactory;
import com.macrofocus.common.command.Command;
import com.macrofocus.common.properties.MutableProperty;
import com.macrofocus.common.properties.Property;
import com.macrofocus.common.properties.PropertyEvent;
import com.macrofocus.common.properties.PropertyListener;
import com.macrofocus.common.properties.SimpleProperty;
import com.macrofocus.common.selection.MutableSingleSelection;
import com.macrofocus.common.selection.Selection;
import com.macrofocus.common.selection.SelectionEvent;
import com.macrofocus.common.selection.SelectionListener;
import com.macrofocus.common.selection.SingleSelection;
import com.macrofocus.common.selection.SingleSelectionEvent;
import com.macrofocus.common.selection.SingleSelectionListener;
import com.macrofocus.crossplatform.CPButton;
import com.macrofocus.crossplatform.CPComponent;
import com.macrofocus.crossplatform.CPFactory;
import com.macrofocus.crossplatform.CPHorizontalFlowPanel;
import com.macrofocus.docking.AttachAnchor;
import com.macrofocus.docking.DockingFactory;
import com.macrofocus.docking.DockingPanel;
import com.macrofocus.filter.FilterEvent;
import com.macrofocus.filter.FilterListener;
import com.macrofocus.filter.MutableFilter;
import com.macrofocus.high_d.axis.AxisFactory;
import com.macrofocus.high_d.axis.group.AxisGroupModel;
import com.macrofocus.high_d.axis.hierarchy.DefaultAxisHierarchy;
import com.macrofocus.high_d.filters.Filters;
import com.macrofocus.igraphics.colortheme.ColorTheme;
import com.macrofocus.igraphics.colortheme.DarkColorTheme;
import com.macrofocus.igraphics.colortheme.LightColorTheme;
import com.macrofocus.molap.dataframe.DataFrame;
import com.macrofocus.molap.dataframe.WrappedDataFrame;
import com.macrofocus.plot.AxisPlotPanel;
import com.macrofocus.table.Table;
import com.macrofocus.timer.CPTimer;
import com.macrofocus.timer.CPTimerListener;
import com.macrofocus.visual.Visual;
import com.treemap.AlgorithmFactory;
import com.treemap.ThreeDTreeMapView;
import com.treemap.TreeMap;
import com.treemap.TreeMapModel;
import com.treemap.TreeMapPanel;
import com.treemap.app.document.ConfigurationPanel;
import com.treemap.app.document.DefaultConfigurationPanel;
import com.treemap.app.document.TreeMapDocument;
import com.treemap.app.document.TreeMapView;
import com.treemap.details.Details;
import com.treemap.treeplot.TreePlot;
import com.treemap.treeplot.TreePlotPanel;
import com.treemap.treetable.TreeTable;
import java.util.ArrayList;
import java.util.Set;

public abstract class AbstractTreeMapView<Component, D extends TreeMapDocument, Row, Column, Value, Color, Font>
extends AbstractView<Component, D>
implements TreeMapView<Component, D> {
    private final DocumentBasedApplicationProperties properties;
    private final Property<Set<String>> views;
    private final ColorTheme<Color> lightColorTheme;
    private final ColorTheme<Color> darkColorTheme;
    protected MutableProperty<ColorTheme<Color>> colorTheme;
    private final Component nativeComponent;
    private D document;
    protected final boolean expertMode;
    protected DockingFactory<Component> dockingFactory;
    protected DockingPanel<Component> innerDocking;
    protected DockingPanel<Component> dockingPanel;
    private final CPFactory<Component, Font, ?, Color> factory;
    protected final AlgorithmFactory algorithmFactory;
    protected AxisGroupModel<Row, Column> axisGroupModel;
    protected TreeMap<Component, ?, ?, ?, Color, Font> treeMap;

    public AbstractTreeMapView(DockingFactory<Component> dockingFactory, CPFactory<Component, Font, ?, Color> factory, ColorMapFactory<Color> colorMapFactory, AlgorithmFactory algorithmFactory, boolean expertMode, DocumentBasedApplicationProperties properties, Property<Set<String>> views) {
        this.properties = properties;
        this.expertMode = expertMode;
        this.views = views;
        this.dockingFactory = dockingFactory;
        this.factory = factory;
        this.algorithmFactory = algorithmFactory;
        this.lightColorTheme = new LightColorTheme(factory);
        this.darkColorTheme = new DarkColorTheme(factory);
        this.colorTheme = new SimpleProperty(this.lightColorTheme);
        this.dockingPanel = dockingFactory.createDockingPanel(false);
        this.nativeComponent = this.dockingPanel.getNativeComponent();
        this.innerDocking = dockingFactory.createDockingPanel(true);
    }

    public void init() {
    }

    public DocumentBasedApplicationProperties getProperties() {
        return this.properties;
    }

    public DockingPanel<Component> getInnerDocking() {
        return this.innerDocking;
    }

    public void setDocument(D document) {
        if (this.document != document) {
            TreeTable<Component, ?, ?, ?, Color, Font> treeTable;
            this.document = document;
            WrappedDataFrame dataFrame = ((TreeMapDocument)((Object)document)).getDataFrame();
            Visual visual = ((TreeMapDocument)((Object)document)).getVisual();
            AxisFactory axisFactory = new AxisFactory(this.factory, (DataFrame)dataFrame, ((TreeMapDocument)((Object)document)).getSubsetDataFrame(), null, (SingleSelection)visual.getProbing(), (Selection)visual.getSelection(), (MutableFilter)visual.getFilter());
            DefaultAxisHierarchy axisHierarchy = new DefaultAxisHierarchy(axisFactory, this.factory, (DataFrame)dataFrame, true, true, 100);
            this.axisGroupModel = axisHierarchy.getRoot();
            TreeMap<Component, ?, ?, ?, Color, Font> treeMap = this.treeMap = this.viewVisible("TreeMap") ? this.createTreeMap() : null;
            if (this.treeMap != null) {
                TreeMapPanel<Component> treeMapPanel = this.createTreeMapPanel(this.treeMap);
                if (treeMapPanel != null) {
                    this.innerDocking.attach(this.innerDocking.createNakedDockable(treeMapPanel.getNativeComponent(), "TreeMap", "com/treemap/app/icons/treemap16x16.png"), AttachAnchor.BOTTOM);
                } else {
                    this.innerDocking.attach(this.innerDocking.createNakedDockable(this.treeMap.getNativeComponent(), "TreeMap", "com/treemap/app/icons/treemap16x16.png"), AttachAnchor.BOTTOM);
                }
            }
            try {
                TreePlot<Component, ?, ?, ?, Color, Font> treePlot;
                TreePlot<Component, ?, ?, ?, Color, Font> treePlot2 = treePlot = this.viewVisible("TreePlot") ? this.createTreePlot() : null;
                if (treePlot != null) {
                    TreePlotPanel<Component> treePlotPanel = this.createTreePlotPanel(treePlot);
                    if (treePlotPanel != null) {
                        this.innerDocking.attach(this.innerDocking.createNakedDockable(treePlotPanel.getNativeComponent(), "TreePlot", "com/treemap/app/icons/treeplot16x16.png"), AttachAnchor.BOTTOM);
                    } else {
                        AxisPlotPanel<Component> axisPlotPanel = this.createAxisPlotPanel(treePlot);
                        this.innerDocking.attach(this.innerDocking.createNakedDockable(axisPlotPanel != null ? axisPlotPanel.getNativeComponent() : treePlot.getNativeComponent(), "TreePlot", "com/treemap/app/icons/treeplot16x16.png"), AttachAnchor.BOTTOM);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                TreeTable<Component, ?, ?, ?, Color, Font> treeTable2 = treeTable = this.viewVisible("TreeTable") ? this.createTreeTable() : null;
                if (treeTable != null) {
                    this.innerDocking.attach(this.innerDocking.createNakedDockable(treeTable.getNativeComponent(), "TreeTable", "com/treemap/app/icons/treetable16x16.png"), AttachAnchor.BOTTOM);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                Table<Component, Color, ?, ?, ?, ?> table = treeTable = this.viewVisible("Table") ? this.createTable() : null;
                if (treeTable != null) {
                    this.innerDocking.attach(this.innerDocking.createNakedDockable(treeTable.getNativeComponent(), "Table", "com/treemap/app/icons/treetable16x16.png"), AttachAnchor.BOTTOM);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                if (this.expertMode) {
                    ThreeDTreeMapView<?, ?, ?, Color, Font, Component> treeMapView;
                    ThreeDTreeMapView<?, ?, ?, Color, Font, Component> threeDTreeMapView = treeMapView = this.viewVisible("3DTreeMap") ? this.create3DTreeMap() : null;
                    if (treeMapView != null) {
                        this.innerDocking.attach(this.innerDocking.createNakedDockable(treeMapView.getNativeComponent(), "3D", "com/treemap/app/icons/3dtreemap16x16.png"), AttachAnchor.BOTTOM);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                ConfigurationPanel<Component, Color, Font> configuration;
                ConfigurationPanel<Component, Color, Font> configurationPanel = configuration = this.viewVisible("Configuration") ? this.createConfiguration() : null;
                if (configuration != null) {
                    this.dockingPanel.attach(this.dockingPanel.createNakedDockable(configuration.getMainComponent().getNativeComponent(), "Configuration", "com/treemap/app/icons/configurableAppearance16.png"), AttachAnchor.LEFT);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                Filters<Component, Color, ?, ?, ?> filters;
                Filters<Component, Color, ?, ?, ?> filters2 = filters = this.viewVisible("Filters") ? this.createFilters() : null;
                if (filters != null) {
                    this.dockingPanel.attach(this.dockingPanel.createNakedDockable(filters.getNativeComponent(), "Filters", "com/treemap/app/icons/useFilter.png"), AttachAnchor.LEFT);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                Details<Component, ?, ?, ?, ?, ?> details;
                Details<Component, ?, ?, ?, ?, ?> details2 = details = this.viewVisible("Details") ? this.createDetails() : null;
                if (details != null) {
                    this.dockingPanel.attach(this.dockingPanel.createNakedDockable(details.getNativeComponent(), "Details", "com/treemap/app/icons/toolWindowDatabaseConsole.png"), AttachAnchor.LEFT);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.dockingPanel.setInnerComponent(this.innerDocking.getNativeComponent());
            this.dockingPanel.setHorizontalRelativeSize(false);
            this.dockingPanel.setVerticalRelativeResize(false);
            this.dockingPanel.setHorizontalFirstDividerSize(340.0);
        }
    }

    public boolean viewVisible(String view) {
        return this.views == null || this.views.getValue() == null || ((Set)this.views.getValue()).contains(view);
    }

    public D getDocument() {
        return this.document;
    }

    public abstract TreeMap<Component, ?, ?, ?, Color, Font> createTreeMap();

    public TreeMapPanel<Component> createTreeMapPanel(TreeMap<Component, ?, ?, ?, Color, Font> treeMap) {
        return null;
    }

    public abstract TreePlot<Component, ?, ?, ?, Color, Font> createTreePlot();

    public AxisPlotPanel<Component> createAxisPlotPanel(TreePlot<Component, ?, ?, ?, Color, Font> treePlot) {
        return null;
    }

    public TreePlotPanel<Component> createTreePlotPanel(TreePlot<Component, ?, ?, ?, Color, Font> treePlot) {
        return null;
    }

    public abstract TreeTable<Component, ?, ?, ?, Color, Font> createTreeTable();

    public Table<Component, Color, ?, ?, ?, ?> createTable() {
        return null;
    }

    public ThreeDTreeMapView<?, ?, ?, Color, Font, Component> create3DTreeMap() {
        return null;
    }

    public ConfigurationPanel<Component, Color, Font> createConfiguration() {
        return new DefaultConfigurationPanel<Component, Color, Font>(this.expertMode, this.dockingFactory, (TreeMapDocument)((Object)this.document), this.factory, this.algorithmFactory, this.createColorMapEditorFactory());
    }

    protected abstract ColorMapEditorFactory createColorMapEditorFactory();

    public abstract Filters<Component, Color, ?, ?, ?> createFilters();

    public abstract Details<Component, ?, ?, ?, ?, ?> createDetails();

    public CPComponent<Component> createStatus() {
        return this.factory.createVerticalPanel();
    }

    public void customizeWindow(final CPWindow<?, Component> rootPanel) {
        rootPanel.setStyleClass(new String[]{"root"});
        this.colorTheme.addPropertyListener(new PropertyListener<ColorTheme<Color>>(){

            public void propertyChanged(PropertyEvent<ColorTheme<Color>> event) {
                AbstractTreeMapView.this.updateStyleClass(rootPanel, (ColorTheme)event.getNewValue());
            }
        });
        this.updateStyleClass(rootPanel, (ColorTheme)this.colorTheme.getValue());
    }

    private void updateStyleClass(CPWindow<?, Component> rootPanel, ColorTheme<Color> colorTheme) {
        if (colorTheme.isDark()) {
            rootPanel.addStyleClass(new String[]{"dark", "bp3-dark"});
            rootPanel.removeStyleClass(new String[]{"light"});
        } else {
            rootPanel.addStyleClass(new String[]{"light"});
            rootPanel.removeStyleClass(new String[]{"dark", "bp3-dark"});
        }
    }

    public void customizeMenuBar(CPMenuBar<Component> menuBar) {
        this.createEditMenu(menuBar);
        this.createOptionsMenu(menuBar);
        this.createWindowMenu(menuBar);
        this.createHelpMenu(menuBar);
    }

    protected void createEditMenu(CPMenuBar<Component> menuBar) {
        CPMenu edit = menuBar.addMenu("Edit");
        this.customizeEditMenu(edit);
    }

    protected void customizeEditMenu(CPMenu<Component> edit) {
        edit.addAction("Reset", null, new Command(){

            public void execute() {
                ((TreeMapDocument)((Object)AbstractTreeMapView.this.getDocument())).getSubsetDataFrame().reset();
                ((TreeMapDocument)((Object)AbstractTreeMapView.this.getDocument())).getTreeMapModel().getProbing().clearSelection();
                ((TreeMapDocument)((Object)AbstractTreeMapView.this.getDocument())).getTreeMapModel().getSelection().clearSelection();
            }
        });
    }

    protected void createOptionsMenu(CPMenuBar<Component> menuBar) {
        CPMenu options = menuBar.addMenu("Options");
        this.customizeOptionsMenu(options);
    }

    protected void customizeOptionsMenu(CPMenu<Component> options) {
        options.addCheckBox("Hide Filtered", "F8", this.getDocument() != null ? ((TreeMapDocument)((Object)this.getDocument())).getTreeMapModel().getSettings().getHideFilterResultsSelection() : null);
    }

    protected void createWindowMenu(CPMenuBar<Component> menuBar) {
        CPMenu window = menuBar.addMenu("Window");
        this.customizeWindowMenu(window);
    }

    protected void customizeWindowMenu(CPMenu<Component> options) {
    }

    protected void createHelpMenu(CPMenuBar<Component> menuBar) {
        CPMenu window = menuBar.addMenu("Help");
        this.customizeHelpMenu(window);
    }

    protected void customizeHelpMenu(CPMenu<Component> options) {
    }

    public void customizeStatusBar(final CPStatusBar<Component> statusBar) {
        SimpleProperty status = new SimpleProperty((Object)"");
        final CPTimer timer = this.factory.createTimer("StatusBarUpdater", 30, true, new CPTimerListener((MutableProperty)status){
            final /* synthetic */ MutableProperty val$status;
            {
                this.val$status = mutableProperty;
            }

            public void timerTriggered() {
                AbstractTreeMapView.this.updateStatus(statusBar, (MutableProperty<String>)this.val$status);
            }
        });
        this.updateStatus(statusBar, (MutableProperty<String>)status);
        if (this.getDocument() != null) {
            CPHorizontalFlowPanel flowPanel = this.factory.createHorizontalFlowPanel(new CPComponent[0]);
            flowPanel.setStyleClass(new String[]{"statusBarPanel"});
            TreeMapModel model = ((TreeMapDocument)((Object)this.getDocument())).getTreeMapModel();
            SingleSelectionListener probingListener = new SingleSelectionListener(){

                public void selectionChanged(SingleSelectionEvent treeMapNodeSingleSelectionEvent) {
                    AbstractTreeMapView.this.scheduleUpdatePathPanel(timer);
                }
            };
            SelectionListener selectionListener = new SelectionListener(){

                public void selectionChanged(SelectionEvent treeMapNodeSingleSelectionEvent) {
                    AbstractTreeMapView.this.scheduleUpdatePathPanel(timer);
                }
            };
            FilterListener filterListener = new FilterListener(){

                public void filterChanged(FilterEvent event) {
                    AbstractTreeMapView.this.scheduleUpdatePathPanel(timer);
                }
            };
            model.getProbing().addSingleSelectionListener(probingListener);
            model.getSelection().addSelectionListener(selectionListener);
            model.getFilter().addFilterListener(filterListener);
            CPHorizontalFlowPanel palettePanel = this.factory.createHorizontalFlowPanel(new CPComponent[0]);
            palettePanel.setStyleClass(new String[]{"palettePanel"});
            flowPanel.add((CPComponent)palettePanel);
            flowPanel.add((CPComponent)this.factory.createLabel((Property)status));
            CPButton<Component> fullScreenButton = this.getFullScreenButton();
            if (fullScreenButton != null) {
                flowPanel.add(fullScreenButton);
            }
            statusBar.setStatusComponent(flowPanel.getNativeComponent());
        }
    }

    private void scheduleUpdatePathPanel(CPTimer timer) {
        timer.restart();
    }

    private void updateStatus(CPStatusBar<Component> statusBar, MutableProperty<String> status) {
        if (this.getDocument() != null) {
            TreeMapModel model = ((TreeMapDocument)((Object)this.getDocument())).getTreeMapModel();
            MutableSingleSelection probingModel = model.getProbing();
            if (probingModel != null && probingModel.isActive()) {
                ArrayList<Object[]> paths = new ArrayList<Object[]>();
                if (probingModel != null && probingModel.isActive()) {
                    ArrayList<Object> path = new ArrayList<Object>();
                    Object leaf = probingModel.getSelected();
                    do {
                        path.add(0, leaf);
                    } while ((leaf = model.getParent(leaf)) != null);
                    paths.add(path.toArray());
                }
                ArrayList<Object> lcd = new ArrayList<Object>();
                int depth = 0;
                if (paths.size() > 0) {
                    boolean found = true;
                    do {
                        Object current = null;
                        for (Object[] path : paths) {
                            if (!(found &= path.length > depth)) continue;
                            if (current != null) {
                                if (current == path[depth]) continue;
                                found = false;
                                continue;
                            }
                            current = path[depth];
                        }
                        if (found && depth > 0) {
                            lcd.add(current);
                        }
                        ++depth;
                    } while (found);
                }
                StringBuilder statusNode = new StringBuilder();
                for (int i = 0; i < lcd.size(); ++i) {
                    Object node = lcd.get(i);
                    statusNode.append(model.getLabelName(node));
                    if (i >= lcd.size() - 1) continue;
                    statusNode.append(" \u25b8 ");
                }
                status.setValue((Object)statusNode.toString());
            } else {
                String visible;
                if (model.getFilter().getFilteredCount() > 0) {
                    int visibleCount = model.getRowCount() - model.getFilter().getFilteredCount();
                    visible = visibleCount + " " + (visibleCount > 1 ? "are" : "is");
                } else {
                    visible = "all are";
                }
                status.setValue((Object)("Of " + model.getRowCount() + " items, " + visible + " visible, and " + model.getSelection().getSelectedCount() + " " + (model.getSelection().getSelectedCount() > 1 ? "are" : "is") + " selected"));
            }
        } else {
            status.setValue((Object)"");
        }
    }

    public CPButton<Component> getFullScreenButton() {
        return null;
    }

    public void close() {
        this.dockingPanel.dispose();
        this.innerDocking.dispose();
        this.properties.dispose();
    }

    public Component getNativeComponent() {
        return this.nativeComponent;
    }
}

