/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.app.document;

import com.macrofocus.colormap.editor.ColorMapEditorFactory;
import com.macrofocus.common.selection.MutableSingleSelection;
import com.macrofocus.common.selection.SelectionEvent;
import com.macrofocus.common.selection.SelectionListener;
import com.macrofocus.common.selection.SimpleSingleSelection;
import com.macrofocus.common.selection.SingleSelection;
import com.macrofocus.common.selection.SingleSelectionEvent;
import com.macrofocus.common.selection.SingleSelectionListener;
import com.macrofocus.crossplatform.CPComboBox;
import com.macrofocus.crossplatform.CPComponent;
import com.macrofocus.crossplatform.CPFactory;
import com.macrofocus.crossplatform.CPFormPanel;
import com.macrofocus.docking.DockingFactory;
import com.treemap.AlgorithmFactory;
import com.treemap.DefaultTreeMapFieldSettings;
import com.treemap.NoTreeMapField;
import com.treemap.RenderingFactory;
import com.treemap.TreeMapField;
import com.treemap.TreeMapFieldSettings;
import com.treemap.TreeMapModel;
import com.treemap.TreeMapSettings;
import com.treemap.app.document.ColorSettingsPanel;
import com.treemap.app.document.ConfigurationPanel;
import com.treemap.app.document.GroupBySettingsPanel;
import com.treemap.app.document.HeightSettingsPanel;
import com.treemap.app.document.LabelsSettingsPanel;
import com.treemap.app.document.LayoutSettingsPanel;
import com.treemap.app.document.RenderingSettingsPanel;
import com.treemap.app.document.SizeSettingsPanel;
import com.treemap.app.document.TooltipSettingsPanel;
import com.treemap.app.document.TreeMapDocument;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;

public class DefaultConfigurationPanel<Component, Color, Font>
implements ConfigurationPanel<Component, Color, Font> {
    private final boolean expertMode;
    private final CPFactory<Component, Font, ?, Color> factory;
    private final AlgorithmFactory algorithmFactory;
    private final ColorMapEditorFactory colorMapEditorFactory;
    private final TreeMapModel treeMapModel;
    private final TreeMapSettings settings;
    private final CPFormPanel<Component> formPanel;
    private final List<SingleSelection<TreeMapField>> groupByComboBoxes;
    private final List<Integer> groupByRows;
    private final CPComponent<Component> nativeComponent;
    private boolean updateGroupBy = false;
    final SingleSelectionListener<TreeMapField> selectionListener = new SingleSelectionListener<TreeMapField>(){

        public void selectionChanged(SingleSelectionEvent<TreeMapField> event) {
            DefaultConfigurationPanel.this.updateGroupBy();
        }
    };

    public DefaultConfigurationPanel(boolean expertMode, DockingFactory<Component> dockingFactory, TreeMapDocument document, CPFactory<Component, Font, ?, Color> factory, AlgorithmFactory algorithmFactory, ColorMapEditorFactory colorMapEditorFactory) {
        this.expertMode = expertMode;
        this.factory = factory;
        this.algorithmFactory = algorithmFactory;
        this.colorMapEditorFactory = colorMapEditorFactory;
        this.formPanel = factory.createFormPanel();
        this.treeMapModel = document.getTreeMapModel();
        this.settings = this.treeMapModel.getSettings();
        TreeMapFieldSettings defaultFieldSettings = this.settings.getDefaultFieldSettings();
        this.formPanel.add((CPComponent)factory.createLabel("Layout:"), (CPComponent)factory.createComboBox(((DefaultTreeMapFieldSettings)defaultFieldSettings).getAlgorithmSelection(), (Iterable)algorithmFactory.getAlgorithms()), expertMode ? this.createLayoutSettings() : null);
        this.formPanel.addSeparator();
        this.groupByComboBoxes = new ArrayList<SingleSelection<TreeMapField>>();
        this.groupByRows = new ArrayList<Integer>();
        this.settings.getGroupByVariablesSelection().addSelectionListener(new SelectionListener(){

            public void selectionChanged(SelectionEvent event) {
                if (!DefaultConfigurationPanel.this.updateGroupBy) {
                    DefaultConfigurationPanel.this.updateGroupByComboBoxes();
                }
            }
        });
        this.updateGroupByComboBoxes();
        this.formPanel.addSeparator();
        this.formPanel.add((CPComponent)factory.createLabel("Size:"), (CPComponent)factory.createComboBox(this.settings.getSizeVariableSelection(), this.treeMapModel.getSizeTreeMapFields()), expertMode ? this.createSizeSettings() : null);
        this.formPanel.addSeparator();
        this.formPanel.add((CPComponent)factory.createLabel("Color:"), (CPComponent)factory.createComboBox(this.settings.getColorVariableSelection(), this.treeMapModel.getColorTreeMapFields()), expertMode ? this.createColorSettings() : null);
        this.formPanel.addSeparator();
        this.formPanel.add((CPComponent)factory.createLabel("Height:"), (CPComponent)factory.createComboBox(this.settings.getHeightVariableSelection(), this.treeMapModel.getHeightTreeMapFields()), expertMode ? this.createHeightSettings() : null);
        this.formPanel.addSeparator();
        if (expertMode) {
            SimpleSingleSelection labelSelection = new SimpleSingleSelection();
            this.formPanel.add((CPComponent)factory.createLabel("Labels:"), (CPComponent)factory.createCheckBoxList((MutableSingleSelection)labelSelection, this.settings.getLabelVariablesSelection(), this.treeMapModel.getLabelsTreeMapFields()), this.createLabelsSettings((SingleSelection<TreeMapField>)labelSelection));
            this.formPanel.addSeparator();
            SimpleSingleSelection tooltipSelection = new SimpleSingleSelection();
            this.formPanel.add((CPComponent)factory.createLabel("Tooltip:"), (CPComponent)factory.createCheckBoxList((MutableSingleSelection)tooltipSelection, this.settings.getTooltipVariablesSelection(), this.treeMapModel.getTooltipTreeMapFields()), this.createTooltipSettings((SingleSelection<TreeMapField>)tooltipSelection));
            this.formPanel.addSeparator();
        }
        this.formPanel.add((CPComponent)factory.createLabel("Rendering:"), (CPComponent)factory.createComboBox(this.settings.getRenderingSelection(), (Iterable)RenderingFactory.getInstance().getRenderings()), expertMode ? this.createRenderingSettings() : null);
        this.nativeComponent = this.formPanel;
    }

    protected void updateGroupByComboBoxes() {
        boolean first = true;
        for (SingleSelection<TreeMapField> groupByComboBox : this.groupByComboBoxes) {
            groupByComboBox.removeSingleSelectionListener(this.selectionListener);
        }
        this.groupByComboBoxes.clear();
        this.formPanel.remove(this.groupByRows);
        this.groupByRows.clear();
        ArrayList<Object> fields = new ArrayList<Object>();
        TreeMapField[] groupByTreeMapFields = this.settings.getGroupByTreeMapFields();
        if (groupByTreeMapFields != null) {
            TreeMapField last = null;
            for (TreeMapField field : groupByTreeMapFields) {
                fields.add(field);
                last = field;
            }
            if (!(last instanceof NoTreeMapField)) {
                fields.add(new NoTreeMapField());
            }
        }
        int next = this.expertMode ? 3 : 2;
        for (TreeMapField treeMapField : fields) {
            int[] rows;
            SimpleSingleSelection selection = new SimpleSingleSelection((Object)treeMapField);
            selection.addSingleSelectionListener(this.selectionListener);
            CPComboBox comboBox = this.factory.createComboBox((MutableSingleSelection)selection, this.treeMapModel.getGroupByTreeMapFields());
            this.groupByComboBoxes.add((SingleSelection<TreeMapField>)selection);
            if (this.expertMode) {
                rows = this.formPanel.add(next, (CPComponent)(first ? this.factory.createLabel(first ? "Group by:" : null) : null), (CPComponent)comboBox, treeMapField != null && treeMapField.isValid() ? this.createGroupBySettings(treeMapField) : null);
            } else {
                int row = this.formPanel.add(next, first ? this.factory.createLabel(first ? "Group by:" : null) : null, (CPComponent)comboBox);
                rows = new int[]{row};
            }
            next = rows.length > 1 ? rows[1] + 1 : rows[0] + 1;
            for (int row : rows) {
                this.groupByRows.add(row);
            }
            first = false;
        }
    }

    private void updateGroupBy() {
        this.updateGroupBy = true;
        LinkedHashSet<TreeMapField> list = new LinkedHashSet<TreeMapField>();
        for (SingleSelection<TreeMapField> groupByComboBox : this.groupByComboBoxes) {
            if (!((TreeMapField)groupByComboBox.getSelected()).isValid()) continue;
            list.add((TreeMapField)groupByComboBox.getSelected());
        }
        this.treeMapModel.getSettings().setGroupByTreeMapFields(list.toArray(new TreeMapField[list.size()]));
        this.updateGroupByComboBoxes();
        this.updateGroupBy = false;
    }

    public CPComponent<Component> createLayoutSettings() {
        return new LayoutSettingsPanel<Component, Color, Font>(this.treeMapModel, this.factory).getPanel();
    }

    public CPComponent<Component> createGroupBySettings(TreeMapField field) {
        return new GroupBySettingsPanel<Component, Color, Font>(this.treeMapModel, field, this.factory, this.algorithmFactory).getPanel();
    }

    public CPComponent<Component> createSizeSettings() {
        return new SizeSettingsPanel<Component, Color, Font>(this.treeMapModel, this.factory).getPanel();
    }

    public CPComponent<Component> createColorSettings() {
        return new ColorSettingsPanel<Component, Color, Font>(this.treeMapModel, this.factory, this.colorMapEditorFactory).getPanel();
    }

    public CPComponent<Component> createHeightSettings() {
        return new HeightSettingsPanel<Component, Color, Font>(this.treeMapModel, this.factory).getPanel();
    }

    public CPComponent<Component> createLabelsSettings(SingleSelection<TreeMapField> selection) {
        return new LabelsSettingsPanel<Component, Color, Font>(this.treeMapModel, selection, this.factory).getPanel();
    }

    public CPComponent<Component> createTooltipSettings(SingleSelection<TreeMapField> selection) {
        return new TooltipSettingsPanel<Component, Color, Font>(this.treeMapModel, selection, this.factory).getPanel();
    }

    public CPComponent<Component> createRenderingSettings() {
        return new RenderingSettingsPanel<Component, Color, Font>(this.treeMapModel, this.factory).getPanel();
    }

    public CPComponent<Component> createVariables() {
        return this.factory.createVerticalPanel();
    }

    @Override
    public CPComponent<Component> getMainComponent() {
        return this.nativeComponent;
    }
}

