/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.app.document;

import com.macrofocus.common.collection.Iterables;
import com.macrofocus.common.command.Command;
import com.macrofocus.common.selection.MutableSingleSelection;
import com.macrofocus.common.selection.PropertySingleSelection;
import com.macrofocus.common.selection.SingleSelection;
import com.macrofocus.common.selection.SingleSelectionEvent;
import com.macrofocus.common.selection.SingleSelectionListener;
import com.macrofocus.crossplatform.CPButton;
import com.macrofocus.crossplatform.CPColorPicker;
import com.macrofocus.crossplatform.CPComboBox;
import com.macrofocus.crossplatform.CPComponent;
import com.macrofocus.crossplatform.CPFactory;
import com.macrofocus.crossplatform.CPFontPicker;
import com.macrofocus.crossplatform.CPFormPanel;
import com.macrofocus.crossplatform.CPLabel;
import com.macrofocus.crossplatform.CPSpinner;
import com.macrofocus.crossplatform.CPSwitch;
import com.macrofocus.format.CPFormat;
import com.macrofocus.labeling.EnhancedLabel;
import com.treemap.Scale;
import com.treemap.ScaleFactory;
import com.treemap.TreeMapField;
import com.treemap.TreeMapFieldSettings;
import com.treemap.TreeMapModel;
import com.treemap.app.document.HorizontalAlignmentFormat;
import com.treemap.app.document.VerticalAlignmentFormat;

class LabelsSettingsPanel<Component, Color, Font> {
    private final TreeMapModel treeMapModel;
    private final SingleSelection<TreeMapField> selection;
    private TreeMapFieldSettings settings;
    private final CPFormPanel<Component> layout;
    private final CPLabel<Component, Font> overrideDefaults;
    private final CPSwitch<Component> overrideCommonSettings;
    private final CPButton<Component> reset;
    private final CPFontPicker labelingFont;
    private final CPColorPicker labelingForeground;
    private final CPColorPicker labelingEffect;
    private final CPComboBox<Component, EnhancedLabel.ContrastEnhancement> labelingContrastEnhancement;
    private final CPComboBox<Component, Integer> horizontalAlignment;
    private final CPComboBox<Component, Integer> verticalAlignment;
    private final CPComboBox<Component, Scale> scale;
    private final CPComboBox<Component, EnhancedLabel.Rendering> labelingRendering;
    private final CPSpinner labelingMinimumCharactersToDisplay;
    private final CPSwitch<Component> labelingShrinkTextToFitShape;
    private final CPSwitch<Component> labelingResizeTextToFitShape;

    public LabelsSettingsPanel(TreeMapModel treeMapModel, SingleSelection<TreeMapField> selection, CPFactory<Component, Font, ?, Color> factory) {
        this.treeMapModel = treeMapModel;
        this.selection = selection;
        this.settings = selection.isActive() ? treeMapModel.getSettings().getFieldSettings((TreeMapField)selection.getSelected()) : treeMapModel.getSettings().getDefaultFieldSettings();
        selection.addSingleSelectionListener((SingleSelectionListener)new SingleSelectionListener<TreeMapField>(){

            public void selectionChanged(SingleSelectionEvent<TreeMapField> event) {
                LabelsSettingsPanel.this.setTreeMapField((TreeMapField)event.getCurrentSelection());
            }
        });
        this.layout = factory.createFormPanel();
        this.overrideCommonSettings = factory.createSwitch(this.settings != null ? this.settings.getOverrideDefaultsProperty() : null);
        this.reset = factory.createButton("Reset");
        this.reset.setCommand(new Command(){

            public void execute() {
                LabelsSettingsPanel.this.settings.reset();
            }
        });
        this.overrideDefaults = factory.createLabel("Override Defaults:");
        this.layout.add(this.overrideDefaults, (CPComponent)factory.createGridPanel(1, 2, new CPComponent[]{this.overrideCommonSettings, this.reset}));
        this.overrideDefaults.setVisible(this.settings.getOverrideDefaultsProperty() != null);
        this.overrideCommonSettings.setVisible(this.settings.getOverrideDefaultsProperty() != null);
        this.reset.setVisible(this.settings.getOverrideDefaultsProperty() != null);
        this.labelingFont = factory.createFontPicker(this.settings.getLabelingFontProperty());
        this.labelingForeground = factory.createColorPicker(this.settings.getLabelingForegroundProperty());
        this.labelingEffect = factory.createColorPicker(this.settings.getLabelingEffectColorProperty());
        this.layout.add((CPComponent)factory.createLabel("Font:"), (CPComponent)factory.createGridPanel(1, 3, new CPComponent[]{this.labelingFont, this.labelingForeground, this.labelingEffect}));
        this.labelingContrastEnhancement = factory.createComboBox((MutableSingleSelection)new PropertySingleSelection(this.settings.getLabelingContrastEnhancementProperty()), Iterables.forArray((Object[])EnhancedLabel.ContrastEnhancement.values()));
        this.layout.add((CPComponent)factory.createLabel("Contrast Enhancement:"), this.labelingContrastEnhancement);
        this.horizontalAlignment = factory.createComboBox((MutableSingleSelection)new PropertySingleSelection(this.settings.getLabelingHorizontalAlignmentProperty()), Iterables.forIntArray((int[])new int[]{2, 0, 4}));
        this.horizontalAlignment.setFormat((CPFormat)HorizontalAlignmentFormat.getInstance());
        this.verticalAlignment = factory.createComboBox((MutableSingleSelection)new PropertySingleSelection(this.settings.getLabelingVerticalAlignmentProperty()), Iterables.forIntArray((int[])new int[]{1, 0, 3}));
        this.verticalAlignment.setFormat((CPFormat)VerticalAlignmentFormat.getInstance());
        this.layout.add((CPComponent)factory.createLabel("Alignment:"), (CPComponent)factory.createGridPanel(1, 2, new CPComponent[]{this.horizontalAlignment, this.verticalAlignment}));
        this.scale = factory.createComboBox((MutableSingleSelection)new PropertySingleSelection(this.settings.getScaleProperty()), (Iterable)ScaleFactory.getInstance().getScales());
        this.layout.add((CPComponent)factory.createLabel("Scale:"), this.scale);
        this.labelingRendering = factory.createComboBox((MutableSingleSelection)new PropertySingleSelection(this.settings.getLabelingRenderingProperty()), Iterables.forArray((Object[])EnhancedLabel.Rendering.values()));
        this.labelingMinimumCharactersToDisplay = factory.createIntegerSpinner(this.settings.getLabelingMinimumCharactersToDisplayProperty());
        this.layout.add((CPComponent)factory.createLabel("Overflow:"), (CPComponent)factory.createGridPanel(1, 2, new CPComponent[]{this.labelingRendering, this.labelingMinimumCharactersToDisplay}));
        this.labelingShrinkTextToFitShape = factory.createSwitch(this.settings.getLabelingShrinkTextToFitShapeProperty());
        this.layout.add((CPComponent)factory.createLabel("Shrink text to fit shape:"), this.labelingShrinkTextToFitShape);
        this.labelingResizeTextToFitShape = factory.createSwitch(this.settings.getLabelingResizeTextToFitShapeProperty());
        this.layout.add((CPComponent)factory.createLabel("Expand text to fit shape:"), this.labelingResizeTextToFitShape);
    }

    public void setTreeMapField(TreeMapField field) {
        this.settings = this.selection.isActive() ? this.treeMapModel.getSettings().getFieldSettings((TreeMapField)this.selection.getSelected()) : this.treeMapModel.getSettings().getDefaultFieldSettings();
        this.overrideCommonSettings.setProperty(this.settings != null ? this.settings.getOverrideDefaultsProperty() : null);
        this.overrideDefaults.setVisible(this.settings.getOverrideDefaultsProperty() != null);
        this.overrideCommonSettings.setVisible(this.settings.getOverrideDefaultsProperty() != null);
        this.reset.setVisible(this.settings.getOverrideDefaultsProperty() != null);
        this.labelingFont.setProperty(this.settings.getLabelingFontProperty());
        this.labelingForeground.setProperty(this.settings.getLabelingForegroundProperty());
        this.labelingEffect.setProperty(this.settings.getLabelingEffectColorProperty());
        this.labelingContrastEnhancement.setModel((MutableSingleSelection)new PropertySingleSelection(this.settings.getLabelingContrastEnhancementProperty()), Iterables.forArray((Object[])EnhancedLabel.ContrastEnhancement.values()));
        this.horizontalAlignment.setModel((MutableSingleSelection)new PropertySingleSelection(this.settings.getLabelingHorizontalAlignmentProperty()), Iterables.forIntArray((int[])new int[]{2, 0, 4}));
        this.verticalAlignment.setModel((MutableSingleSelection)new PropertySingleSelection(this.settings.getLabelingVerticalAlignmentProperty()), Iterables.forIntArray((int[])new int[]{1, 0, 3}));
        this.scale.setModel((MutableSingleSelection)new PropertySingleSelection(this.settings.getScaleProperty()), (Iterable)ScaleFactory.getInstance().getScales());
        this.labelingRendering.setModel((MutableSingleSelection)new PropertySingleSelection(this.settings.getLabelingRenderingProperty()), Iterables.forArray((Object[])EnhancedLabel.Rendering.values()));
        this.labelingMinimumCharactersToDisplay.setProperty(this.settings.getLabelingMinimumCharactersToDisplayProperty());
        this.labelingShrinkTextToFitShape.setProperty(this.settings.getLabelingShrinkTextToFitShapeProperty());
        this.labelingResizeTextToFitShape.setProperty(this.settings.getLabelingResizeTextToFitShapeProperty());
    }

    public CPComponent<Component> getPanel() {
        return this.layout;
    }
}

