/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.app.document;

import com.macrofocus.common.collection.Iterables;
import com.macrofocus.common.selection.MutableSingleSelection;
import com.macrofocus.common.selection.PropertySingleSelection;
import com.macrofocus.crossplatform.CPComboBox;
import com.macrofocus.crossplatform.CPComponent;
import com.macrofocus.crossplatform.CPFactory;
import com.macrofocus.crossplatform.CPFormPanel;
import com.macrofocus.format.CPFormat;
import com.treemap.Ordering;
import com.treemap.OrderingFactory;
import com.treemap.TreeMapFieldSettings;
import com.treemap.TreeMapModel;
import com.treemap.app.document.HorizontalAlignmentFormat;
import com.treemap.app.document.VerticalAlignmentFormat;

class LayoutSettingsPanel<Component, Color, Font> {
    private final TreeMapFieldSettings settings;
    private final CPFormPanel<Component> layout;

    public LayoutSettingsPanel(TreeMapModel treeMapModel, CPFactory<Component, Font, ?, Color> factory) {
        this.settings = treeMapModel.getSettings().getDefaultFieldSettings();
        this.layout = factory.createFormPanel();
        CPComboBox ordering = factory.createComboBox((MutableSingleSelection)new PropertySingleSelection(this.settings.getOrderingProperty()), (Iterable)OrderingFactory.getInstance().getOrderings());
        CPComboBox orderingDirection = factory.createComboBox((MutableSingleSelection)new PropertySingleSelection(this.settings.getOrderingDirectionProperty()), Iterables.forArray((Object[])Ordering.SortOrder.values()));
        this.layout.add((CPComponent)factory.createLabel("Ordering:"), (CPComponent)factory.createGridPanel(1, 2, new CPComponent[]{ordering, orderingDirection}));
        CPComboBox horizontalVanishingPoint = factory.createComboBox((MutableSingleSelection)new PropertySingleSelection(this.settings.getOrderingHorizontalVanishingPointProperty()), Iterables.forIntArray((int[])new int[]{2, 0, 4}));
        horizontalVanishingPoint.setFormat((CPFormat)HorizontalAlignmentFormat.getInstance());
        CPComboBox verticalVanishingPoint = factory.createComboBox((MutableSingleSelection)new PropertySingleSelection(this.settings.getOrderingVerticalVanishingPointProperty()), Iterables.forIntArray((int[])new int[]{1, 0, 3}));
        verticalVanishingPoint.setFormat((CPFormat)VerticalAlignmentFormat.getInstance());
        this.layout.add((CPComponent)factory.createLabel("Vanishing Point:"), (CPComponent)factory.createGridPanel(1, 2, new CPComponent[]{horizontalVanishingPoint, verticalVanishingPoint}));
        this.layout.add((CPComponent)factory.createLabel("Background:"), (CPComponent)factory.createColorPicker(treeMapModel.getSettings().getBackgroundProperty()));
    }

    public CPComponent<Component> getPanel() {
        return this.layout;
    }
}

