/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.plot.guide;

import com.macrofocus.crossplatform.CPCalendarFactory;
import com.macrofocus.crossplatform.CPLocaleFactory;
import com.macrofocus.crossplatform.CPTimeZoneFactory;
import com.macrofocus.crossplatform.swing.SwingCalendarFactory;
import com.macrofocus.crossplatform.swing.SwingFactory;
import com.macrofocus.crossplatform.swing.SwingLocaleFactory;
import com.macrofocus.crossplatform.swing.SwingTimeZoneFactory;
import com.macrofocus.format.CPFormat;
import com.macrofocus.format.FormatFactory;
import com.macrofocus.format.swing.SwingFormatFactory;
import com.macrofocus.igraphics.CPColor;
import com.macrofocus.igraphics.CPFontFactory;
import com.macrofocus.igraphics.IGraphics;
import com.macrofocus.igraphics.IHeadless;
import com.macrofocus.igraphics.swing.SwingColor;
import com.macrofocus.igraphics.swing.SwingIHeadless;
import com.macrofocus.plot.AxisPlotPanel;
import com.macrofocus.plot.guide.AbstractSwingAxisGuide;
import com.macrofocus.plot.guide.AxisSpace;
import com.macrofocus.plot.guide.DateAxis;
import com.macrofocus.plot.guide.DateTick;
import com.macrofocus.plot.guide.Guide;
import com.macrofocus.plot.guide.RectangleEdge;
import com.macrofocus.plot.guide.ValueAxis;
import com.macrofocus.transform.OneDScreenTransform;
import com.macrofocus.transform.ScreenTransformEvent;
import com.macrofocus.transform.ScreenTransformListener;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.util.Calendar;
import java.util.List;
import java.util.TimeZone;

public class SwingDateOneDScreenTransformAxisGuide
extends AbstractSwingAxisGuide {
    private static final long DAY = 86400000L;
    private final Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
    private final CPColor labelColor = new SwingColor(Color.black);
    private final CPColor frameColor = new SwingColor(215, 215, 211);
    private final Type type;
    private final ScreenTransformListener coordinateAxisListener = new ScreenTransformListener(){

        public void transformChanged(ScreenTransformEvent event) {
            SwingDateOneDScreenTransformAxisGuide.this.repaint();
            if (SwingDateOneDScreenTransformAxisGuide.this.panel != null) {
                SwingDateOneDScreenTransformAxisGuide.this.panel.valideAxis();
            }
        }
    };
    private OneDScreenTransform coordinateAxis;
    private ValueAxis axis;
    private CPFormat format;
    private CPColor gridLinesColor = new SwingColor(199, 199, 196);
    private boolean drawFrame = false;
    private boolean drawNight = true;
    private AxisPlotPanel panel;

    public SwingDateOneDScreenTransformAxisGuide(Type type, OneDScreenTransform coordinateAxis) {
        this(type);
        this.setCoordinateAxis(coordinateAxis);
    }

    public SwingDateOneDScreenTransformAxisGuide(Type type) {
        this.type = type;
    }

    @Override
    public void setPanel(AxisPlotPanel panel) {
        this.panel = panel;
    }

    @Override
    public double computeSpace(IGraphics g2, Rectangle dataArea) {
        AxisSpace space = new AxisSpace();
        this.getAxis().reserveSpace(g2, (Rectangle2D)dataArea, RectangleEdge.Bottom, space);
        return space.getBottom() + 4.0;
    }

    @Override
    public void setFormat(CPFormat format) {
        this.format = format;
        if (this.axis != null) {
            this.axis.setFormatOverride(this.format);
        }
        this.repaint();
    }

    @Override
    public void drawGrid(IGraphics g2, Dimension d) {
        if (this.coordinateAxis != null) {
            double max;
            Rectangle2D.Float dataArea = new Rectangle2D.Float(0.0f, 0.0f, d.width, d.height);
            double min = this.coordinateAxis.getWorldMin();
            if (min < (max = this.coordinateAxis.getWorldMax())) {
                this.getAxis().setRange(min, max);
                List ticks = this.getAxis().refreshTicks(g2, (Rectangle2D)dataArea, RectangleEdge.Bottom);
                for (Object tick : ticks) {
                    DateTick t = (DateTick)tick;
                    double value = t.getValue();
                    this.gridLineRenderer.drawGridLine(g2, Guide.Type.Bottom, this.coordinateAxis, d, value);
                }
            }
        }
    }

    @Override
    public void paintComponent(IGraphics g2) {
        super.paintComponent(g2);
        Dimension d = this.getSize();
        if (this.coordinateAxis != null) {
            double max;
            Rectangle2D.Float dataArea = new Rectangle2D.Float(0.0f, 0.0f, d.width, d.height);
            double min = this.coordinateAxis.getWorldMin();
            if (min < (max = this.coordinateAxis.getWorldMax())) {
                int y;
                int y2;
                int y1;
                this.getAxis().setRange(min, max);
                List ticks = this.getAxis().refreshTicks(g2, (Rectangle2D)dataArea, RectangleEdge.Bottom);
                g2.setColor((CPColor)new SwingColor(Color.darkGray));
                if (this.drawNight) {
                    int height;
                    int y12;
                    long now = (long)min;
                    this.calendar.setTimeInMillis(now);
                    switch (this.type) {
                        case Top: {
                            y12 = d.height - 4;
                            height = 4;
                            break;
                        }
                        case Bottom: {
                            y12 = 0;
                            height = 4;
                            break;
                        }
                        default: {
                            y12 = 0;
                            height = 0;
                        }
                    }
                    do {
                        this.calendar.set(11, 0);
                        this.calendar.set(12, 0);
                        this.calendar.set(13, 0);
                        this.calendar.set(14, 0);
                        int morning1 = this.coordinateAxis.worldToScreen((double)this.calendar.getTimeInMillis());
                        this.calendar.set(11, 6);
                        int morning2 = this.coordinateAxis.worldToScreen((double)this.calendar.getTimeInMillis());
                        g2.fillRectangle(morning1, y12, morning2 - morning1 + 1, height);
                        this.calendar.set(11, 18);
                        int evening1 = this.coordinateAxis.worldToScreen((double)this.calendar.getTimeInMillis());
                        this.calendar.set(11, 23);
                        this.calendar.set(12, 59);
                        this.calendar.set(13, 59);
                        this.calendar.set(14, 999);
                        int evening2 = this.coordinateAxis.worldToScreen((double)this.calendar.getTimeInMillis());
                        g2.fillRectangle(evening1, y12, evening2 - evening1 + 1, height);
                        this.calendar.add(5, 1);
                    } while ((double)this.calendar.getTimeInMillis() < max + 8.64E7);
                }
                switch (this.type) {
                    case Top: {
                        y1 = d.height - 5;
                        y2 = d.height;
                        y = d.height - 6;
                        break;
                    }
                    case Bottom: {
                        y1 = 0;
                        y2 = 5;
                        y = d.height - 2;
                        break;
                    }
                    default: {
                        y1 = 0;
                        y2 = 0;
                        y = 0;
                    }
                }
                for (Object tick : ticks) {
                    DateTick t = (DateTick)tick;
                    int x = this.coordinateAxis.worldToScreen(t.getValue());
                    g2.setColor(this.gridLinesColor);
                    g2.drawLine(x, y1, x, y2);
                    g2.setColor(this.labelColor);
                    String text = t.getText();
                    float width = g2.getStringWidth(text);
                    g2.drawString(text, (float)x - width / 2.0f, (float)y);
                }
                if (this.drawFrame) {
                    g2.setColor(this.frameColor);
                    g2.drawRectange(0, 0, d.width - 1, d.height - 1);
                }
            }
        }
    }

    private ValueAxis getAxis() {
        if (this.axis == null) {
            this.axis = new DateAxis((CPFontFactory)SwingFactory.getInstance(), (IHeadless)new SwingIHeadless(), (FormatFactory)SwingFormatFactory.getInstance(), (CPTimeZoneFactory)SwingTimeZoneFactory.getInstance(), (CPLocaleFactory)SwingLocaleFactory.getInstance(), (CPCalendarFactory)SwingCalendarFactory.getInstance());
            this.axis.setTickLabelFont(SwingFactory.getInstance().createFont("Tahoma", 0, 10));
            if (this.format != null) {
                this.axis.setFormatOverride(this.format);
            }
        }
        return this.axis;
    }

    @Override
    public void setAxis(ValueAxis axis) {
        this.axis = axis;
        this.repaint();
    }

    @Override
    public void setGridLinesColor(CPColor gridLinesColor) {
        this.gridLinesColor = gridLinesColor;
        this.repaint();
    }

    public void setDrawFrame(boolean drawFrame) {
        this.drawFrame = drawFrame;
        this.repaint();
    }

    public void setDrawNight(boolean drawNight) {
        this.drawNight = drawNight;
        this.repaint();
    }

    public OneDScreenTransform getCoordinateAxis() {
        return this.coordinateAxis;
    }

    @Override
    public void setCoordinateAxis(OneDScreenTransform coordinateAxis) {
        if (this.coordinateAxis != null) {
            this.coordinateAxis.removeScreenTransformListener(this.coordinateAxisListener);
        }
        this.coordinateAxis = coordinateAxis;
        if (this.coordinateAxis != null) {
            this.coordinateAxis.addScreenTransformListener(this.coordinateAxisListener);
        }
        this.repaint();
    }

    public static enum Type {
        Top,
        Bottom;

    }
}

