/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.slider.swing;

import com.macrofocus.slider.RangeSliderEvent;
import com.macrofocus.slider.RangeSliderListener;
import com.macrofocus.slider.RangeSliderModel;
import com.macrofocus.slider.swing.JSliderView;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.UIManager;

public class ColoredCursorSliderView
extends JSliderView {
    protected boolean leftToRight = true;
    protected Rectangle thumbBounds = new Rectangle();
    protected Rectangle trackBounds = new Rectangle();
    private int orientation;
    protected RangeSliderModel rangeSliderModel;
    protected Rectangle minRectangle = new Rectangle();
    protected Rectangle maxRectangle = new Rectangle();
    protected Rectangle rangeRectangle = new Rectangle();
    private boolean showMinHandle = true;
    private boolean showMaxHandle = true;
    private Color arrowColor = Color.lightGray;
    private Color rangeColor = Color.white;
    private boolean paintRange = false;
    private static final int NORTH = 1;
    private static final int SOUTH = 2;
    private static final int EAST = 3;
    private static final int WEST = 4;

    public ColoredCursorSliderView(RangeSliderModel rangeSliderModel, int orientation) {
        this.rangeSliderModel = rangeSliderModel;
        this.orientation = orientation;
        this.updateRectangles();
        rangeSliderModel.addSliderListener(new RangeSliderListener(){

            public void sliderChanged(RangeSliderEvent e) {
                ColoredCursorSliderView.this.updateRectangles();
                ColoredCursorSliderView.this.repaint();
            }

            public void sliderScaleChanged(RangeSliderEvent e) {
                ColoredCursorSliderView.this.updateRectangles();
                ColoredCursorSliderView.this.repaint();
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                ColoredCursorSliderView.this.updateRectangles();
                ColoredCursorSliderView.this.repaint();
            }
        });
    }

    public RangeSliderModel getRangeSliderModel() {
        return this.rangeSliderModel;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public Rectangle getTrackBounds() {
        return this.trackBounds;
    }

    public Rectangle getThumbBounds() {
        return this.thumbBounds;
    }

    public Rectangle getMinBounds() {
        return this.minRectangle;
    }

    public Rectangle getMaxBounds() {
        return this.maxRectangle;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        if (this.rangeSliderModel.getMaximum() != this.rangeSliderModel.getMinimum()) {
            if (this.paintRange) {
                g.setColor(this.rangeColor);
                int x1 = (int)this.minRectangle.getCenterX();
                int x2 = (int)this.maxRectangle.getCenterX();
                g2.fillRect(x1, this.getHeight() / 2, x2 - x1, this.getHeight() / 2);
            }
            if (this.getOrientation() == 1) {
                if (this.showMaxHandle) {
                    g.translate(this.maxRectangle.x, this.maxRectangle.y);
                    this.paintArrowButton(this, g, 2, new Rectangle(0, 0, this.maxRectangle.width, this.maxRectangle.height));
                    g.translate(-this.maxRectangle.x, -this.maxRectangle.y);
                }
                if (this.showMinHandle) {
                    g.translate(this.minRectangle.x, this.minRectangle.y);
                    this.paintArrowButton(this, g, 1, new Rectangle(0, 0, this.minRectangle.width, this.minRectangle.height));
                    g.translate(-this.minRectangle.x, -this.minRectangle.y);
                }
            } else {
                if (this.showMaxHandle) {
                    g.translate(this.maxRectangle.x, this.maxRectangle.y);
                    this.paintArrowButton(this, g, 4, new Rectangle(0, 0, this.maxRectangle.width, this.maxRectangle.height));
                    g.translate(-this.maxRectangle.x, -this.maxRectangle.y);
                }
                if (this.showMinHandle) {
                    g.translate(this.minRectangle.x, this.minRectangle.y);
                    this.paintArrowButton(this, g, 3, new Rectangle(0, 0, this.minRectangle.width, this.minRectangle.height));
                    g.translate(-this.minRectangle.x, -this.minRectangle.y);
                }
            }
        }
    }

    public void paintArrowButton(JSliderView sliderView, Graphics g, int direction, Rectangle bounds) {
        int width = bounds.width;
        int height = bounds.height;
        int w = width;
        int h = height;
        if (direction == 1) {
            int arrowHeight = (height + 1) / 2;
            g.setColor(this.arrowColor);
            int startX = (w + 1 - arrowHeight) / 2 + arrowHeight - 1 + 1;
            int startY = h / 2 - 1;
            for (int line = 0; line < arrowHeight; ++line) {
                g.drawLine(startX - line, startY - line, startX - line, startY + line + 1);
            }
            g.setColor(Color.black);
            g.drawLine(startX - arrowHeight, startY - arrowHeight, startX - arrowHeight, startY + arrowHeight + 1);
            g.drawLine(startX - arrowHeight, startY - arrowHeight, startX + 1, startY + 1);
            g.drawLine(startX - arrowHeight, startY + arrowHeight + 2, startX + 1, startY + 1);
        } else if (direction == 2) {
            int arrowHeight = (height + 1) / 2;
            g.setColor(this.arrowColor);
            int startX = (w + 1 - arrowHeight) / 2 + arrowHeight - 1 + 1;
            int startY = h / 2 - 1;
            for (int line = 0; line < arrowHeight; ++line) {
                g.drawLine(startX - line, startY - line, startX - line, startY + line + 1);
            }
            g.setColor(Color.black);
            g.drawLine(startX - arrowHeight, startY - arrowHeight, startX - arrowHeight, startY + arrowHeight + 1);
            g.drawLine(startX - arrowHeight, startY - arrowHeight, startX + 1, startY + 1);
            g.drawLine(startX - arrowHeight, startY + arrowHeight + 2, startX + 1, startY + 1);
        } else if (direction == 3) {
            int arrowWidth = (width + 1) / 2;
            g.setColor(this.arrowColor);
            int startX = w / 2 - 1;
            int startY = (h + 1 - arrowWidth) / 2 + arrowWidth + 2;
            for (int line = 0; line < arrowWidth; ++line) {
                g.drawLine(startX - line, startY - line, startX + line + 1, startY - line);
            }
            g.setColor(Color.black);
            g.drawLine(startX - arrowWidth, startY - arrowWidth, startX + arrowWidth + 1, startY - arrowWidth);
            g.drawLine(startX - arrowWidth, startY - arrowWidth, startX + 1, startY + 1);
            g.drawLine(startX + arrowWidth + 2, startY - arrowWidth, startX + 1, startY + 1);
        } else if (direction == 4) {
            int arrowWidth = (width + 1) / 2;
            g.setColor(this.arrowColor);
            int startX = w / 2 - 1;
            int startY = (h + 1 - arrowWidth) / 2 + arrowWidth + 2;
            for (int line = 0; line < arrowWidth; ++line) {
                g.drawLine(startX - line, startY - line, startX + line + 1, startY - line);
            }
            g.setColor(Color.black);
            g.drawLine(startX - arrowWidth, startY - arrowWidth, startX + arrowWidth + 1, startY - arrowWidth);
            g.drawLine(startX - arrowWidth, startY - arrowWidth, startX + 1, startY + 1);
            g.drawLine(startX + arrowWidth + 2, startY - arrowWidth, startX + 1, startY + 1);
        }
    }

    @Override
    public Dimension getMinimumSize() {
        if (UIManager.get("ScrollBar.width") != null) {
            int scrollBarWidth = (Integer)UIManager.get("ScrollBar.width");
            if (this.getOrientation() == 1) {
                return new Dimension(scrollBarWidth, scrollBarWidth * 3 + 10);
            }
            return new Dimension(scrollBarWidth * 3 + 10, scrollBarWidth);
        }
        return this.getOrientation() == 1 ? new Dimension(16, 48) : new Dimension(48, 16);
    }

    protected void updateRectangles() {
        Dimension size;
        if (this.getOrientation() == 1) {
            int width;
            size = this.getSize();
            int screenWidth = size.width;
            int x = 0;
            int height = width = screenWidth - 0;
            int button = height / 2;
            int minY = this.toScreen(this.rangeSliderModel.getCurrentMinimum()) - button;
            int maxY = this.toScreen(this.rangeSliderModel.getCurrentMaximum()) - button;
            this.maxRectangle.setBounds(x, maxY, width, height);
            this.minRectangle.setBounds(x, minY, width, height);
        } else {
            int height;
            size = this.getSize();
            int screenWidth = size.width;
            int screenHeight = size.height;
            int y = 0;
            int width = height = screenHeight - 0;
            int button = width / 2;
            int minX = this.toScreen(this.rangeSliderModel.getCurrentMinimum()) - button;
            int maxX = this.toScreen(this.rangeSliderModel.getCurrentMaximum()) - button;
            this.maxRectangle.setBounds(maxX, y, width, height);
            this.minRectangle.setBounds(minX, y, width, height);
        }
        if (this.getOrientation() == 1) {
            size = this.getSize();
            this.trackBounds.setBounds(0, 0, size.width - 0, size.height - 0);
            this.rangeRectangle.setBounds(0, this.maxRectangle.y + this.maxRectangle.height, size.width, this.minRectangle.y - this.maxRectangle.y - this.maxRectangle.height);
            this.thumbBounds.setBounds(0, this.maxRectangle.y + this.maxRectangle.height, size.width, this.minRectangle.y - this.maxRectangle.y - this.maxRectangle.height);
        } else {
            size = this.getSize();
            this.trackBounds.setBounds(0, 0, size.width - 0, size.height - 0);
            this.rangeRectangle.setBounds(this.minRectangle.x + this.minRectangle.width, 0, this.maxRectangle.x - this.minRectangle.x - this.minRectangle.width, size.height);
            this.thumbBounds.setBounds(this.minRectangle.x + this.minRectangle.width, 0, this.maxRectangle.x - this.minRectangle.x - this.minRectangle.width, size.height);
        }
    }

    public int toScreen(double value) {
        if (this.getOrientation() == 1) {
            double screenRange = this.getHeight();
            double worldRange = this.rangeSliderModel.getMaximum() - this.rangeSliderModel.getMinimum();
            return (int)Math.round(screenRange * (worldRange - (value - this.rangeSliderModel.getMinimum())) / worldRange);
        }
        double screenRange = this.getWidth();
        double worldRange = this.rangeSliderModel.getMaximum() - this.rangeSliderModel.getMinimum();
        return (int)Math.round(screenRange * (value - this.rangeSliderModel.getMinimum()) / worldRange);
    }

    public double toWorld(int value) {
        if (this.getOrientation() == 1) {
            Dimension size = this.getSize();
            int screenHeight = size.height;
            double screenRange = screenHeight;
            double worldRange = this.rangeSliderModel.getMaximum() - this.rangeSliderModel.getMinimum();
            return worldRange * (screenRange - (double)value) / screenRange;
        }
        Dimension size = this.getSize();
        int screenWidth = size.width;
        double screenRange = screenWidth;
        double worldRange = this.rangeSliderModel.getMaximum() - this.rangeSliderModel.getMinimum();
        return worldRange * (double)value / screenRange;
    }

    public int getScreenRange() {
        Dimension size = this.getSize();
        int screenWidth = size.width;
        int screenHeight = size.height;
        if (this.getOrientation() == 1) {
            int screenRange = screenHeight;
            return screenRange;
        }
        int screenRange = screenWidth;
        return screenRange;
    }

    public Component getComponent() {
        return this;
    }

    public void setShowMinHandle(boolean showMinHandle) {
        if (this.showMinHandle != showMinHandle) {
            this.showMinHandle = showMinHandle;
            this.repaint();
        }
    }

    public void setShowMaxHandle(boolean showMaxHandle) {
        if (this.showMaxHandle != showMaxHandle) {
            this.showMaxHandle = showMaxHandle;
            this.repaint();
        }
    }

    public void setArrowColor(Color arrowColor) {
        this.arrowColor = arrowColor;
        this.repaint();
    }

    public void setRangeColor(Color rangeColor) {
        this.rangeColor = rangeColor;
        this.repaint();
    }

    public void setPaintRange(boolean paintRange) {
        this.paintRange = paintRange;
        this.repaint();
    }
}

