/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.auth;

import java.sql.Connection;
import java.sql.DriverManager;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import org.jdesktop.beans.JavaBean;
import org.jdesktop.swingx.auth.LoginService;

@JavaBean
public class JDBCLoginService
extends LoginService {
    private static final Logger LOG = Logger.getLogger(JDBCLoginService.class.getName());
    private Connection conn;
    private String jndiContext;
    private Properties properties;

    public JDBCLoginService(String driver, String url) {
        super(url);
        try {
            Class.forName(driver);
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "The driver passed to the JDBCLoginService constructor could not be loaded. This may be due to the driver not being on the classpath", e);
        }
        this.setUrl(url);
    }

    public JDBCLoginService(String driver, String url, Properties props) {
        super(url);
        try {
            Class.forName(driver);
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "The driver passed to the JDBCLoginService constructor could not be loaded. This may be due to the driver not being on the classpath", e);
        }
        this.setUrl(url);
        this.setProperties(props);
    }

    public JDBCLoginService(String jndiContext) {
        super(jndiContext);
        this.jndiContext = jndiContext;
    }

    public JDBCLoginService() {
    }

    public String getUrl() {
        return this.getServer();
    }

    public void setUrl(String url) {
        String old = this.getUrl();
        this.setServer(url);
        this.firePropertyChange("url", old, this.getUrl());
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        Properties old = this.getProperties();
        this.properties = properties;
        this.firePropertyChange("properties", old, this.getProperties());
    }

    public Connection getConnection() {
        return this.conn;
    }

    public void setConnection(Connection conn) {
        Connection old = this.getConnection();
        this.conn = conn;
        this.firePropertyChange("connection", old, this.getConnection());
    }

    private void connectByJNDI(String userName, char[] password) throws Exception {
        InitialContext ctx = new InitialContext();
        DataSource ds = (DataSource)ctx.lookup(this.jndiContext);
        this.conn = ds.getConnection(userName, new String(password));
        this.conn.setTransactionIsolation(4);
    }

    private void connectByDriverManager(String userName, char[] password) throws Exception {
        if (this.getProperties() != null) {
            try {
                this.conn = DriverManager.getConnection(this.getUrl(), this.getProperties());
                this.conn.setTransactionIsolation(4);
            }
            catch (Exception e) {
                try {
                    this.conn = DriverManager.getConnection(this.getUrl(), userName, new String(password));
                    this.conn.setTransactionIsolation(4);
                }
                catch (Exception ex) {
                    this.conn = DriverManager.getConnection(this.getUrl());
                    this.conn.setTransactionIsolation(4);
                }
            }
        } else {
            try {
                this.conn = DriverManager.getConnection(this.getUrl(), userName, new String(password));
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, "Connection with properties failed. Tryint to connect without.", e);
                this.conn = DriverManager.getConnection(this.getUrl());
            }
        }
    }

    @Override
    public boolean authenticate(String name, char[] password, String server) throws Exception {
        if (this.jndiContext != null) {
            try {
                this.connectByJNDI(name, password);
            }
            catch (Exception e) {
                try {
                    this.connectByDriverManager(name, password);
                }
                catch (Exception ex) {
                    LOG.log(Level.WARNING, "Login failed", ex);
                    return false;
                }
            }
        } else {
            try {
                this.connectByDriverManager(name, password);
            }
            catch (Exception ex) {
                LOG.log(Level.WARNING, "", ex);
                return false;
            }
        }
        return true;
    }
}

