/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.event;

import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;

public class WeakEventListenerList
implements Serializable {
    protected transient List<WeakReference<? extends EventListener>> weakReferences;
    protected transient List<Class<? extends EventListener>> classes;

    public Object[] getListenerList() {
        List listeners = this.cleanReferences();
        Object[] result = new Object[listeners.size() * 2];
        int i = 0;
        while (i < listeners.size()) {
            result[2 * i + 1] = listeners.get(i);
            result[2 * i] = this.getClasses().get(i);
            ++i;
        }
        return result;
    }

    private synchronized <T extends EventListener> List<T> cleanReferences() {
        ArrayList<EventListener> listeners = new ArrayList<EventListener>();
        int i = this.getReferences().size() - 1;
        while (i >= 0) {
            Object listener = this.getReferences().get(i).get();
            if (listener == null) {
                this.getReferences().remove(i);
                this.getClasses().remove(i);
            } else {
                listeners.add(0, (EventListener)listener);
            }
            --i;
        }
        return listeners;
    }

    private List<WeakReference<? extends EventListener>> getReferences() {
        if (this.weakReferences == null) {
            this.weakReferences = new ArrayList<WeakReference<? extends EventListener>>();
        }
        return this.weakReferences;
    }

    private List<Class<? extends EventListener>> getClasses() {
        if (this.classes == null) {
            this.classes = new ArrayList<Class<? extends EventListener>>();
        }
        return this.classes;
    }

    public <T extends EventListener> T[] getListeners(Class<T> t) {
        List<T> liveListeners = this.cleanReferences();
        ArrayList<EventListener> listeners = new ArrayList<EventListener>();
        int i = 0;
        while (i < liveListeners.size()) {
            if (this.getClasses().get(i) == t) {
                listeners.add((EventListener)liveListeners.get(i));
            }
            ++i;
        }
        EventListener[] result = (EventListener[])Array.newInstance(t, listeners.size());
        return listeners.toArray(result);
    }

    public synchronized <T extends EventListener> void add(Class<T> t, T l) {
        if (l == null) {
            return;
        }
        if (!t.isInstance(l)) {
            throw new IllegalArgumentException("Listener " + l + " is not of type " + t);
        }
        this.cleanReferences();
        this.getReferences().add(new WeakReference<T>(l));
        this.getClasses().add(t);
    }

    public synchronized <T extends EventListener> void remove(Class<T> t, T l) {
        if (l == null) {
            return;
        }
        if (!t.isInstance(l)) {
            throw new IllegalArgumentException("Listener " + l + " is not of type " + t);
        }
        int i = 0;
        while (i < this.getReferences().size()) {
            if (l.equals(this.getReferences().get(i).get()) && t == this.getClasses().get(i)) {
                this.getReferences().remove(i);
                this.getClasses().remove(i);
                break;
            }
            ++i;
        }
    }
}

