/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.image;

import java.awt.image.BufferedImage;
import org.jdesktop.swingx.image.AbstractFilter;
import org.jdesktop.swingx.util.GraphicsUtilities;

public class FastBlurFilter
extends AbstractFilter {
    private final int radius;

    public FastBlurFilter() {
        this(3);
    }

    public FastBlurFilter(int radius) {
        if (radius < 1) {
            radius = 1;
        }
        this.radius = radius;
    }

    public int getRadius() {
        return this.radius;
    }

    @Override
    public BufferedImage filter(BufferedImage src, BufferedImage dst) {
        int width = src.getWidth();
        int height = src.getHeight();
        if (dst == null) {
            dst = this.createCompatibleDestImage(src, null);
        }
        int[] srcPixels = new int[width * height];
        int[] dstPixels = new int[width * height];
        GraphicsUtilities.getPixels(src, 0, 0, width, height, srcPixels);
        FastBlurFilter.blur(srcPixels, dstPixels, width, height, this.radius);
        FastBlurFilter.blur(dstPixels, srcPixels, height, width, this.radius);
        GraphicsUtilities.setPixels(dst, 0, 0, width, height, srcPixels);
        return dst;
    }

    static void blur(int[] srcPixels, int[] dstPixels, int width, int height, int radius) {
        int i;
        int windowSize = radius * 2 + 1;
        int radiusPlusOne = radius + 1;
        int srcIndex = 0;
        int[] sumLookupTable = new int[256 * windowSize];
        int i2 = 0;
        while (i2 < sumLookupTable.length) {
            sumLookupTable[i2] = i2 / windowSize;
            ++i2;
        }
        int[] indexLookupTable = new int[radiusPlusOne];
        if (radius < width) {
            i = 0;
            while (i < indexLookupTable.length) {
                indexLookupTable[i] = i;
                ++i;
            }
        } else {
            i = 0;
            while (i < width) {
                indexLookupTable[i] = i;
                ++i;
            }
            i = width;
            while (i < indexLookupTable.length) {
                indexLookupTable[i] = width - 1;
                ++i;
            }
        }
        int y = 0;
        while (y < height) {
            int sumBlue = 0;
            int sumGreen = 0;
            int sumRed = 0;
            int sumAlpha = 0;
            int dstIndex = y;
            int pixel = srcPixels[srcIndex];
            sumAlpha += radiusPlusOne * (pixel >> 24 & 0xFF);
            sumRed += radiusPlusOne * (pixel >> 16 & 0xFF);
            sumGreen += radiusPlusOne * (pixel >> 8 & 0xFF);
            sumBlue += radiusPlusOne * (pixel & 0xFF);
            int i3 = 1;
            while (i3 <= radius) {
                pixel = srcPixels[srcIndex + indexLookupTable[i3]];
                sumAlpha += pixel >> 24 & 0xFF;
                sumRed += pixel >> 16 & 0xFF;
                sumGreen += pixel >> 8 & 0xFF;
                sumBlue += pixel & 0xFF;
                ++i3;
            }
            int x = 0;
            while (x < width) {
                int previousPixelIndex;
                dstPixels[dstIndex] = sumLookupTable[sumAlpha] << 24 | sumLookupTable[sumRed] << 16 | sumLookupTable[sumGreen] << 8 | sumLookupTable[sumBlue];
                dstIndex += height;
                int nextPixelIndex = x + radiusPlusOne;
                if (nextPixelIndex >= width) {
                    nextPixelIndex = width - 1;
                }
                if ((previousPixelIndex = x - radius) < 0) {
                    previousPixelIndex = 0;
                }
                int nextPixel = srcPixels[srcIndex + nextPixelIndex];
                int previousPixel = srcPixels[srcIndex + previousPixelIndex];
                sumAlpha += nextPixel >> 24 & 0xFF;
                sumAlpha -= previousPixel >> 24 & 0xFF;
                sumRed += nextPixel >> 16 & 0xFF;
                sumRed -= previousPixel >> 16 & 0xFF;
                sumGreen += nextPixel >> 8 & 0xFF;
                sumGreen -= previousPixel >> 8 & 0xFF;
                sumBlue += nextPixel & 0xFF;
                sumBlue -= previousPixel & 0xFF;
                ++x;
            }
            srcIndex += width;
            ++y;
        }
    }
}

