/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.plaf.basic;

import de.javasoft.plaf.synthetica.util.HiDpi;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.HierarchyBoundsListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import org.jdesktop.swingx.JXHeader;
import org.jdesktop.swingx.painter.MattePainter;
import org.jdesktop.swingx.painter.Painter;
import org.jdesktop.swingx.plaf.HeaderUI;
import org.jdesktop.swingx.plaf.PainterUIResource;
import org.jdesktop.swingx.plaf.UIManagerExt;

public class BasicHeaderUI
extends HeaderUI {
    private static final Logger LOG = Logger.getLogger(BasicHeaderUI.class.getName());
    protected JLabel titleLabel;
    protected JTextPane descriptionPane;
    protected JLabel imagePanel;
    private PropertyChangeListener propListener;
    private HierarchyBoundsListener boundsListener;
    private Color gradientLightColor;
    private Color gradientDarkColor;

    public static ComponentUI createUI(JComponent c) {
        return new BasicHeaderUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        assert (c instanceof JXHeader);
        JXHeader header = (JXHeader)c;
        this.installDefaults(header);
        this.installComponents(header);
        this.installListeners(header);
    }

    @Override
    public void uninstallUI(JComponent c) {
        assert (c instanceof JXHeader);
        JXHeader header = (JXHeader)c;
        this.uninstallListeners(header);
        this.uninstallComponents(header);
        this.uninstallDefaults(header);
    }

    protected void installDefaults(JXHeader header) {
        this.gradientLightColor = UIManagerExt.getColor("JXHeader.startBackground");
        if (this.gradientLightColor == null) {
            this.gradientLightColor = Color.WHITE;
        }
        this.gradientDarkColor = UIManagerExt.getColor("JXHeader.background");
        if (this.gradientDarkColor == null) {
            this.gradientDarkColor = UIManagerExt.getColor("control");
            if (this.gradientDarkColor == null) {
                this.gradientDarkColor = Color.GRAY;
            }
        }
        if (this.isUIInstallable(header.getBackgroundPainter())) {
            header.setBackgroundPainter(this.createBackgroundPainter());
        }
        if (this.isUIInstallable(header.getTitleFont())) {
            Font titleFont = UIManager.getFont("JXHeader.titleFont");
            header.setTitleFont(titleFont != null ? titleFont : UIManager.getFont("Label.font"));
        }
        if (this.isUIInstallable(header.getTitleForeground())) {
            Color titleForeground = UIManagerExt.getColor("JXHeader.titleForeground");
            header.setTitleForeground(titleForeground != null ? titleForeground : UIManagerExt.getColor("Label.foreground"));
        }
        if (this.isUIInstallable(header.getDescriptionFont())) {
            Font descFont = UIManager.getFont("JXHeader.descriptionFont");
            header.setDescriptionFont(descFont != null ? descFont : UIManager.getFont("Label.font"));
        }
        if (this.isUIInstallable(header.getDescriptionForeground())) {
            Color descForeground = UIManagerExt.getColor("JXHeader.descriptionForeground");
            header.setDescriptionForeground(descForeground != null ? descForeground : UIManagerExt.getColor("Label.foreground"));
        }
        if (this.isUIInstallable(header.getIcon())) {
            header.setIcon(UIManager.getIcon("Header.defaultIcon"));
        }
    }

    protected void uninstallDefaults(JXHeader h) {
    }

    protected void installComponents(JXHeader header) {
        this.titleLabel = new JLabel();
        this.descriptionPane = new JTextPane(){
            private static final long serialVersionUID = -7766509177322885731L;

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(HiDpi.scale((Integer)100), super.getPreferredSize().height);
            }
        };
        this.descriptionPane.setEditable(false);
        this.descriptionPane.setOpaque(false);
        this.descriptionPane.putClientProperty("Synthetica.opaque", false);
        this.imagePanel = new JLabel();
        this.installComponentDefaults(header);
        header.setLayout(new GridBagLayout());
        this.resetLayout(header);
    }

    protected void uninstallComponents(JXHeader header) {
        this.uninstallComponentDefaults(header);
        header.remove(this.titleLabel);
        header.remove(this.descriptionPane);
        header.remove(this.imagePanel);
        this.titleLabel = null;
        this.descriptionPane = null;
        this.imagePanel = null;
    }

    protected void installComponentDefaults(JXHeader header) {
        this.titleLabel.setFont(this.getAsNotUIResource(header.getTitleFont()));
        this.titleLabel.setForeground(this.getAsNotUIResource(header.getTitleForeground()));
        this.titleLabel.setText(header.getTitle());
        this.descriptionPane.setFont(this.getAsNotUIResource(header.getDescriptionFont()));
        this.descriptionPane.setForeground(this.getAsNotUIResource(header.getDescriptionForeground()));
        this.descriptionPane.setOpaque(false);
        this.descriptionPane.setText(header.getDescription());
        this.imagePanel.setIcon(header.getIcon());
    }

    private Font getAsNotUIResource(Font font) {
        if (!(font instanceof UIResource)) {
            return font;
        }
        return font.deriveFont(font.getAttributes());
    }

    private Color getAsNotUIResource(Color color) {
        if (!(color instanceof UIResource)) {
            return color;
        }
        float[] rgb = color.getRGBComponents(null);
        return new Color(rgb[0], rgb[1], rgb[2], rgb[3]);
    }

    private boolean isUIInstallable(Object property) {
        return property == null || property instanceof UIResource;
    }

    protected void uninstallComponentDefaults(JXHeader header) {
    }

    protected void installListeners(final JXHeader header) {
        this.propListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                BasicHeaderUI.this.onPropertyChange(header, evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
            }
        };
        header.addPropertyChangeListener(this.propListener);
    }

    protected void uninstallListeners(JXHeader h) {
        h.removePropertyChangeListener(this.propListener);
        h.removeHierarchyBoundsListener(this.boundsListener);
    }

    protected void onPropertyChange(JXHeader h, String propertyName, Object oldValue, Object newValue) {
        if ("title".equals(propertyName)) {
            this.titleLabel.setText(h.getTitle());
        } else if ("description".equals(propertyName)) {
            this.descriptionPane.setText(h.getDescription());
        } else if ("icon".equals(propertyName)) {
            this.imagePanel.setIcon(h.getIcon());
        } else if ("enabled".equals(propertyName)) {
            boolean enabled = h.isEnabled();
            this.titleLabel.setEnabled(enabled);
            this.descriptionPane.setEnabled(enabled);
            this.imagePanel.setEnabled(enabled);
        } else if ("titleFont".equals(propertyName)) {
            this.titleLabel.setFont((Font)newValue);
        } else if ("descriptionFont".equals(propertyName)) {
            this.descriptionPane.setFont((Font)newValue);
        } else if ("titleForeground".equals(propertyName)) {
            this.titleLabel.setForeground((Color)newValue);
        } else if ("descriptionForeground".equals(propertyName)) {
            this.descriptionPane.setForeground((Color)newValue);
        } else if ("iconPosition".equals(propertyName)) {
            this.resetLayout(h);
        }
    }

    private void resetLayout(JXHeader h) {
        h.remove(this.titleLabel);
        h.remove(this.descriptionPane);
        h.remove(this.imagePanel);
        if (h.getIconPosition() == null || h.getIconPosition() == JXHeader.IconPosition.RIGHT) {
            h.add((Component)this.titleLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 21, 2, new Insets(12, 12, 0, 11), 0, 0));
            h.add((Component)this.descriptionPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 23, 1, new Insets(0, 24, 12, 11), 0, 0));
            h.add((Component)this.imagePanel, new GridBagConstraints(1, 0, 1, 2, 0.0, 1.0, 24, 0, new Insets(12, 0, 11, 11), 0, 0));
        } else {
            h.add((Component)this.titleLabel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 21, 2, new Insets(12, 12, 0, 11), 0, 0));
            h.add((Component)this.descriptionPane, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 23, 1, new Insets(0, 24, 12, 11), 0, 0));
            h.add((Component)this.imagePanel, new GridBagConstraints(0, 0, 1, 2, 0.0, 1.0, 24, 0, new Insets(12, 11, 0, 11), 0, 0));
        }
    }

    protected Painter createBackgroundPainter() {
        MattePainter p = new MattePainter(new GradientPaint(0.0f, 0.0f, this.gradientLightColor, 1.0f, 0.0f, this.gradientDarkColor));
        p.setPaintStretched(true);
        return new PainterUIResource<Object>(p);
    }
}

