/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.molap.importer;

import com.macrofocus.common.convert.AutoConverter;
import com.macrofocus.common.convert.TypeConverter;
import com.macrofocus.data.db.DatabaseDriver;
import com.macrofocus.data.db.JDBCTypes;
import com.macrofocus.molap.dataframe.AbstractDataFrame;
import com.macrofocus.molap.dataframe.DataFrame;
import com.macrofocus.molap.dataframe.DataFrameEvent;
import com.macrofocus.molap.index.DefaultUniqueIndex;
import com.macrofocus.molap.index.IntegerRangeUniqueIndex;
import com.macrofocus.molap.index.UniqueIndex;
import com.macrofocus.molap.series.Series;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class ResultSetDataFrame
extends AbstractDataFrame<Integer, String, Object> {
    private DefaultUniqueIndex<String> columnIndex;
    private UniqueIndex<Integer> rowIndex;
    private Object[][] objects;
    private Class[] classes;

    public ResultSetDataFrame(ResultSet rs) throws SQLException {
        this(null, rs, null);
    }

    public ResultSetDataFrame(DatabaseDriver driver, ResultSet rs, AutoConverter autoConverter) throws SQLException {
        HashMap<Object, Object> recycler = this.createRecycler();
        ResultSetMetaData meta = rs.getMetaData();
        int columnCount = meta.getColumnCount();
        this.classes = new Class[columnCount];
        String[] names = new String[columnCount];
        for (int c = 1; c <= columnCount; ++c) {
            String name;
            names[c - 1] = name = meta.getColumnName(c);
            if (driver != null) {
                this.classes[c - 1] = driver.getColumnType(meta, c);
                continue;
            }
            int type = meta.getColumnType(c);
            this.classes[c - 1] = JDBCTypes.getType((int)type);
        }
        ArrayList<Object[]> rows = new ArrayList<Object[]>();
        while (rs.next()) {
            Object[] row = new Object[columnCount];
            for (int column = 1; column <= columnCount; ++column) {
                Object object;
                Class columnType = this.classes[column - 1];
                if (driver != null) {
                    row[column - 1] = driver.getColumnValue(rs, columnType, column);
                    continue;
                }
                if (columnType.equals(String.class)) {
                    object = rs.getString(column);
                } else if (columnType.equals(Byte.class)) {
                    object = rs.getByte(column);
                } else if (columnType.equals(Short.class)) {
                    object = rs.getShort(column);
                } else if (columnType.equals(Integer.class)) {
                    object = rs.getInt(column);
                } else if (columnType.equals(Long.class)) {
                    object = rs.getLong(column);
                } else if (columnType.equals(Float.class)) {
                    object = Float.valueOf(rs.getFloat(column));
                } else if (columnType.equals(Double.class)) {
                    object = rs.getDouble(column);
                } else if (columnType.equals(BigDecimal.class)) {
                    object = rs.getBigDecimal(column);
                } else if (columnType.equals(Boolean.class)) {
                    object = rs.getBoolean(column);
                } else if (columnType.equals(java.util.Date.class)) {
                    object = rs.getDate(column);
                } else if (columnType.equals(Date.class)) {
                    object = rs.getDate(column);
                } else if (columnType.equals(Timestamp.class)) {
                    object = rs.getTimestamp(column);
                } else {
                    object = rs.getObject(column);
                    System.err.println("ResultSetDataFrame: Unknown class " + columnType + " for value " + object + (object != null ? " (" + object.getClass() + ")" : ""));
                }
                if (rs.wasNull()) {
                    object = null;
                }
                row[column - 1] = ResultSetDataFrame.recycle(recycler, object);
            }
            rows.add(row);
        }
        this.objects = new Object[rows.size()][];
        for (int row = 0; row < rows.size(); ++row) {
            this.objects[row] = (Object[])rows.get(row);
        }
        Object[] columns = new String[names.length];
        HashSet<String> unique = new HashSet<String>();
        for (int i = 0; i < names.length; ++i) {
            if (names[i] != null) {
                String header = names[i].intern();
                int c = 0;
                while (unique.contains(header)) {
                    header = header + "-" + c;
                }
                columns[i] = header;
                unique.add(header);
                continue;
            }
            columns[i] = Integer.toString(i);
        }
        this.columnIndex = new DefaultUniqueIndex(columns);
        this.rowIndex = new IntegerRangeUniqueIndex(0, this.objects.length - 1);
        if (autoConverter != null) {
            this.autoConvert(autoConverter);
        }
    }

    private HashMap<Object, Object> createRecycler() {
        return null;
    }

    private static Object recycle(Map<Object, Object> recycler, Object object) {
        return object;
    }

    public DefaultUniqueIndex<String> getColumnIndex() {
        return this.columnIndex;
    }

    public UniqueIndex<Integer> getRowIndex() {
        return this.rowIndex;
    }

    public Class getRowClass(Integer integer) {
        return Object.class;
    }

    public Class getColumnClass(String s) {
        return this.classes[this.getColumnIndex().getAddress((Object)s)];
    }

    public Object getValueAt(Integer integer, String s) {
        return this.objects[integer][this.getColumnIndex().getAddress((Object)s)];
    }

    public Series<String, ?> getRow(Integer integer) {
        return null;
    }

    public DataFrame join(Series series, String[] strings) {
        return null;
    }

    private void autoConvert(AutoConverter autoConverter) {
        boolean fireEvent = false;
        int column = 0;
        while (column < this.getColumnCount()) {
            final int c = column++;
            TypeConverter.Input input = new TypeConverter.Input(){

                public Class getType() {
                    return ResultSetDataFrame.this.getColumnClass((String)ResultSetDataFrame.this.getColumnKey(c));
                }

                public Object get(int index) {
                    return ResultSetDataFrame.this.getValueAt(index, (String)ResultSetDataFrame.this.getColumnKey(c));
                }

                public int size() {
                    return ResultSetDataFrame.this.getRowCount();
                }
            };
            TypeConverter.Output output = new TypeConverter.Output(){

                public void setType(Class type) {
                    ((ResultSetDataFrame)ResultSetDataFrame.this).classes[c] = type;
                }

                public void set(int index, Object value) {
                    ((ResultSetDataFrame)ResultSetDataFrame.this).objects[index][c] = value;
                }
            };
            fireEvent |= autoConverter.convert(input, output);
        }
        if (fireEvent) {
            this.notifyDataFrameChanged(new DataFrameEvent(null, null, true));
        }
    }
}

