/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.fasttrack;

import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.UUID;
import net.sf.mpxj.Duration;
import net.sf.mpxj.common.BooleanHelper;
import net.sf.mpxj.common.DateHelper;
import net.sf.mpxj.common.NumberHelper;
import net.sf.mpxj.fasttrack.FastTrackField;
import net.sf.mpxj.fasttrack.FastTrackTable;

class MapRow {
    protected final Map<FastTrackField, Object> m_map;
    private final FastTrackTable m_table;

    public MapRow(FastTrackTable table, Map<FastTrackField, Object> map) {
        this.m_table = table;
        this.m_map = map;
    }

    public String getString(FastTrackField type) {
        return (String)this.getObject(type);
    }

    public Integer getInteger(FastTrackField type) {
        return (Integer)this.getObject(type);
    }

    public Double getDouble(FastTrackField type) {
        return (Double)this.getObject(type);
    }

    public Double getCurrency(FastTrackField type) {
        return this.getDouble(type);
    }

    public boolean getBoolean(FastTrackField type) {
        boolean result = false;
        Object value = this.getObject(type);
        if (value != null) {
            result = BooleanHelper.getBoolean((Boolean)value);
        }
        return result;
    }

    public int getInt(FastTrackField type) {
        return NumberHelper.getInt((Number)this.getObject(type));
    }

    public Date getTimestamp(FastTrackField dateName, FastTrackField timeName) {
        Date result = null;
        Date date = this.getDate(dateName);
        if (date != null) {
            Calendar dateCal = DateHelper.popCalendar(date);
            Object timeObject = this.getObject(timeName);
            if (timeObject instanceof Date) {
                Calendar timeCal = DateHelper.popCalendar((Date)timeObject);
                dateCal.set(11, timeCal.get(11));
                dateCal.set(12, timeCal.get(12));
                dateCal.set(13, timeCal.get(13));
                dateCal.set(14, timeCal.get(14));
                DateHelper.pushCalendar(timeCal);
            }
            result = dateCal.getTime();
            DateHelper.pushCalendar(dateCal);
        }
        return result;
    }

    public Date getDate(FastTrackField type) {
        return (Date)this.getObject(type);
    }

    public Duration getDuration(FastTrackField type) {
        Double value = (Double)this.getObject(type);
        return value == null ? null : Duration.getInstance(value, this.m_table.getDurationTimeUnit());
    }

    public Duration getWork(FastTrackField type) {
        Double value = (Double)this.getObject(type);
        return value == null ? null : Duration.getInstance(value, this.m_table.getWorkTimeUnit());
    }

    public Object getObject(FastTrackField type) {
        return this.m_map.get(type);
    }

    public UUID getUUID(FastTrackField type) {
        String value = this.getString(type);
        UUID result = null;
        if (value != null && !value.isEmpty() && value.length() >= 36) {
            if (value.startsWith("{")) {
                value = value.substring(1, value.length() - 1);
            }
            if (value.length() > 16) {
                value = value.substring(0, 36);
            }
            result = UUID.fromString(value);
        }
        return result;
    }

    public Map<FastTrackField, Object> getMap() {
        return this.m_map;
    }
}

