/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpp;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import net.sf.mpxj.CostRateTable;
import net.sf.mpxj.CostRateTableEntry;
import net.sf.mpxj.Rate;
import net.sf.mpxj.Resource;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.common.DateHelper;
import net.sf.mpxj.common.NumberHelper;
import net.sf.mpxj.mpp.MPPUtility;

final class CostRateTableFactory {
    CostRateTableFactory() {
    }

    public void process(Resource resource, int index, byte[] data) {
        ArrayList<CostRateTableEntry> entries = new ArrayList<CostRateTableEntry>();
        Calendar cal = DateHelper.popCalendar();
        if (data == null) {
            if (index == 0) {
                Rate standardRate = resource.getStandardRate();
                TimeUnit standardRateUnits = standardRate.getUnits();
                Rate overtimeRate = resource.getOvertimeRate();
                TimeUnit overtimeRateUnits = overtimeRate.getUnits();
                Number costPerUse = resource.getCostPerUse();
                Date endDate = CostRateTableEntry.DEFAULT_ENTRY.getEndDate();
                entries.add(new CostRateTableEntry(standardRate, standardRateUnits, overtimeRate, overtimeRateUnits, costPerUse, null, endDate));
            } else {
                entries.add(CostRateTableEntry.DEFAULT_ENTRY);
            }
        } else {
            int i = 16;
            while (i + 44 <= data.length) {
                Rate standardRate = new Rate(MPPUtility.getDouble(data, i), TimeUnit.HOURS);
                TimeUnit standardRateFormat = this.getFormat(MPPUtility.getShort(data, i + 8));
                Rate overtimeRate = new Rate(MPPUtility.getDouble(data, i + 16), TimeUnit.HOURS);
                TimeUnit overtimeRateFormat = this.getFormat(MPPUtility.getShort(data, i + 24));
                Double costPerUse = NumberHelper.getDouble(MPPUtility.getDouble(data, i + 32) / 100.0);
                Date endDate = MPPUtility.getTimestampFromTenths(data, i + 40);
                if (endDate.getTime() > DateHelper.END_DATE_NA.getTime()) {
                    endDate = DateHelper.END_DATE_NA;
                } else {
                    cal.setTime(endDate);
                    int minutes = cal.get(12);
                    if (minutes % 5 == 0) {
                        cal.add(12, -1);
                        endDate = cal.getTime();
                    }
                }
                entries.add(new CostRateTableEntry(standardRate, standardRateFormat, overtimeRate, overtimeRateFormat, costPerUse, null, endDate));
                i += 44;
            }
        }
        Collections.sort(entries);
        CostRateTable result = new CostRateTable();
        for (int i = 0; i < entries.size(); ++i) {
            Date startDate;
            if (i == 0) {
                startDate = DateHelper.START_DATE_NA;
            } else {
                cal.setTime(((CostRateTableEntry)entries.get(i - 1)).getEndDate());
                cal.add(12, 1);
                startDate = cal.getTime();
            }
            CostRateTableEntry entry = (CostRateTableEntry)entries.get(i);
            result.add(new CostRateTableEntry(entry.getStandardRate(), entry.getStandardRateFormat(), entry.getOvertimeRate(), entry.getOvertimeRateFormat(), entry.getCostPerUse(), startDate, entry.getEndDate()));
        }
        resource.setCostRateTable(index, result);
    }

    private TimeUnit getFormat(int format) {
        TimeUnit result = format == 65535 ? TimeUnit.HOURS : MPPUtility.getWorkTimeUnits(format);
        return result;
    }
}

