/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.synchro;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import net.sf.mpxj.synchro.BlockReader;
import net.sf.mpxj.synchro.MapRow;
import net.sf.mpxj.synchro.StreamReader;

class UnknownBlockReader
extends BlockReader {
    private final int m_size;

    public UnknownBlockReader(StreamReader stream, int size) {
        super(stream);
        this.m_size = size;
    }

    @Override
    public List<MapRow> read() throws IOException {
        int header = this.m_stream.readInt();
        if (header != 111262928) {
            throw new IllegalArgumentException("Unexpected file format");
        }
        List<MapRow> blocks = super.read();
        this.m_stream.readInt();
        return blocks;
    }

    @Override
    protected void readBlock(Map<String, Object> map) throws IOException {
        map.put("UNKNOWN", this.m_stream.readBytes(this.m_size));
    }
}

