/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.turboproject;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.mpxj.ChildTaskContainer;
import net.sf.mpxj.CustomFieldContainer;
import net.sf.mpxj.Day;
import net.sf.mpxj.Duration;
import net.sf.mpxj.EventManager;
import net.sf.mpxj.FieldContainer;
import net.sf.mpxj.FieldType;
import net.sf.mpxj.MPXJException;
import net.sf.mpxj.Notes;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ProjectCalendarException;
import net.sf.mpxj.ProjectCalendarWeek;
import net.sf.mpxj.ProjectConfig;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.Relation;
import net.sf.mpxj.RelationType;
import net.sf.mpxj.Resource;
import net.sf.mpxj.ResourceAssignment;
import net.sf.mpxj.ResourceField;
import net.sf.mpxj.Task;
import net.sf.mpxj.TaskField;
import net.sf.mpxj.common.StreamHelper;
import net.sf.mpxj.reader.AbstractProjectStreamReader;
import net.sf.mpxj.turboproject.MapRow;
import net.sf.mpxj.turboproject.PEPUtility;
import net.sf.mpxj.turboproject.Table;
import net.sf.mpxj.turboproject.TableA0TAB;
import net.sf.mpxj.turboproject.TableA1TAB;
import net.sf.mpxj.turboproject.TableA2TAB;
import net.sf.mpxj.turboproject.TableA3TAB;
import net.sf.mpxj.turboproject.TableA5TAB;
import net.sf.mpxj.turboproject.TableCALXTAB;
import net.sf.mpxj.turboproject.TableCONTAB;
import net.sf.mpxj.turboproject.TableNCALTAB;
import net.sf.mpxj.turboproject.TableRTAB;
import net.sf.mpxj.turboproject.TableUSGTAB;
import net.sf.mpxj.turboproject.TableWBSTAB;

public final class TurboProjectReader
extends AbstractProjectStreamReader {
    private ProjectFile m_projectFile;
    private EventManager m_eventManager;
    private HashMap<String, Table> m_tables;
    private static final Table EMPTY_TABLE = new Table();
    private static final Map<String, Class<? extends Table>> TABLE_CLASSES = new HashMap<String, Class<? extends Table>>();
    private static final Map<FieldType, String> ALIASES;
    private static final Map<String, FieldType> RESOURCE_FIELDS;
    private static final Map<String, FieldType> A0TAB_FIELDS;
    private static final Map<String, FieldType> A1TAB_FIELDS;
    private static final Map<String, FieldType> A2TAB_FIELDS;
    private static final Map<String, FieldType> A3TAB_FIELDS;
    private static final Map<String, FieldType> A5TAB_FIELDS;

    @Override
    public ProjectFile read(InputStream stream) throws MPXJException {
        try {
            this.m_projectFile = new ProjectFile();
            this.m_eventManager = this.m_projectFile.getEventManager();
            this.m_tables = new HashMap();
            ProjectConfig config = this.m_projectFile.getProjectConfig();
            config.setAutoResourceID(false);
            config.setAutoCalendarUniqueID(false);
            config.setAutoResourceUniqueID(false);
            config.setAutoTaskID(false);
            config.setAutoTaskUniqueID(false);
            config.setAutoOutlineLevel(true);
            config.setAutoOutlineNumber(true);
            config.setAutoWBS(true);
            this.m_projectFile.getProjectProperties().setFileApplication("TurboProject");
            this.m_projectFile.getProjectProperties().setFileType("PEP");
            this.addListenersToProject(this.m_projectFile);
            this.applyAliases();
            this.readFile(stream);
            this.readCalendars();
            this.readResources();
            this.readTasks();
            this.readRelationships();
            this.readResourceAssignments();
            config.updateUniqueCounters();
            ProjectFile projectFile = this.m_projectFile;
            return projectFile;
        }
        catch (IOException ex) {
            throw new MPXJException("Failed to parse file", ex);
        }
        finally {
            this.m_projectFile = null;
            this.m_eventManager = null;
            this.m_tables = null;
        }
    }

    @Override
    public List<ProjectFile> readAll(InputStream inputStream) throws MPXJException {
        return Arrays.asList(this.read(inputStream));
    }

    private void readFile(InputStream is) throws IOException {
        StreamHelper.skip(is, 64L);
        int index = 64;
        ArrayList<Integer> offsetList = new ArrayList<Integer>();
        ArrayList<String> nameList = new ArrayList<String>();
        while (true) {
            byte[] table = new byte[32];
            is.read(table);
            index += 32;
            int offset = PEPUtility.getInt(table, 0);
            offsetList.add(offset);
            if (offset == 0) break;
            nameList.add(PEPUtility.getString(table, 5).toUpperCase());
        }
        StreamHelper.skip(is, (Integer)offsetList.get(0) - index);
        for (int offsetIndex = 1; offsetIndex < offsetList.size() - 1; ++offsetIndex) {
            Table table;
            String name = (String)nameList.get(offsetIndex - 1);
            Class<Table> tableClass = TABLE_CLASSES.getOrDefault(name, Table.class);
            try {
                table = (Table)tableClass.newInstance();
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
            this.m_tables.put(name, table);
            table.read(is);
        }
    }

    private void readCalendars() {
        for (MapRow row : this.getTable("NCALTAB")) {
            ProjectCalendar calendar = this.m_projectFile.addCalendar();
            calendar.setUniqueID(row.getInteger("UNIQUE_ID"));
            calendar.setName(row.getString("NAME"));
            calendar.setWorkingDay(Day.SUNDAY, row.getBoolean("SUNDAY"));
            calendar.setWorkingDay(Day.MONDAY, row.getBoolean("MONDAY"));
            calendar.setWorkingDay(Day.TUESDAY, row.getBoolean("TUESDAY"));
            calendar.setWorkingDay(Day.WEDNESDAY, row.getBoolean("WEDNESDAY"));
            calendar.setWorkingDay(Day.THURSDAY, row.getBoolean("THURSDAY"));
            calendar.setWorkingDay(Day.FRIDAY, row.getBoolean("FRIDAY"));
            calendar.setWorkingDay(Day.SATURDAY, row.getBoolean("SATURDAY"));
            for (Day day : Day.values()) {
                if (!calendar.isWorkingDay(day)) continue;
                calendar.addDefaultCalendarHours(day);
            }
        }
        Table exceptionsTable = this.getTable("CALXTAB");
        for (MapRow row : this.getTable("NCALTAB")) {
            ProjectCalendar child = this.m_projectFile.getCalendarByUniqueID(row.getInteger("UNIQUE_ID"));
            ProjectCalendar parent = this.m_projectFile.getCalendarByUniqueID(row.getInteger("BASE_CALENDAR_ID"));
            if (child != null && parent != null) {
                child.setParent(parent);
            }
            this.addCalendarExceptions(exceptionsTable, child, row.getInteger("FIRST_CALENDAR_EXCEPTION_ID"));
            this.m_eventManager.fireCalendarReadEvent(child);
        }
    }

    private void addCalendarExceptions(Table table, ProjectCalendar calendar, Integer exceptionID) {
        MapRow row;
        Integer currentExceptionID = exceptionID;
        while ((row = table.find(currentExceptionID)) != null) {
            Date date = row.getDate("DATE");
            ProjectCalendarException exception = calendar.addCalendarException(date, date);
            if (row.getBoolean("WORKING")) {
                exception.addRange(ProjectCalendarWeek.DEFAULT_WORKING_MORNING);
                exception.addRange(ProjectCalendarWeek.DEFAULT_WORKING_AFTERNOON);
            }
            currentExceptionID = row.getInteger("NEXT_CALENDAR_EXCEPTION_ID");
        }
    }

    private void readResources() {
        for (MapRow row : this.getTable("RTAB")) {
            Resource resource = this.m_projectFile.addResource();
            this.setFields(RESOURCE_FIELDS, row, resource);
            resource.setNotesObject(new Notes(resource.getNotes()));
            this.m_eventManager.fireResourceReadEvent(resource);
        }
    }

    private void readTasks() {
        Integer rootID = 1;
        this.readWBS(this.m_projectFile, rootID);
        this.readTasks(rootID);
        this.m_projectFile.getTasks().synchronizeTaskIDToHierarchy();
    }

    private void readWBS(ChildTaskContainer parent, Integer id) {
        Integer currentID = id;
        Table table = this.getTable("WBSTAB");
        while (currentID != 0) {
            MapRow row = table.find(currentID);
            Integer taskID = row.getInteger("TASK_ID");
            Task task = this.readTask(parent, taskID);
            Integer childID = row.getInteger("CHILD_ID");
            if (childID != 0) {
                this.readWBS(task, childID);
            }
            currentID = row.getInteger("NEXT_ID");
        }
    }

    private void readTasks(Integer id) {
        Integer currentID = id;
        Table table = this.getTable("WBSTAB");
        while (currentID != 0) {
            MapRow row = table.find(currentID);
            Task task = this.m_projectFile.getTaskByUniqueID(row.getInteger("TASK_ID"));
            this.readLeafTasks(task, row.getInteger("FIRST_CHILD_TASK_ID"));
            Integer childID = row.getInteger("CHILD_ID");
            if (childID != 0) {
                this.readTasks(childID);
            }
            currentID = row.getInteger("NEXT_ID");
        }
    }

    private void readLeafTasks(Task parent, Integer id) {
        Integer currentID = id;
        Table table = this.getTable("A1TAB");
        while (currentID != 0) {
            if (this.m_projectFile.getTaskByUniqueID(currentID) == null) {
                this.readTask(parent, currentID);
            }
            currentID = table.find(currentID).getInteger("NEXT_TASK_ID");
        }
    }

    private Task readTask(ChildTaskContainer parent, Integer id) {
        Table a0 = this.getTable("A0TAB");
        Table a1 = this.getTable("A1TAB");
        Table a2 = this.getTable("A2TAB");
        Table a3 = this.getTable("A3TAB");
        Table a4 = this.getTable("A4TAB");
        Task task = parent.addTask();
        MapRow a1Row = a1.find(id);
        MapRow a2Row = a2.find(id);
        this.setFields(A0TAB_FIELDS, a0.find(id), task);
        this.setFields(A1TAB_FIELDS, a1Row, task);
        this.setFields(A2TAB_FIELDS, a2Row, task);
        this.setFields(A3TAB_FIELDS, a3.find(id), task);
        this.setFields(A5TAB_FIELDS, a4.find(id), task);
        task.setStart(task.getEarlyStart());
        task.setFinish(task.getEarlyFinish());
        if (task.getName() == null) {
            task.setName(task.getText(1));
        }
        this.m_eventManager.fireTaskReadEvent(task);
        return task;
    }

    private void readRelationships() {
        for (MapRow row : this.getTable("CONTAB")) {
            Task task1 = this.m_projectFile.getTaskByUniqueID(row.getInteger("TASK_ID_1"));
            Task task2 = this.m_projectFile.getTaskByUniqueID(row.getInteger("TASK_ID_2"));
            if (task1 == null || task2 == null) continue;
            RelationType type = row.getRelationType("TYPE");
            Duration lag = row.getDuration("LAG");
            Relation relation = task2.addPredecessor(task1, type, lag);
            this.m_eventManager.fireRelationReadEvent(relation);
        }
    }

    private void readResourceAssignments() {
        for (MapRow row : this.getTable("USGTAB")) {
            Task task = this.m_projectFile.getTaskByUniqueID(row.getInteger("TASK_ID"));
            Resource resource = this.m_projectFile.getResourceByUniqueID(row.getInteger("RESOURCE_ID"));
            if (task == null || resource == null) continue;
            ResourceAssignment assignment = task.addResourceAssignment(resource);
            this.m_eventManager.fireAssignmentReadEvent(assignment);
        }
    }

    private Table getTable(String name) {
        return this.m_tables.getOrDefault(name, EMPTY_TABLE);
    }

    private void applyAliases() {
        CustomFieldContainer fields = this.m_projectFile.getCustomFields();
        for (Map.Entry<FieldType, String> entry : ALIASES.entrySet()) {
            fields.getCustomField(entry.getKey()).setAlias(entry.getValue()).setUserDefined(false);
        }
    }

    private void setFields(Map<String, FieldType> map, MapRow row, FieldContainer container) {
        if (row != null) {
            for (Map.Entry<String, FieldType> entry : map.entrySet()) {
                container.set(entry.getValue(), row.getObject(entry.getKey()));
            }
        }
    }

    private static void defineField(Map<String, FieldType> container, String name, FieldType type) {
        TurboProjectReader.defineField(container, name, type, null);
    }

    private static void defineField(Map<String, FieldType> container, String name, FieldType type, String alias) {
        container.put(name, type);
        if (alias != null) {
            ALIASES.put(type, alias);
        }
    }

    static {
        TABLE_CLASSES.put("RTAB", TableRTAB.class);
        TABLE_CLASSES.put("A0TAB", TableA0TAB.class);
        TABLE_CLASSES.put("A1TAB", TableA1TAB.class);
        TABLE_CLASSES.put("A2TAB", TableA2TAB.class);
        TABLE_CLASSES.put("A3TAB", TableA3TAB.class);
        TABLE_CLASSES.put("A5TAB", TableA5TAB.class);
        TABLE_CLASSES.put("CONTAB", TableCONTAB.class);
        TABLE_CLASSES.put("USGTAB", TableUSGTAB.class);
        TABLE_CLASSES.put("NCALTAB", TableNCALTAB.class);
        TABLE_CLASSES.put("CALXTAB", TableCALXTAB.class);
        TABLE_CLASSES.put("WBSTAB", TableWBSTAB.class);
        ALIASES = new HashMap<FieldType, String>();
        RESOURCE_FIELDS = new HashMap<String, FieldType>();
        A0TAB_FIELDS = new HashMap<String, FieldType>();
        A1TAB_FIELDS = new HashMap<String, FieldType>();
        A2TAB_FIELDS = new HashMap<String, FieldType>();
        A3TAB_FIELDS = new HashMap<String, FieldType>();
        A5TAB_FIELDS = new HashMap<String, FieldType>();
        TurboProjectReader.defineField(RESOURCE_FIELDS, "ID", ResourceField.ID);
        TurboProjectReader.defineField(RESOURCE_FIELDS, "UNIQUE_ID", ResourceField.UNIQUE_ID);
        TurboProjectReader.defineField(RESOURCE_FIELDS, "NAME", ResourceField.NAME);
        TurboProjectReader.defineField(RESOURCE_FIELDS, "GROUP", ResourceField.GROUP);
        TurboProjectReader.defineField(RESOURCE_FIELDS, "DESCRIPTION", ResourceField.NOTES);
        TurboProjectReader.defineField(RESOURCE_FIELDS, "PARENT_ID", ResourceField.PARENT_ID);
        TurboProjectReader.defineField(RESOURCE_FIELDS, "RATE", ResourceField.NUMBER1, "Rate");
        TurboProjectReader.defineField(RESOURCE_FIELDS, "POOL", ResourceField.NUMBER2, "Pool");
        TurboProjectReader.defineField(RESOURCE_FIELDS, "PER_DAY", ResourceField.NUMBER3, "Per Day");
        TurboProjectReader.defineField(RESOURCE_FIELDS, "PRIORITY", ResourceField.NUMBER4, "Priority");
        TurboProjectReader.defineField(RESOURCE_FIELDS, "PERIOD_DUR", ResourceField.NUMBER5, "Period Dur");
        TurboProjectReader.defineField(RESOURCE_FIELDS, "EXPENSES_ONLY", ResourceField.FLAG1, "Expenses Only");
        TurboProjectReader.defineField(RESOURCE_FIELDS, "MODIFY_ON_INTEGRATE", ResourceField.FLAG2, "Modify On Integrate");
        TurboProjectReader.defineField(RESOURCE_FIELDS, "UNIT", ResourceField.TEXT1, "Unit");
        TurboProjectReader.defineField(A0TAB_FIELDS, "UNIQUE_ID", TaskField.UNIQUE_ID);
        TurboProjectReader.defineField(A1TAB_FIELDS, "ORDER", TaskField.ID);
        TurboProjectReader.defineField(A1TAB_FIELDS, "PLANNED_START", TaskField.BASELINE_START);
        TurboProjectReader.defineField(A1TAB_FIELDS, "PLANNED_FINISH", TaskField.BASELINE_FINISH);
        TurboProjectReader.defineField(A2TAB_FIELDS, "DESCRIPTION", TaskField.TEXT1, "Description");
        TurboProjectReader.defineField(A3TAB_FIELDS, "EARLY_START", TaskField.EARLY_START);
        TurboProjectReader.defineField(A3TAB_FIELDS, "LATE_START", TaskField.LATE_START);
        TurboProjectReader.defineField(A3TAB_FIELDS, "EARLY_FINISH", TaskField.EARLY_FINISH);
        TurboProjectReader.defineField(A3TAB_FIELDS, "LATE_FINISH", TaskField.LATE_FINISH);
        TurboProjectReader.defineField(A5TAB_FIELDS, "ORIGINAL_DURATION", TaskField.DURATION);
        TurboProjectReader.defineField(A5TAB_FIELDS, "REMAINING_DURATION", TaskField.REMAINING_DURATION);
        TurboProjectReader.defineField(A5TAB_FIELDS, "PERCENT_COMPLETE", TaskField.PERCENT_COMPLETE);
        TurboProjectReader.defineField(A5TAB_FIELDS, "TARGET_START", TaskField.DATE1, "Target Start");
        TurboProjectReader.defineField(A5TAB_FIELDS, "TARGET_FINISH", TaskField.DATE2, "Target Finish");
        TurboProjectReader.defineField(A5TAB_FIELDS, "ACTUAL_START", TaskField.ACTUAL_START);
        TurboProjectReader.defineField(A5TAB_FIELDS, "ACTUAL_FINISH", TaskField.ACTUAL_FINISH);
    }
}

