/*
 * Decompiled with CFR 0.152.
 */
package org.lbzip2;

import java.util.Arrays;
import org.lbzip2.BWT;
import org.lbzip2.SubstringSort;
import org.lbzip2.TandemRepeatSort;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DivBWT
implements BWT {
    private final Logger logger = LoggerFactory.getLogger(DivBWT.class);
    private final SubstringSort SS = new SubstringSort();
    private final TandemRepeatSort TR = new TandemRepeatSort();
    private static final boolean DEBUG = true;
    private static final int ALPHABET_SIZE = 256;
    private static final int FIRST_CHAR = -128;
    private static final int LAST_CHAR = 127;
    private static final int BUCKET_A_BIAS = 65664;
    private static final int BUCKET_B_BIAS = 32896;

    DivBWT() {
    }

    private final int BUCKET_A(int[] bucket, int c0) {
        return bucket[c0 + 65664];
    }

    private final void BUCKET_A_SET(int[] bucket, int c0, int value) {
        bucket[c0 + 65664] = value;
    }

    private final void BUCKET_A_INC(int[] bucket, int c0) {
        int n = c0 + 65664;
        bucket[n] = bucket[n] + 1;
    }

    private final int BUCKET_B(int[] bucket, int c0, int c1) {
        return bucket[(c1 << 8) + c0 + 32896];
    }

    private final void BUCKET_B_SET(int[] bucket, int c0, int c1, int value) {
        bucket[(c1 << 8) + c0 + 32896] = value;
    }

    private final void BUCKET_B_INC(int[] bucket, int c0, int c1) {
        int n = (c1 << 8) + c0 + 32896;
        bucket[n] = bucket[n] + 1;
    }

    private final int BUCKET_BSTAR(int[] bucket, int c0, int c1) {
        return bucket[(c0 << 8) + c1 + 32896];
    }

    private final void BUCKET_BSTAR_SET(int[] bucket, int c0, int c1, int value) {
        bucket[(c0 << 8) + c1 + 32896] = value;
    }

    private final void BUCKET_BSTAR_INC(int[] bucket, int c0, int c1) {
        int n = (c0 << 8) + c1 + 32896;
        bucket[n] = bucket[n] + 1;
    }

    private final int BUCKET_BSTAR_DEC(int[] bucket, int c0, int c1) {
        int n = (c0 << 8) + c1 + 32896;
        int n2 = bucket[n] - 1;
        bucket[n] = n2;
        return n2;
    }

    private final int sort_typeBstar(byte[] T, int[] SA, int[] bucket, int n) {
        int t;
        int i;
        this.logger.trace("  Bucket sorting...");
        Arrays.fill(bucket, 0);
        boolean flag = true;
        for (i = 1; i < n; ++i) {
            if (T[i - 1] == T[i]) continue;
            if (T[i - 1] <= T[i]) break;
            flag = false;
            break;
        }
        i = n - 1;
        int m = n;
        int c0 = T[n - 1];
        int c1 = T[0];
        if (c0 < c1 || c0 == c1 && flag) {
            if (!flag) {
                this.BUCKET_BSTAR_INC(bucket, c0, c1);
                SA[--m] = i;
            } else {
                this.BUCKET_B_INC(bucket, c0, c1);
            }
            --i;
            c1 = c0;
            while (0 <= i && (c0 = T[i]) <= c1) {
                this.BUCKET_B_INC(bucket, c0, c1);
                --i;
                c1 = c0;
            }
        }
        while (0 <= i) {
            do {
                c1 = c0;
                this.BUCKET_A_INC(bucket, c1);
            } while (0 <= --i && (c0 = T[i]) >= c1);
            if (0 > i) continue;
            this.BUCKET_BSTAR_INC(bucket, c0, c1);
            SA[--m] = i--;
            c1 = c0;
            while (0 <= i && (c0 = T[i]) <= c1) {
                this.BUCKET_B_INC(bucket, c0, c1);
                --i;
                c1 = c0;
            }
        }
        m = n - m;
        assert (m <= n / 2);
        if (this.logger.isTraceEnabled()) {
            int num_a = 0;
            for (int c = -128; c <= 127; ++c) {
                num_a += this.BUCKET_A(bucket, c);
            }
            this.logger.trace("    Number of type A  suffixes: {} ({} %)", (Object)num_a, (Object)String.format("%.2f", 100.0 * (double)num_a / (double)n));
            this.logger.trace("    Number of type B  suffixes: {} ({} %)", (Object)(n - num_a), (Object)String.format("%.2f", 100.0 * (double)(n - num_a) / (double)n));
            this.logger.trace("    Number of type B* suffixes: {} ({} %, {} % of type B suffixes)", new Object[]{m, String.format("%.2f", 100.0 * (double)m / (double)n), String.format("%.2f", 100.0 * (double)m / (double)(n - num_a))});
        }
        if (m == 0) {
            return 0;
        }
        this.logger.trace("  Sorting B* suffixes...");
        i = 0;
        int j = 0;
        for (c0 = -128; c0 <= 127; ++c0) {
            t = i + this.BUCKET_A(bucket, c0);
            this.BUCKET_A_SET(bucket, c0, i + j);
            i = t + this.BUCKET_B(bucket, c0, c0);
            for (c1 = c0 + 1; c1 <= 127; ++c1) {
                this.BUCKET_BSTAR_SET(bucket, c0, c1, j += this.BUCKET_BSTAR(bucket, c0, c1));
                i += this.BUCKET_B(bucket, c0, c1);
            }
        }
        int xpa = n - m;
        i = m - 2;
        while (0 <= i) {
            t = SA[xpa + i];
            c0 = T[t];
            c1 = T[t + 1];
            SA[this.BUCKET_BSTAR_DEC((int[])bucket, (int)c0, (int)c1)] = i--;
        }
        t = SA[xpa + m - 1];
        c0 = T[t];
        c1 = T[t + 1];
        SA[this.BUCKET_BSTAR_DEC((int[])bucket, (int)c0, (int)c1)] = m - 1;
        int buf = m;
        int bufsize = n - 2 * m;
        c0 = 126;
        j = m;
        while (0 < j) {
            for (c1 = 127; c0 < c1; --c1) {
                i = this.BUCKET_BSTAR(bucket, c0, c1);
                if (1 < j - i) {
                    this.SS.sssort(T, SA, xpa, i, j, buf, bufsize, 2, n, SA[i] == m - 1);
                }
                j = i;
            }
            --c0;
        }
        for (i = m - 1; 0 <= i; --i) {
            if (0 <= SA[i]) {
                j = i;
                do {
                    SA[SA[i] + m] = i;
                } while (0 <= --i && 0 <= SA[i]);
                SA[i + 1] = i - j;
                if (i <= 0) break;
            }
            j = i;
            do {
                SA[i] = ~SA[i];
                SA[SA[i] + m] = j;
            } while (SA[--i] < 0);
            SA[SA[i] + m] = j;
        }
        this.logger.trace("  Constructing ISA...");
        this.TR.trsort(SA, m);
        i = n - 1;
        j = m;
        c0 = T[n - 1];
        c1 = T[0];
        if (c0 < c1 || c0 == c1 && flag) {
            t = i--;
            c1 = c0;
            while (0 <= i && (c0 = T[i]) <= c1) {
                --i;
                c1 = c0;
            }
            if (!flag) {
                int n2 = SA[SA[--j + m]] = 1 < t - i ? t : ~t;
            }
        }
        while (0 <= i) {
            --i;
            c1 = c0;
            while (0 <= i && (c0 = T[i]) >= c1) {
                --i;
                c1 = c0;
            }
            if (0 > i) continue;
            t = i--;
            c1 = c0;
            while (0 <= i && (c0 = T[i]) <= c1) {
                --i;
                c1 = c0;
            }
            SA[SA[--j + m]] = 1 < t - i ? t : ~t;
        }
        if (SA[SA[m]] == -1 && T[n - 1] <= T[0]) {
            SA[SA[m]] = 0;
        }
        for (i = m; i < n; ++i) {
            SA[i] = ~n;
        }
        this.BUCKET_B_SET(bucket, 127, 127, n);
        int k = m - 1;
        for (c0 = 126; -128 <= c0; --c0) {
            i = this.BUCKET_A(bucket, c0 + 1) - 1;
            for (c1 = 127; c0 < c1; --c1) {
                t = i - this.BUCKET_B(bucket, c0, c1);
                this.BUCKET_B_SET(bucket, c0, c1, i);
                i = t;
                j = this.BUCKET_BSTAR(bucket, c0, c1);
                while (j <= k) {
                    SA[i] = SA[k];
                    --i;
                    --k;
                }
            }
            this.BUCKET_BSTAR_SET(bucket, c0, c0 + 1, i - this.BUCKET_B(bucket, c0, c0) + 1);
            this.BUCKET_B_SET(bucket, c0, c0, i);
        }
        return m;
    }

    private final int construct_BWT(byte[] T, int[] SA, int[] bucket, int n) {
        byte c0;
        int t;
        int s;
        int j;
        int k;
        int i;
        byte c1;
        int orig = -10;
        this.logger.trace("  Constructing BWT...");
        for (c1 = 126; -128 <= c1; --c1) {
            i = this.BUCKET_BSTAR(bucket, c1, c1 + 1);
            k = Integer.MIN_VALUE;
            byte by = Integer.MIN_VALUE;
            for (j = this.BUCKET_A(bucket, c1 + 1) - 1; i <= j; --j) {
                s = SA[j];
                if (0 <= s) {
                    assert (s < n);
                    assert (T[s] == c1);
                    assert (T[s] <= T[s + 1 < n ? s + 1 : 0]);
                    if (s != 0) {
                        t = s - 1;
                    } else {
                        t = n - 1;
                        orig = j;
                    }
                    assert (T[t] <= T[s]);
                    c0 = T[t];
                    SA[j] = ~(c0 + 128);
                    if (c0 != by) {
                        if (-128 <= by) {
                            this.BUCKET_B_SET(bucket, by, c1, k);
                        }
                        by = c0;
                        k = this.BUCKET_B(bucket, by, c1);
                    }
                    assert (k < j);
                    SA[k--] = (t != 0 ? T[t - 1] : T[n - 1]) > by ? ~t : t;
                    continue;
                }
                SA[j] = ~s;
                assert (~s < n);
            }
        }
        int n2 = -128;
        k = this.BUCKET_A(bucket, -128);
        j = n;
        for (i = 0; i < j; ++i) {
            s = SA[i];
            if (0 <= s) {
                byte by;
                if (s != 0) {
                    t = s - 1;
                } else {
                    t = n - 1;
                    orig = i;
                }
                assert (T[t] >= T[s]);
                c0 = T[t];
                SA[i] = c0 + 128;
                if (c0 != by) {
                    this.BUCKET_A_SET(bucket, by, k);
                    by = c0;
                    k = this.BUCKET_A(bucket, by);
                }
                if (t != 0) {
                    c1 = T[t - 1];
                } else {
                    c1 = T[n - 1];
                    orig = k;
                }
                assert (i <= k);
                SA[k++] = c1 < by ? ~(c1 + 128) : t;
                continue;
            }
            SA[i] = ~s;
        }
        assert (orig != -10);
        assert (0 <= orig && orig < n);
        return orig;
    }

    public final int transform(byte[] T, int[] SA, int n) {
        int pidx;
        this.logger.trace("Running DivBWT (block size is {})", (Object)n);
        assert (n > 0);
        if (n == 1) {
            SA[0] = T[0] + 128;
            return 0;
        }
        T[n] = T[0];
        int[] bucket = new int[65792];
        int m = this.sort_typeBstar(T, SA, bucket, n);
        if (0 < m) {
            pidx = this.construct_BWT(T, SA, bucket, n);
        } else {
            pidx = 0;
            for (int i = 0; i < n; ++i) {
                SA[i] = T[0] + 128;
            }
        }
        this.logger.trace("DivBWT done (primary index is {})", (Object)pidx);
        return pidx;
    }
}

