/*
 * Decompiled with CFR 0.152.
 */
package org.lbzip2;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.lbzip2.LBzip2InputStream;
import org.lbzip2.LBzip2OutputStream;
import org.lbzip2.MBC;

public class Main {
    private static boolean decompress;

    private static void copyStream(InputStream is, OutputStream os) throws IOException {
        int r;
        byte[] buf = new byte[4096];
        while ((r = is.read(buf)) != -1) {
            os.write(buf, 0, r);
        }
    }

    private static void compress(InputStream is, OutputStream os) throws IOException {
        LBzip2OutputStream zos = new LBzip2OutputStream(os, 900000);
        Main.copyStream(is, zos);
        zos.finish();
    }

    private static void decompress(InputStream is, OutputStream os) throws IOException {
        if (System.getProperty("org.lbzip2.mbc") != null) {
            MBC mbc = new MBC(is, os);
            mbc.expand();
        } else {
            LBzip2InputStream zis = new LBzip2InputStream(is);
            Main.copyStream(zis, os);
        }
    }

    private static void processStream(InputStream is, OutputStream os) throws IOException {
        if (decompress) {
            Main.decompress(is, os);
        } else {
            Main.compress(is, os);
        }
    }

    public static void main(String[] args) {
        try {
            decompress = args.length > 0 && args[0].equals("-d");
            Main.processStream(System.in, System.out);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

