/*
 * Decompiled with CFR 0.152.
 */
package org.lbzip2;

import org.lbzip2.BWT;
import org.lbzip2.Unsigned;

class RadixSortBWT
implements BWT {
    RadixSortBWT() {
    }

    public int transform(byte[] B, int[] P, int n) {
        int j;
        int[] U = new int[256];
        int[] C = new int[256];
        int[] R = new int[n];
        if ((n & 1) != 0) {
            int[] T = P;
            P = R;
            R = T;
        }
        for (int i = 0; i < n; ++i) {
            int n2 = B[i] + 128;
            C[n2] = C[n2] + 1;
            P[i] = i;
        }
        int cum = 0;
        for (int i = 0; i < 256; ++i) {
            C[i] = (cum += C[i]) - C[i];
        }
        assert (cum == n);
        for (int d = 1; d <= n; ++d) {
            System.arraycopy(C, 0, U, 0, 256);
            for (int i = 0; i < n; ++i) {
                j = P[i];
                int t = Unsigned.umin(j - d, j - d + n);
                int n3 = B[t] + 128;
                int n4 = U[n3];
                U[n3] = n4 + 1;
                R[n4] = j;
            }
            int[] T = P;
            P = R;
            R = T;
        }
        int idx = n;
        for (int i = 0; i < n; ++i) {
            j = P[i];
            if (j == 0) {
                assert (idx == n);
                idx = i;
                j = n;
            }
            P[i] = B[j - 1] + 128;
        }
        assert (idx < n);
        return idx;
    }
}

