/*
 * Decompiled with CFR 0.152.
 */
package org.lbzip2;

import org.lbzip2.ByteArrayDataSource;
import org.lbzip2.CompoundDataSource;
import org.lbzip2.CompressedBlock;

public class StreamComposer
extends CompoundDataSource {
    private int combinedCrc;
    private final int maxBlockSize;

    public StreamComposer() {
        this(900000);
    }

    public StreamComposer(int maxBlockSize) {
        this.maxBlockSize = maxBlockSize;
        byte[] buffer = new byte[]{66, 90, 104, (byte)(48 + (maxBlockSize + 100000 - 1) / 100000)};
        this.addSource(new ByteArrayDataSource(buffer));
    }

    public void addBlock(CompressedBlock block) {
        if (block.blockSize > this.maxBlockSize) {
            throw new IllegalArgumentException("Block too large to be added to this stream");
        }
        this.combinedCrc = ~(this.combinedCrc << 1 ^ this.combinedCrc >>> 31 ^ block.crc);
        this.addSource(new ByteArrayDataSource(block.buffer));
    }

    public void finish() {
        byte[] buffer = new byte[]{23, 114, 69, 56, 80, -112, (byte)(this.combinedCrc >> 24), (byte)(this.combinedCrc >> 16), (byte)(this.combinedCrc >> 8), (byte)this.combinedCrc};
        this.addSource(new ByteArrayDataSource(buffer));
    }
}

