/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.application.document;

import com.macrofocus.application.ApplicationModel;
import com.macrofocus.application.document.Document;
import com.macrofocus.application.document.DocumentBasedApplicationState;
import com.macrofocus.application.document.DocumentOpener;
import com.macrofocus.application.document.OpenDocumentException;
import com.macrofocus.application.document.View;
import com.macrofocus.application.properties.DocumentBasedApplicationProperties;
import com.macrofocus.application.window.CPWindow;
import com.macrofocus.common.command.Command;
import com.macrofocus.common.command.Future;
import com.macrofocus.common.command.FutureCommand;
import com.macrofocus.common.command.UICommand;
import com.macrofocus.common.file.FileType;

public interface DocumentBasedApplication<Window, Component, F, D extends Document, V extends View<Component, D>> {
    default public Mode getMode() {
        return Mode.Normal;
    }

    public DocumentBasedApplicationState<Window, Component, D, V> getApplicationState();

    public ApplicationModel getApplicationModel();

    public FileType[] getOpenFileTypes();

    default public FileType[] getSaveFileTypes() {
        return null;
    }

    default public String getName() {
        return this.getApplicationModel().getName();
    }

    public void init() throws Exception;

    public void stop() throws Exception;

    public D newDocument();

    public D openLocalDocument(F var1, String var2, Window var3) throws OpenDocumentException;

    public D openRemoteDocument(String var1, String var2, String var3) throws OpenDocumentException;

    public UICommand getReloadCommand(V var1);

    public void saveView(V var1);

    public void saveView(V var1, F var2, FileType var3);

    public <C extends Command, R> void runAsyncBackground(C var1, Callback<C, R> var2);

    public <C extends FutureCommand<R>, R> Future<R> runAsyncFuture(FutureCommand<R> var1);

    public void closeView(V var1);

    public void showDocument(CPWindow<Window, Component> var1, D var2);

    public void openAndShowDocument(CPWindow<Window, Component> var1, DocumentOpener<D, Window, Component> var2, F var3);

    public DocumentBasedApplicationProperties createLocalProperties();

    public V createView(Window var1, D var2);

    public CPWindow<Window, Component> createWindow();

    public void setup(CPWindow<Window, Component> var1, V var2);

    public void runAsyncUIThread(Command var1);

    public void runAsyncBackground(Command var1);

    public static interface Callback<T, R> {
        public R execute(T var1);
    }

    public static enum Mode {
        Normal,
        Expert;

    }
}

