/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.application.properties;

import com.macrofocus.application.properties.WrappedMutableProperty;
import com.macrofocus.common.properties.MutableProperties;
import com.macrofocus.common.properties.MutableProperty;
import com.macrofocus.common.properties.PropertiesListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class WrappedMutableProperties<K>
implements MutableProperties<K> {
    private MutableProperties<K> properties;
    private Map<MutableProperty, WrappedMutableProperty> propertyMap = new HashMap<MutableProperty, WrappedMutableProperty>();
    private Set<PropertiesListener<K>> listeners;

    public WrappedMutableProperties(MutableProperties<K> properties) {
        this.properties = properties;
    }

    public MutableProperty getProperty(K name) {
        return this.getWrappedProperty(this.properties.getProperty(name));
    }

    public Object getValue(K name) {
        return this.properties.getValue(name);
    }

    public void addPropertiesListener(PropertiesListener listener) {
        this.getListeners().add(listener);
        this.properties.addPropertiesListener(listener);
    }

    public void addWeakPropertiesListener(PropertiesListener listener) {
        this.getListeners().remove(listener);
        this.properties.addWeakPropertiesListener(listener);
    }

    public void removePropertiesListener(PropertiesListener listener) {
        this.getListeners().remove(listener);
        this.properties.removePropertiesListener(listener);
    }

    public Iterator<K> iterator() {
        return this.properties.iterator();
    }

    public <T> MutableProperty<T> createProperty(K name, T value) {
        return this.getWrappedProperty(this.properties.createProperty(name, value));
    }

    public <T> MutableProperty<T> addProperty(K name, MutableProperty<T> property) {
        return this.getWrappedProperty(this.properties.addProperty(name, property));
    }

    public <T> MutableProperty<T> replaceProperty(K name, MutableProperty<T> property) {
        this.propertyMap.remove(this.properties.getProperty(name));
        return this.getWrappedProperty(this.properties.replaceProperty(name, property));
    }

    public void setValue(K name, Object value) {
        this.properties.setValue(name, value);
    }

    protected <T> MutableProperty getWrappedProperty(MutableProperty<T> property) {
        if (this.propertyMap.containsKey(property)) {
            return this.propertyMap.get(property);
        }
        WrappedMutableProperty<T> wrappedProperty = new WrappedMutableProperty<T>(property);
        this.propertyMap.put(property, wrappedProperty);
        return wrappedProperty;
    }

    private Set<PropertiesListener<K>> getListeners() {
        if (this.listeners == null) {
            this.listeners = new HashSet<PropertiesListener<K>>();
        }
        return this.listeners;
    }

    public void dispose() {
        for (WrappedMutableProperty wrappedMutableProperty : this.propertyMap.values()) {
            wrappedMutableProperty.dispose();
        }
        if (this.listeners != null) {
            for (PropertiesListener propertiesListener : this.listeners) {
                this.properties.removePropertiesListener(propertiesListener);
            }
            this.listeners = null;
        }
        this.properties = null;
    }
}

