/*
 * Decompiled with CFR 0.152.
 */
package org.lbzip2;

import java.io.IOException;
import java.io.InputStream;
import org.lbzip2.BitStream;
import org.lbzip2.Decoder;
import org.lbzip2.Header;
import org.lbzip2.Parser;
import org.lbzip2.Retriever;
import org.lbzip2.Status;
import org.lbzip2.StreamFormatException;

public class LBzip2InputStream
extends InputStream {
    private final InputStream is;
    private static final int BUFSIZ = 65536;
    private final byte[] buf1 = new byte[1];
    private final byte[] in_buf = new byte[65536];
    private boolean emit;
    private final BitStream bitStream = new BitStream();
    private Parser parser;
    private final Retriever retriever = new Retriever();
    private final Header hd = new Header();
    private final Decoder decoder = new Decoder();
    private boolean done;

    public LBzip2InputStream(InputStream is) {
        this.is = is;
        this.bitStream.ptr = this.in_buf;
    }

    public int read() throws IOException {
        if (this.read(this.buf1, 0, 1) < 0) {
            return -1;
        }
        return this.buf1[0] & 0xFF;
    }

    public int read(byte[] buf, int off, int len) throws IOException {
        if (this.done) {
            return -1;
        }
        int origLen = len;
        while (len > 0) {
            Status s;
            if (this.emit) {
                int[] buf_sz = new int[]{len};
                if (this.decoder.emit(buf, off, buf_sz) == Status.OK) {
                    this.emit = false;
                    if (this.hd.crc != this.decoder.crc) {
                        throw new StreamFormatException("Invalid block CRC");
                    }
                }
                len = buf_sz[0];
                off += origLen - len;
                continue;
            }
            int[] garbage = new int[1];
            if (this.parser == null) {
                int bs100k;
                if (this.is.read() != 66 || this.is.read() != 90 || this.is.read() != 104 || (bs100k = (this.is.read() - 49 & 0xFF) + 1) > 9) {
                    throw new StreamFormatException("Not a bz2 file");
                }
                this.parser = new Parser(bs100k);
            }
            while ((s = this.parser.parse(this.hd, this.bitStream, garbage)) == Status.MORE) {
                this.readMoreInput();
            }
            if (s == Status.FINISH) {
                this.finish();
                return origLen > len ? origLen - len : -1;
            }
            assert (s == Status.OK);
            this.retriever.setMbs(this.hd.bs100k * 100000);
            while ((s = this.retriever.retr(this.decoder, this.bitStream)) == Status.MORE) {
                this.readMoreInput();
            }
            assert (s == Status.OK);
            this.decoder.decode();
            this.emit = true;
        }
        return origLen;
    }

    private void readMoreInput() throws IOException {
        int r = this.is.read(this.in_buf);
        if (r < 0) {
            this.bitStream.eof = true;
        } else {
            this.bitStream.off = 0;
            this.bitStream.len = r;
        }
    }

    private void finish() {
        this.done = true;
    }

    public void close() throws IOException {
        this.finish();
    }
}

