/*
 * Decompiled with CFR 0.152.
 */
package org.lbzip2;

import java.io.IOException;
import java.util.Arrays;
import org.lbzip2.BitStream;
import org.lbzip2.Decoder;
import org.lbzip2.MtfDecoder;
import org.lbzip2.PrefixDecoder;
import org.lbzip2.Status;
import org.lbzip2.StreamFormatException;
import org.lbzip2.Unsigned;

class Retriever {
    private State m_state = State.S_INIT;
    private final PrefixDecoder[] tree = new PrefixDecoder[6];
    private PrefixDecoder pd;
    private int mbs;
    private int as;
    private int nt;
    private int ns;
    private final byte[] sel = new byte[Short.MAX_VALUE];
    private final MtfDecoder mtf = new MtfDecoder();
    private int m_i;
    private int m_g;
    private final int[] m_len = new int[259];
    private int m_t;
    private int m_r;
    private int m_h;
    private int m_c;
    private final int[] m_mtf = new int[6];
    private int m_need;

    public Retriever() {
        for (int t = 0; t < 6; ++t) {
            this.tree[t] = new PrefixDecoder();
        }
    }

    public void setMbs(int mbs) {
        if (mbs <= 0 || mbs > 900000) {
            throw new IllegalStateException();
        }
        this.mbs = mbs;
    }

    private short get_sym(BitStream bs) throws StreamFormatException, IOException {
        short s;
        short x = this.pd.start[bs.peek(10)];
        int k = x & 0x1F;
        if (k <= 10) {
            s = (short)(x >> 5);
        } else {
            while (Unsigned.uge(bs.buff, this.pd.base[k + 1])) {
                ++k;
            }
            s = this.pd.perm[this.pd.count[k] + (int)(bs.buff - this.pd.base[k] >>> 64 - k)];
        }
        bs.dump(k);
        return s;
    }

    /*
     * Unable to fully structure code
     */
    Status retr(Decoder ds, BitStream bs) throws StreamFormatException, IOException {
        off = bs.off;
        len = bs.len;
        buf = bs.ptr;
        while (bs.live < this.m_need && off < len) {
            bs.live += 8;
            bs.buff += ((long)buf[off++] & 255L) << 64 - bs.live;
        }
        if (bs.live < this.m_need) {
            bs.off = off;
            return Status.MORE;
        }
        switch (1.$SwitchMap$org$lbzip2$Retriever$State[this.m_state.ordinal()]) {
            default: {
                this.m_need = 57;
                while (bs.live < this.m_need && off < len) {
                    bs.live += 8;
                    bs.buff += ((long)buf[off++] & 255L) << 64 - bs.live;
                }
                if (bs.live < this.m_need) {
                    this.m_state = State.S_BWT_IDX;
                    bs.off = off;
                    return Status.MORE;
                }
            }
            case 1: {
                ds.rand = bs.take(1) != 0;
                ds.bwt_idx = bs.take(24);
                this.m_r = bs.take(16) << 16;
                this.as = 0;
                this.mtf.initialize();
                this.m_i = 0;
            }
            case 2: {
                while (this.m_i < 256) {
                    if (this.m_r < 0) {
                        s = bs.take(16) << 16;
                        for (j = 0; j < 16; ++j) {
                            if (s < 0) {
                                this.mtf.imtf_slide[7936 + this.as++] = (byte)(this.m_i + j);
                            }
                            s *= 2;
                        }
                    }
                    this.m_i += 16;
                    this.m_r *= 2;
                    this.m_need = 24;
                    while (bs.live < this.m_need && off < len) {
                        bs.live += 8;
                        bs.buff += ((long)buf[off++] & 255L) << 64 - bs.live;
                    }
                    if (bs.live >= this.m_need) continue;
                    this.m_state = State.S_BITMAP;
                    bs.off = off;
                    return Status.MORE;
                }
                if (this.as == 0) {
                    throw new StreamFormatException("empty source alphabet");
                }
                this.as += 2;
                this.nt = bs.take(3);
                if (this.nt < 2 || this.nt > 6) {
                    throw new StreamFormatException("bad number of trees");
                }
                this.ns = bs.take(15);
                if (this.ns == 0) {
                    throw new StreamFormatException("no coding groups");
                }
                this.m_g = 0;
            }
            case 3: {
                while (this.m_g < this.ns) {
                    this.sel[this.m_g] = 0;
                    while (this.sel[this.m_g] < this.nt && bs.take(1) != 0) {
                        v0 = this.m_g;
                        this.sel[v0] = (byte)(this.sel[v0] + 1);
                    }
                    if (this.sel[this.m_g] == this.nt) {
                        throw new StreamFormatException("invalid selector");
                    }
                    ++this.m_g;
                    this.m_need = 7;
                    while (bs.live < this.m_need && off < len) {
                        bs.live += 8;
                        bs.buff += ((long)buf[off++] & 255L) << 64 - bs.live;
                    }
                    if (bs.live >= this.m_need) continue;
                    this.m_state = State.S_SELECTOR_MTF;
                    bs.off = off;
                    return Status.MORE;
                }
                if (this.ns > 18001) {
                    this.ns = 18001;
                }
                this.m_t = 0;
                this.m_i = 0;
                this.m_len[0] = (byte)bs.take(5);
            }
            case 4: {
                do {
                    if (bs.take(1) == 0) ** GOTO lbl91
                    v1 = this.m_i;
                    this.m_len[v1] = this.m_len[v1] + (1 - 2 * bs.take(1));
                    if (this.m_len[this.m_i] < 1 || this.m_len[this.m_i] > 20) {
                        throw new StreamFormatException("invalid delta code");
                    }
                    ** GOTO lbl97
lbl91:
                    // 1 sources

                    this.m_len[this.m_i + 1] = this.m_len[this.m_i];
                    if (++this.m_i < this.as) ** GOTO lbl97
                    this.tree[this.m_t].make_tree(this.m_len, this.as);
                    if (++this.m_t >= this.nt) ** GOTO lbl106
                    this.m_i = 0;
                    this.m_len[0] = (byte)bs.take(5);
lbl97:
                    // 3 sources

                    this.m_need = 21;
                    while (bs.live < this.m_need && off < len) {
                        bs.live += 8;
                        bs.buff += ((long)buf[off++] & 255L) << 64 - bs.live;
                    }
                } while (bs.live >= this.m_need);
                this.m_state = State.S_DELTA_TAG;
                bs.off = off;
                return Status.MORE;
lbl106:
                // 1 sources

                this.m_g = 0;
                this.m_h = 0;
                this.m_r = 0;
                ds.block_size = 0;
                Arrays.fill(ds.ftab, 0);
                this.m_c = this.mtf.imtf_slide[this.mtf.imtf_row[0]] & 255;
                for (i = 0; i < 6; ++i) {
                    this.m_mtf[i] = i;
                }
                this.m_i = 0;
            }
            case 5: 
        }
        do {
            if (this.m_i == 0) {
                if (this.m_g++ >= this.ns) {
                    throw new StreamFormatException("unterminated block");
                }
                i = this.sel[this.m_g - 1];
                t = this.m_mtf[i];
                while (i-- > 0) {
                    this.m_mtf[i + 1] = this.m_mtf[i];
                }
                this.m_mtf[0] = t;
                this.pd = this.tree[t];
                if (this.pd.error != null) {
                    throw new StreamFormatException(this.pd.error);
                }
                this.m_i = 50;
            }
            if ((s = this.get_sym(bs)) >= 257) {
                this.m_r += 1 << this.m_h + s - 257;
                ++this.m_h;
                if (this.m_r < 0) {
                    throw new StreamFormatException("invalid zero run length");
                }
            } else {
                r = this.m_r;
                if (ds.block_size + r > this.mbs) {
                    throw new StreamFormatException("block overflow");
                }
                v2 = this.m_c;
                ds.ftab[v2] = ds.ftab[v2] + r;
                while (r-- != 0) {
                    ds.tt[ds.block_size++] = this.m_c;
                }
                if (s == 0) {
                    this.m_state = State.S_INIT;
                    bs.off = off;
                    return Status.OK;
                }
                this.m_c = this.mtf.mtf_one(s);
                this.m_h = 0;
                this.m_r = 1;
            }
            --this.m_i;
            this.m_need = 20;
            while (bs.live < this.m_need && off < len) {
                bs.live += 8;
                bs.buff += ((long)buf[off++] & 255L) << 64 - bs.live;
            }
        } while (bs.live >= this.m_need);
        this.m_state = State.S_PREFIX;
        bs.off = off;
        return Status.MORE;
    }

    static class 1 {
        static final /* synthetic */ int[] $SwitchMap$org$lbzip2$Retriever$State;

        static {
            $SwitchMap$org$lbzip2$Retriever$State = new int[State.values().length];
            try {
                1.$SwitchMap$org$lbzip2$Retriever$State[State.S_BWT_IDX.ordinal()] = 1;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$lbzip2$Retriever$State[State.S_BITMAP.ordinal()] = 2;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$lbzip2$Retriever$State[State.S_SELECTOR_MTF.ordinal()] = 3;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$lbzip2$Retriever$State[State.S_DELTA_TAG.ordinal()] = 4;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$lbzip2$Retriever$State[State.S_PREFIX.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum State {
        S_INIT,
        S_BWT_IDX,
        S_BITMAP,
        S_SELECTOR_MTF,
        S_DELTA_TAG,
        S_PREFIX;

    }
}

