/*
 * Decompiled with CFR 0.152.
 */
package org.lbzip2;

import org.lbzip2.Utils;

final class SubstringSort {
    private static final int SS_INSERTIONSORT_THRESHOLD = 8;
    private static final int SS_BLOCKSIZE = 1024;

    SubstringSort() {
    }

    private final int STACK_PUSH(int[] stack, int ssize, int a, int b, int c, int d) {
        stack[ssize] = a;
        stack[ssize + 1] = b;
        stack[ssize + 2] = c;
        stack[ssize + 3] = d;
        return ssize + 4;
    }

    private final int ss_compare(byte[] T, int[] SA, int p1, int p2, int depth) {
        int U2;
        int U1 = depth + SA[p1];
        int U1n = SA[p1 + 1] + 2;
        int U2n = SA[p2 + 1] + 2;
        for (U2 = depth + SA[p2]; U1 < U1n && U2 < U2n && T[U1] == T[U2]; ++U1, ++U2) {
        }
        return U1 < U1n ? (U2 < U2n ? T[U1] - T[U2] : 1) : (U2 < U2n ? -1 : 0);
    }

    private final int ss_compare_last(byte[] T, int[] SA, int xpa, int p1, int p2, int depth, int size) {
        int U2;
        int U1 = depth + SA[p1];
        int U1n = size;
        int U2n = SA[p2 + 1] + 2;
        for (U2 = depth + SA[p2]; U1 < U1n && U2 < U2n && T[U1] == T[U2]; ++U1, ++U2) {
        }
        if (U1 < U1n) {
            return U2 < U2n ? T[U1] - T[U2] : 1;
        }
        if (U2 == U2n) {
            return 1;
        }
        U1 %= size;
        U1n = SA[xpa] + 2;
        while (U1 < U1n && U2 < U2n && T[U1] == T[U2]) {
            ++U1;
            ++U2;
        }
        return U1 < U1n ? (U2 < U2n ? T[U1] - T[U2] : 1) : (U2 < U2n ? -1 : 0);
    }

    private final void ss_insertionsort(byte[] T, int[] SA, int xpa, int first, int last, int depth) {
        for (int i = last - 2; first <= i; --i) {
            int r;
            int t = SA[i];
            int j = i + 1;
            while (0 < (r = this.ss_compare(T, SA, xpa + t, xpa + SA[j], depth))) {
                do {
                    SA[j - 1] = SA[j];
                } while (++j < last && SA[j] < 0);
                if (last > j) continue;
            }
            if (r == 0) {
                SA[j] = ~SA[j];
            }
            SA[j - 1] = t;
        }
    }

    private final void ss_fixdown(byte[] T, int depth, int[] SA, int xpa, int root, int i, int size) {
        int j;
        int v = SA[root + i];
        byte c = T[SA[xpa + v] + depth];
        while ((j = 2 * i + 1) < size) {
            byte e;
            int k;
            byte d;
            if ((d = T[SA[xpa + SA[root + (k = j++)]] + depth]) < (e = T[SA[xpa + SA[root + j]] + depth])) {
                k = j;
                d = e;
            }
            if (d <= c) break;
            SA[root + i] = SA[root + k];
            i = k;
        }
        SA[root + i] = v;
    }

    private final void ss_heapsort(byte[] T, int depth, int[] SA, int xpa, int root, int size) {
        int i;
        int t;
        int m = size;
        if (size % 2 == 0 && T[SA[xpa + SA[root + --m / 2]] + depth] < T[SA[xpa + SA[root + m]] + depth]) {
            t = SA[root + m];
            SA[root + m] = SA[root + m / 2];
            SA[root + m / 2] = t;
        }
        for (i = m / 2 - 1; 0 <= i; --i) {
            this.ss_fixdown(T, depth, SA, xpa, root, i, m);
        }
        if (size % 2 == 0) {
            t = SA[root];
            SA[root] = SA[root + m];
            SA[root + m] = t;
            this.ss_fixdown(T, depth, SA, xpa, root, 0, m);
        }
        for (i = m - 1; 0 < i; --i) {
            t = SA[root];
            SA[root] = SA[root + i];
            this.ss_fixdown(T, depth, SA, xpa, root, 0, i);
            SA[root + i] = t;
        }
    }

    private final int ss_pivot_key(byte[] T, int depth, int[] SA, int xpa, int p) {
        return (T[SA[xpa + SA[p]] + depth] << 24) + p;
    }

    private final int ss_pivot(byte[] T, int depth, int[] SA, int xpa, int first, int last) {
        int t = last - first >> 1;
        int middle = first + t;
        int v1 = this.ss_pivot_key(T, depth, SA, xpa, first);
        int v5 = this.ss_pivot_key(T, depth, SA, xpa, middle);
        int v9 = this.ss_pivot_key(T, depth, SA, xpa, last - 1);
        if (t <= 16) {
            return Utils.med3(v1, v5, v9) & 0xFFFFFF;
        }
        int v3 = this.ss_pivot_key(T, depth, SA, xpa, first + (t >>= 1));
        int v7 = this.ss_pivot_key(T, depth, SA, xpa, last - t);
        if (t <= 128) {
            return Utils.med5(v1, v3, v5, v7, v9) & 0xFFFFFF;
        }
        int v2 = this.ss_pivot_key(T, depth, SA, xpa, first + (t >>= 1));
        int v4 = this.ss_pivot_key(T, depth, SA, xpa, middle - t);
        int v6 = this.ss_pivot_key(T, depth, SA, xpa, middle + t);
        int v8 = this.ss_pivot_key(T, depth, SA, xpa, last - t);
        return Utils.med3(Utils.med3(v1, v2, v3), Utils.med3(v4, v5, v6), Utils.med3(v7, v8, v9)) & 0xFFFFFF;
    }

    private final int ss_partition(int[] SA, int xpa, int first, int last, int depth) {
        int a = first - 1;
        int b = last;
        while (true) {
            if (++a < b && SA[xpa + SA[a]] + depth >= SA[xpa + SA[a] + 1] + 1) {
                SA[a] = ~SA[a];
                continue;
            }
            while (a < --b && SA[xpa + SA[b]] + depth < SA[xpa + SA[b] + 1] + 1) {
            }
            if (b <= a) break;
            int t = ~SA[b];
            SA[b] = SA[a];
            SA[a] = t;
        }
        if (first < a) {
            SA[first] = ~SA[first];
        }
        return a;
    }

    private final void ss_mintrosort(byte[] T, int[] SA, int xpa, int first, int last, int depth) {
        int SS_MISORT_STACKSIZE = 16;
        int[] stack = new int[64];
        byte x = 0;
        int ssize = 0;
        int limit = Utils.ilog2_16(last - first);
        while (true) {
            int a;
            byte v;
            if (last - first <= 8) {
                if (1 < last - first) {
                    this.ss_insertionsort(T, SA, xpa, first, last, depth);
                }
                if (ssize == 0) {
                    return;
                }
                first = stack[ssize - 4];
                last = stack[ssize - 3];
                depth = stack[ssize - 2];
                limit = stack[ssize - 1];
                ssize -= 4;
                continue;
            }
            if (limit-- == 0) {
                this.ss_heapsort(T, depth, SA, xpa, first, last - first);
            }
            if (limit < 0) {
                v = T[SA[xpa + SA[first]] + depth];
                for (a = first + 1; a < last; ++a) {
                    x = T[SA[xpa + SA[a]] + depth];
                    if (x == v) continue;
                    if (1 < a - first) break;
                    v = x;
                    first = a;
                }
                if (T[SA[xpa + SA[first]] - 1 + depth] < v) {
                    first = this.ss_partition(SA, xpa, first, a, depth);
                }
                if (a - first <= last - a) {
                    if (1 < a - first) {
                        ssize = this.STACK_PUSH(stack, ssize, a, last, depth, -1);
                        last = a;
                        ++depth;
                        limit = Utils.ilog2_16(a - first);
                        continue;
                    }
                    first = a;
                    limit = -1;
                    continue;
                }
                if (1 < last - a) {
                    ssize = this.STACK_PUSH(stack, ssize, first, a, depth + 1, Utils.ilog2_16(a - first));
                    first = a;
                    limit = -1;
                    continue;
                }
                last = a;
                ++depth;
                limit = Utils.ilog2_16(a - first);
                continue;
            }
            a = this.ss_pivot(T, depth, SA, xpa, first, last);
            v = T[SA[xpa + SA[a]] + depth];
            int t = SA[first];
            SA[first] = SA[a];
            SA[a] = t;
            int b = first;
            while (++b < last && (x = T[SA[xpa + SA[b]] + depth]) == v) {
            }
            a = b;
            if (a < last && x < v) {
                while (++b < last && (x = T[SA[xpa + SA[b]] + depth]) <= v) {
                    if (x != v) continue;
                    t = SA[b];
                    SA[b] = SA[a];
                    SA[a] = t;
                    ++a;
                }
            }
            int c = last;
            while (b < --c && (x = T[SA[xpa + SA[c]] + depth]) == v) {
            }
            int d = c;
            if (b < d && x > v) {
                while (b < --c && (x = T[SA[xpa + SA[c]] + depth]) >= v) {
                    if (x != v) continue;
                    t = SA[c];
                    SA[c] = SA[d];
                    SA[d] = t;
                    --d;
                }
            }
            while (b < c) {
                t = SA[b];
                SA[b] = SA[c];
                SA[c] = t;
                while (++b < c && (x = T[SA[xpa + SA[b]] + depth]) <= v) {
                    if (x != v) continue;
                    t = SA[b];
                    SA[b] = SA[a];
                    SA[a] = t;
                    ++a;
                }
                while (b < --c && (x = T[SA[xpa + SA[c]] + depth]) >= v) {
                    if (x != v) continue;
                    t = SA[c];
                    SA[c] = SA[d];
                    SA[d] = t;
                    --d;
                }
            }
            if (a <= d) {
                c = b - 1;
                int s = a - first;
                t = b - a;
                if (s > t) {
                    s = t;
                }
                int e = first;
                int f = b - s;
                while (0 < s) {
                    t = SA[e];
                    SA[e] = SA[f];
                    SA[f] = t;
                    --s;
                    ++e;
                    ++f;
                }
                s = d - c;
                t = last - d - 1;
                if (s > t) {
                    s = t;
                }
                e = b;
                f = last - s;
                while (0 < s) {
                    t = SA[e];
                    SA[e] = SA[f];
                    SA[f] = t;
                    --s;
                    ++e;
                    ++f;
                }
                a = first + (b - a);
                c = last - (d - c);
                int n = b = v <= T[SA[xpa + SA[a]] - 1 + depth] ? a : this.ss_partition(SA, xpa, a, c, depth);
                if (a - first <= last - c) {
                    if (last - c <= c - b) {
                        ssize = this.STACK_PUSH(stack, ssize, b, c, depth + 1, Utils.ilog2_16(c - b));
                        ssize = this.STACK_PUSH(stack, ssize, c, last, depth, limit);
                        last = a;
                        continue;
                    }
                    if (a - first <= c - b) {
                        ssize = this.STACK_PUSH(stack, ssize, c, last, depth, limit);
                        ssize = this.STACK_PUSH(stack, ssize, b, c, depth + 1, Utils.ilog2_16(c - b));
                        last = a;
                        continue;
                    }
                    ssize = this.STACK_PUSH(stack, ssize, c, last, depth, limit);
                    ssize = this.STACK_PUSH(stack, ssize, first, a, depth, limit);
                    first = b;
                    last = c;
                    ++depth;
                    limit = Utils.ilog2_16(c - b);
                    continue;
                }
                if (a - first <= c - b) {
                    ssize = this.STACK_PUSH(stack, ssize, b, c, depth + 1, Utils.ilog2_16(c - b));
                    ssize = this.STACK_PUSH(stack, ssize, first, a, depth, limit);
                    first = c;
                    continue;
                }
                if (last - c <= c - b) {
                    ssize = this.STACK_PUSH(stack, ssize, first, a, depth, limit);
                    ssize = this.STACK_PUSH(stack, ssize, b, c, depth + 1, Utils.ilog2_16(c - b));
                    first = c;
                    continue;
                }
                ssize = this.STACK_PUSH(stack, ssize, first, a, depth, limit);
                ssize = this.STACK_PUSH(stack, ssize, c, last, depth, limit);
                first = b;
                last = c;
                ++depth;
                limit = Utils.ilog2_16(c - b);
                continue;
            }
            ++limit;
            if (T[SA[xpa + SA[first]] - 1 + depth] < v) {
                first = this.ss_partition(SA, xpa, first, last, depth);
                limit = Utils.ilog2_16(last - first);
            }
            ++depth;
        }
    }

    private final void ss_blockswap(int[] SA, int a, int b, int n) {
        while (0 < n) {
            int t = SA[a];
            SA[a] = SA[b];
            SA[b] = t;
            --n;
            ++a;
            ++b;
        }
    }

    private final void ss_rotate(int[] SA, int first, int middle, int last) {
        int l = middle - first;
        int r = last - middle;
        block0: while (0 < l && 0 < r) {
            int t;
            int b;
            int a;
            if (l == r) {
                this.ss_blockswap(SA, first, middle, l);
                break;
            }
            if (l < r) {
                a = last - 1;
                b = middle - 1;
                t = SA[a];
                while (true) {
                    SA[a--] = SA[b];
                    SA[b--] = SA[a];
                    if (b >= first) continue;
                    SA[a] = t;
                    last = a--;
                    if ((r -= l + 1) <= l) continue block0;
                    b = middle - 1;
                    t = SA[a];
                }
            }
            a = first;
            b = middle;
            t = SA[a];
            while (true) {
                SA[a++] = SA[b];
                SA[b++] = SA[a];
                if (last > b) continue;
                SA[a] = t;
                first = a + 1;
                if ((l -= r + 1) <= r) continue block0;
                b = middle;
                t = SA[++a];
            }
        }
    }

    private final void ss_inplacemerge(byte[] T, int[] SA, int xpa, int first, int middle, int last, int depth) {
        do {
            int p;
            boolean x;
            if (SA[last - 1] < 0) {
                x = true;
                p = xpa + ~SA[last - 1];
            } else {
                x = false;
                p = xpa + SA[last - 1];
            }
            int a = first;
            int len = middle - first;
            int half = len >> 1;
            int r = -1;
            while (0 < len) {
                int b = a + half;
                int q = this.ss_compare(T, SA, xpa + (0 <= SA[b] ? SA[b] : ~SA[b]), p, depth);
                if (q < 0) {
                    a = b + 1;
                    half -= len & 1 ^ 1;
                } else {
                    r = q;
                }
                len = half;
                half >>= 1;
            }
            if (a < middle) {
                if (r == 0) {
                    SA[a] = ~SA[a];
                }
                this.ss_rotate(SA, a, middle, last);
                last -= middle - a;
                middle = a;
                if (first == middle) break;
            }
            --last;
            if (!x) continue;
            while (SA[--last] < 0) {
            }
        } while (middle != last);
    }

    private final void ss_mergeforward(byte[] T, int[] SA, int xpa, int first, int middle, int last, int buf, int depth) {
        int bufend = buf + (middle - first) - 1;
        this.ss_blockswap(SA, buf, first, middle - first);
        int a = first;
        int t = SA[a];
        int b = buf;
        int c = middle;
        while (true) {
            int r;
            if ((r = this.ss_compare(T, SA, xpa + SA[b], xpa + SA[c], depth)) < 0) {
                do {
                    SA[a++] = SA[b];
                    if (bufend <= b) {
                        SA[bufend] = t;
                        return;
                    }
                    SA[b++] = SA[a];
                } while (SA[b] < 0);
                continue;
            }
            if (r > 0) {
                do {
                    SA[a++] = SA[c];
                    SA[c++] = SA[a];
                    if (last > c) continue;
                    while (b < bufend) {
                        SA[a++] = SA[b];
                        SA[b++] = SA[a];
                    }
                    SA[a] = SA[b];
                    SA[b] = t;
                    return;
                } while (SA[c] < 0);
                continue;
            }
            SA[c] = ~SA[c];
            do {
                SA[a++] = SA[b];
                if (bufend <= b) {
                    SA[bufend] = t;
                    return;
                }
                SA[b++] = SA[a];
            } while (SA[b] < 0);
            do {
                SA[a++] = SA[c];
                SA[c++] = SA[a];
                if (last > c) continue;
                while (b < bufend) {
                    SA[a++] = SA[b];
                    SA[b++] = SA[a];
                }
                SA[a] = SA[b];
                SA[b] = t;
                return;
            } while (SA[c] < 0);
        }
    }

    private final void ss_mergebackward(byte[] T, int[] SA, int xpa, int first, int middle, int last, int buf, int depth) {
        int p2;
        int p1;
        int bufend = buf + (last - middle) - 1;
        this.ss_blockswap(SA, buf, middle, last - middle);
        int x = 0;
        if (SA[bufend] < 0) {
            p1 = xpa + ~SA[bufend];
            x |= 1;
        } else {
            p1 = xpa + SA[bufend];
        }
        if (SA[middle - 1] < 0) {
            p2 = xpa + ~SA[middle - 1];
            x |= 2;
        } else {
            p2 = xpa + SA[middle - 1];
        }
        int a = last - 1;
        int t = SA[a];
        int b = bufend;
        int c = middle - 1;
        while (true) {
            int r;
            if (0 < (r = this.ss_compare(T, SA, p1, p2, depth))) {
                if ((x & 1) != 0) {
                    do {
                        SA[a--] = SA[b];
                        SA[b--] = SA[a];
                    } while (SA[b] < 0);
                    x ^= 1;
                }
                SA[a--] = SA[b];
                if (b <= buf) {
                    SA[buf] = t;
                    break;
                }
                SA[b--] = SA[a];
                if (SA[b] < 0) {
                    p1 = xpa + ~SA[b];
                    x |= 1;
                    continue;
                }
                p1 = xpa + SA[b];
                continue;
            }
            if (r < 0) {
                if ((x & 2) != 0) {
                    do {
                        SA[a--] = SA[c];
                        SA[c--] = SA[a];
                    } while (SA[c] < 0);
                    x ^= 2;
                }
                SA[a--] = SA[c];
                SA[c--] = SA[a];
                if (c < first) {
                    while (buf < b) {
                        SA[a--] = SA[b];
                        SA[b--] = SA[a];
                    }
                    SA[a] = SA[b];
                    SA[b] = t;
                    break;
                }
                if (SA[c] < 0) {
                    p2 = xpa + ~SA[c];
                    x |= 2;
                    continue;
                }
                p2 = xpa + SA[c];
                continue;
            }
            if ((x & 1) != 0) {
                do {
                    SA[a--] = SA[b];
                    SA[b--] = SA[a];
                } while (SA[b] < 0);
                x ^= 1;
            }
            SA[a--] = ~SA[b];
            if (b <= buf) {
                SA[buf] = t;
                break;
            }
            SA[b--] = SA[a];
            if ((x & 2) != 0) {
                do {
                    SA[a--] = SA[c];
                    SA[c--] = SA[a];
                } while (SA[c] < 0);
                x ^= 2;
            }
            SA[a--] = SA[c];
            SA[c--] = SA[a];
            if (c < first) {
                while (buf < b) {
                    SA[a--] = SA[b];
                    SA[b--] = SA[a];
                }
                SA[a] = SA[b];
                SA[b] = t;
                break;
            }
            if (SA[b] < 0) {
                p1 = xpa + ~SA[b];
                x |= 1;
            } else {
                p1 = xpa + SA[b];
            }
            if (SA[c] < 0) {
                p2 = xpa + ~SA[c];
                x |= 2;
                continue;
            }
            p2 = xpa + SA[c];
        }
    }

    private final int GETIDX(int a) {
        return 0 <= a ? a : ~a;
    }

    private final void MERGE_CHECK(byte[] T, int[] SA, int xpa, int depth, int a, int b, int c) {
        if ((c & 1) != 0 || (c & 2) != 0 && this.ss_compare(T, SA, xpa + this.GETIDX(SA[a - 1]), xpa + SA[a], depth) == 0) {
            SA[a] = ~SA[a];
        }
        if ((c & 4) != 0 && this.ss_compare(T, SA, xpa + this.GETIDX(SA[b - 1]), xpa + SA[b], depth) == 0) {
            SA[b] = ~SA[b];
        }
    }

    private final void ss_swapmerge(byte[] T, int[] SA, int xpa, int first, int middle, int last, int buf, int bufsize, int depth) {
        int SS_SMERGE_STACKSIZE = 32;
        int[] stack = new int[128];
        int check = 0;
        int ssize = 0;
        while (true) {
            if (last - middle <= bufsize) {
                if (first < middle && middle < last) {
                    this.ss_mergebackward(T, SA, xpa, first, middle, last, buf, depth);
                }
                this.MERGE_CHECK(T, SA, xpa, depth, first, last, check);
                if (ssize == 0) {
                    return;
                }
                first = stack[ssize - 4];
                middle = stack[ssize - 3];
                last = stack[ssize - 2];
                check = stack[ssize - 1];
                ssize -= 4;
                continue;
            }
            if (middle - first <= bufsize) {
                if (first < middle) {
                    this.ss_mergeforward(T, SA, xpa, first, middle, last, buf, depth);
                }
                this.MERGE_CHECK(T, SA, xpa, depth, first, last, check);
                if (ssize == 0) {
                    return;
                }
                first = stack[ssize - 4];
                middle = stack[ssize - 3];
                last = stack[ssize - 2];
                check = stack[ssize - 1];
                ssize -= 4;
                continue;
            }
            int m = 0;
            int len = Math.min(middle - first, last - middle);
            int half = len >> 1;
            while (0 < len) {
                if (this.ss_compare(T, SA, xpa + this.GETIDX(SA[middle + m + half]), xpa + this.GETIDX(SA[middle - m - half - 1]), depth) < 0) {
                    m += half + 1;
                    half -= len & 1 ^ 1;
                }
                len = half;
                half >>= 1;
            }
            if (0 < m) {
                int r;
                int lm = middle - m;
                int rm = middle + m;
                this.ss_blockswap(SA, lm, middle, m);
                int l = r = middle;
                int next = 0;
                if (rm < last) {
                    if (SA[rm] < 0) {
                        SA[rm] = ~SA[rm];
                        if (first < lm) {
                            while (SA[--l] < 0) {
                            }
                            next |= 4;
                        }
                        next |= 1;
                    } else if (first < lm) {
                        while (SA[r] < 0) {
                            ++r;
                        }
                        next |= 2;
                    }
                }
                if (l - first <= last - r) {
                    ssize = this.STACK_PUSH(stack, ssize, r, rm, last, next & 3 | check & 4);
                    middle = lm;
                    last = l;
                    check = check & 3 | next & 4;
                    continue;
                }
                if ((next & 2) != 0 && r == middle) {
                    next ^= 6;
                }
                ssize = this.STACK_PUSH(stack, ssize, first, lm, l, check & 3 | next & 4);
                first = r;
                middle = rm;
                check = next & 3 | check & 4;
                continue;
            }
            if (this.ss_compare(T, SA, xpa + this.GETIDX(SA[middle - 1]), xpa + SA[middle], depth) == 0) {
                SA[middle] = ~SA[middle];
            }
            this.MERGE_CHECK(T, SA, xpa, depth, first, last, check);
            if (ssize == 0) {
                return;
            }
            first = stack[ssize - 4];
            middle = stack[ssize - 3];
            last = stack[ssize - 2];
            check = stack[ssize - 1];
            ssize -= 4;
        }
    }

    final void sssort(byte[] T, int[] SA, int xpa, int first, int last, int buf, int bufsize, int depth, int n, boolean lastsuffix) {
        int k;
        int middle;
        int limit;
        if (lastsuffix) {
            ++first;
        }
        if (bufsize < 1024 && bufsize < last - first && bufsize < (limit = Utils.isqrt(last - first, 1024))) {
            if (1024 < limit) {
                limit = 1024;
            }
            buf = middle = last - limit;
            bufsize = limit;
        } else {
            middle = last;
            limit = 0;
        }
        int a = first;
        int i = 0;
        while (1024 < middle - a) {
            this.ss_mintrosort(T, SA, xpa, a, a + 1024, depth);
            int curbufsize = last - (a + 1024);
            int curbuf = a + 1024;
            if (curbufsize <= bufsize) {
                curbufsize = bufsize;
                curbuf = buf;
            }
            int b = a;
            k = 1024;
            int j = i;
            while ((j & 1) != 0) {
                this.ss_swapmerge(T, SA, xpa, b - k, b, b + k, curbuf, curbufsize, depth);
                b -= k;
                k <<= 1;
                j >>= 1;
            }
            a += 1024;
            ++i;
        }
        this.ss_mintrosort(T, SA, xpa, a, middle, depth);
        k = 1024;
        while (i != 0) {
            if (i & true) {
                this.ss_swapmerge(T, SA, xpa, a - k, a, middle, buf, bufsize, depth);
                a -= k;
            }
            k <<= 1;
            i >>= 1;
        }
        if (limit != 0) {
            this.ss_mintrosort(T, SA, xpa, middle, last, depth);
            this.ss_inplacemerge(T, SA, xpa, first, middle, last, depth);
        }
        if (lastsuffix) {
            i = SA[first - 1];
            int r = 1;
            for (a = first; a < last && (SA[a] < 0 || 0 < (r = this.ss_compare_last(T, SA, xpa, xpa + i, xpa + SA[a], depth, n))); ++a) {
                SA[a - 1] = SA[a];
            }
            if (r == 0) {
                SA[a] = ~SA[a];
            }
            SA[a - 1] = i;
        }
    }
}

