/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.cartogram;

import com.macrofocus.cartogram.InputLayerModel;
import com.macrofocus.cartogram.OutputLayerModel;
import com.macrofocus.cartogram.math.Matrix;
import com.macrofocus.cartogram.math.NumRec;
import com.macrofocus.cartogram.math.Tensor;
import com.macrofocus.common.selection.MutableSingleSelection;
import com.macrofocus.data.table.Column;
import com.macrofocus.geo.model.GeoModel;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.StringTokenizer;
import javax.swing.JTextArea;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateFilter;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

public final class Engine {
    private double sigma = 0.1;
    private static final double CONVERGENCE = 1.0E-100;
    private static final double HINITIAL = 1.0E-4;
    private static final int IMAX = 50;
    private static final double INFTY = 1.0E100;
    private static final int MAXINTSTEPS = 3000;
    private static final double MINH = 1.0E-5;
    private static final double MINPOPFAC = 0.1;
    private static final double SIGMAFAC = 1.2;
    private static final double TIMELIMIT = 1.0E8;
    private static final double TOLF = 0.001;
    private static final double TOLINT = 0.001;
    private static final double TOLX = 0.001;
    private double[][] gridvx;
    private double[][] gridvy;
    private double minpop;
    private double[][] rho;
    private double[][] rho_0;
    private double[][] vx;
    private double[][] vy;
    private double[][] x;
    private double[][] xappr;
    private double[][] y;
    private double[][] yappr;
    private int[][] within;
    private int nblurs = 0;
    private InputLayerModel map;
    private Map2 map2;
    private final GeoModel originalLayer;
    private final MutableSingleSelection<Column> sizeColumn;
    private OutputLayerModel outputMap;
    private final JTextArea statusArea;
    private final Worker worker;

    public double getSigma() {
        return this.sigma;
    }

    public void setSigma(double sigma) {
        this.sigma = sigma;
    }

    public Engine(GeoModel originalLayer, MutableSingleSelection<Column> sizeColumn, JTextArea statusArea, Worker worker) {
        this.originalLayer = originalLayer;
        this.sizeColumn = sizeColumn;
        this.statusArea = statusArea;
        this.worker = worker;
    }

    public void run() {
        boolean n;
        long time = System.currentTimeMillis();
        this.map = new InputLayerModel(this.originalLayer);
        this.gridvx = new double[this.map.getLX() + 1][];
        this.gridvy = new double[this.map.getLX() + 1][];
        this.rho = new double[this.map.getLX() + 1][];
        this.rho_0 = new double[this.map.getLX() + 1][];
        this.vx = new double[this.map.getLX() + 1][];
        this.vy = new double[this.map.getLX() + 1][];
        this.x = new double[this.map.getLX() + 1][];
        this.xappr = new double[this.map.getLX() + 1][];
        this.y = new double[this.map.getLX() + 1][];
        this.yappr = new double[this.map.getLX() + 1][];
        this.within = new int[this.map.getLX() + 1][];
        for (int i = 0; i <= this.map.getLX(); ++i) {
            this.gridvx[i] = new double[this.map.getLY() + 1];
            this.gridvy[i] = new double[this.map.getLY() + 1];
            this.rho[i] = new double[this.map.getLY() + 1];
            this.rho_0[i] = new double[this.map.getLY() + 1];
            this.vx[i] = new double[this.map.getLY() + 1];
            this.vy[i] = new double[this.map.getLY() + 1];
            this.x[i] = new double[this.map.getLY() + 1];
            this.xappr[i] = new double[this.map.getLY() + 1];
            this.y[i] = new double[this.map.getLY() + 1];
            this.yappr[i] = new double[this.map.getLY() + 1];
            this.within[i] = new int[this.map.getLY() + 1];
        }
        this.map2 = new Map2(this.map);
        if (!this.worker.isCancelled()) {
            this.interior();
        }
        if (!this.worker.isCancelled()) {
            this.digdens();
        }
        while (!this.worker.isCancelled() && !(n = this.nonlinvoltra())) {
        }
        if (!this.worker.isCancelled()) {
            this.outputMap = new OutputLayerModel(this.originalLayer, this.map, this);
        }
        this.log("Elapsed: " + (System.currentTimeMillis() - time) / 1000L + " sec.\n");
    }

    private void interior() {
        int j;
        int i;
        int[] inregion = new int[2];
        for (i = 0; i <= this.map.getLX(); ++i) {
            for (j = 0; j <= this.map.getLY(); ++j) {
                this.within[i][j] = -1;
            }
        }
        for (i = 0; i < this.map2.getRegionCount(); ++i) {
            for (j = 0; j < this.map2.getPolygonCount(i); ++j) {
                if (this.worker.isCancelled()) continue;
                Polygon polygon = this.map2.getPolygon(i, j);
                LinearRing exteriorRing = polygon.getExteriorRing();
                int k = 1;
                int n = exteriorRing.getNumPoints() - 1;
                while (k < exteriorRing.getNumPoints()) {
                    int l = (int)Math.ceil(Math.min(exteriorRing.getPointN(k - 1).getY(), exteriorRing.getPointN(k).getY()));
                    while ((double)l < Math.max(exteriorRing.getPointN(k - 1).getY(), exteriorRing.getPointN(k).getY())) {
                        int m = (int)Math.floor(exteriorRing.getEnvelopeInternal().getMinX());
                        while ((double)m < (exteriorRing.getPointN(n).getX() - exteriorRing.getPointN(k).getX()) * ((double)l - exteriorRing.getPointN(k).getY()) / (exteriorRing.getPointN(n).getY() - exteriorRing.getPointN(k).getY()) + exteriorRing.getPointN(k).getX()) {
                            this.within[m][l] = i - this.within[m][l] - 1;
                            ++m;
                        }
                        ++l;
                    }
                    n = k++;
                }
            }
        }
    }

    private void digdens() {
        int j;
        int i;
        int regctr;
        double ncases;
        Object value;
        int row;
        int w;
        double minpop = 1.0E100;
        double totarea = 0.0;
        double totpop = 0.0;
        double[] cases = new double[this.map2.getRegionCount()];
        Column size = (Column)this.sizeColumn.getSelected();
        for (w = 0; w < this.map2.getRegionCount(); ++w) {
            row = this.map2.getRow(w);
            if (row < 0 || (value = this.map.getTableModel().getValueAt(row, size.getColumn())) == null || !(value instanceof Number) || !((ncases = ((Number)value).doubleValue()) < minpop) || !(ncases > 1.0E-12)) continue;
            minpop = ncases;
        }
        cases = new double[this.map2.getRegionCount()];
        for (w = 0; w < this.map2.getRegionCount(); ++w) {
            row = this.map2.getRow(w);
            if (row < 0 || (value = this.map.getTableModel().getValueAt(row, size.getColumn())) == null || !(value instanceof Number)) continue;
            ncases = ((Number)value).doubleValue();
            if (ncases > 1.0E-12) {
                cases[w] = ncases;
                totpop += cases[w];
                continue;
            }
            cases[w] = 0.1 * minpop;
            totpop += cases[w];
        }
        for (int row2 = 0; row2 < this.map2.getRegionCount(); ++row2) {
            if (!(cases[row2] < 0.0)) continue;
            System.err.println("ERROR: No density for region " + row2);
        }
        double[] area = new double[this.map2.getRegionCount()];
        for (regctr = 0; regctr < this.map2.getRegionCount(); ++regctr) {
            area[regctr] = 0.0;
            for (int p = 0; p < this.map2.getPolygonCount(regctr); ++p) {
                int n = regctr;
                area[n] = area[n] + this.map2.getPolygon(regctr, p).getArea();
            }
            totarea += area[regctr];
        }
        double[] dens = new double[this.map2.getRegionCount()];
        for (regctr = 0; regctr < this.map2.getRegionCount(); ++regctr) {
            dens[regctr] = cases[regctr] / area[regctr];
        }
        double avgdens = totpop / totarea;
        for (i = 0; i <= this.map.getLX(); ++i) {
            for (j = 0; j <= this.map.getLY(); ++j) {
                this.rho_0[i][j] = 0.0;
            }
        }
        this.log("digitizing density ...\n");
        for (i = 0; i < this.map.getLX(); ++i) {
            for (j = 0; j < this.map.getLY(); ++j) {
                if (this.worker.isCancelled()) continue;
                this.rho_0[i][j] = this.within[i][j] == -1 ? avgdens : dens[this.within[i][j]];
            }
        }
        double[] dArray = this.rho_0[0];
        dArray[0] = dArray[0] + (this.rho_0[0][this.map.getLY()] + this.rho_0[this.map.getLX()][0] + this.rho_0[this.map.getLX()][this.map.getLY()]);
        for (i = 1; i < this.map.getLX(); ++i) {
            double[] dArray2 = this.rho_0[i];
            dArray2[0] = dArray2[0] + this.rho_0[i][this.map.getLY()];
        }
        for (j = 1; j < this.map.getLY(); ++j) {
            double[] dArray3 = this.rho_0[0];
            int n = j;
            dArray3[n] = dArray3[n] + this.rho_0[this.map.getLX()][j];
        }
        for (i = 0; i < this.map.getLX(); ++i) {
            this.rho_0[i][this.map.getLY()] = this.rho_0[i][0];
        }
        for (j = 0; j <= this.map.getLY(); ++j) {
            this.rho_0[this.map.getLX()][j] = this.rho_0[0][j];
        }
        NumRec.coscosft(this.rho_0, 1, 1, this.map.getLX(), this.map.getLY());
    }

    private void log(String message) {
        if (this.statusArea != null) {
            this.statusArea.append(message);
        } else {
            System.err.println(message);
        }
    }

    private void gaussianblur() {
        int j;
        int i;
        Tensor blur = NumRec.d3tensor(1, this.map.getLX(), this.map.getLY());
        Tensor conv = NumRec.d3tensor(1, this.map.getLX(), this.map.getLY());
        Tensor pop = NumRec.d3tensor(1, this.map.getLX(), this.map.getLY());
        Matrix speqblur = NumRec.dmatrix(1, 2 * this.map.getLX());
        Matrix speqconv = NumRec.dmatrix(1, 2 * this.map.getLX());
        Matrix speqpop = NumRec.dmatrix(1, 2 * this.map.getLX());
        for (i = 1; i <= this.map.getLX(); ++i) {
            for (j = 1; j <= this.map.getLY(); ++j) {
                int p = i > this.map.getLX() / 2 ? i - 1 - this.map.getLX() : i - 1;
                int q = j > this.map.getLY() / 2 ? j - 1 - this.map.getLY() : j - 1;
                double value = this.rho_0[i - 1][j - 1];
                pop.setValue(1, i, j, value);
                conv.setValue(1, i, j, 0.5 * (NumRec.erf(((double)p + 0.5) / (Math.sqrt(2.0) * (this.sigma * Math.pow(1.2, this.nblurs)))) - NumRec.erf(((double)p - 0.5) / (Math.sqrt(2.0) * (this.sigma * Math.pow(1.2, this.nblurs))))) * (NumRec.erf(((double)q + 0.5) / (Math.sqrt(2.0) * (this.sigma * Math.pow(1.2, this.nblurs)))) - NumRec.erf(((double)q - 0.5) / (Math.sqrt(2.0) * (this.sigma * Math.pow(1.2, this.nblurs))))) / (double)(this.map.getLX() * this.map.getLY()));
            }
        }
        NumRec.rlft3(pop, speqpop.m, 1, this.map.getLX(), this.map.getLY(), 1);
        NumRec.rlft3(conv, speqconv.m, 1, this.map.getLX(), this.map.getLY(), 1);
        for (i = 1; i <= this.map.getLX(); ++i) {
            for (j = 1; j <= this.map.getLY() / 2; ++j) {
                blur.setValue(1, i, 2 * j - 1, pop.getValue(1, i, 2 * j - 1) * conv.getValue(1, i, 2 * j - 1) - pop.getValue(1, i, 2 * j) * conv.getValue(1, i, 2 * j));
                blur.setValue(1, i, 2 * j, pop.getValue(1, i, 2 * j) * conv.getValue(1, i, 2 * j - 1) + pop.getValue(1, i, 2 * j - 1) * conv.getValue(1, i, 2 * j));
            }
        }
        for (i = 1; i <= this.map.getLX(); ++i) {
            speqblur.m[1][2 * i - 1] = speqpop.m[1][2 * i - 1] * speqconv.m[1][2 * i - 1] - speqpop.m[1][2 * i] * speqconv.m[1][2 * i];
            speqblur.m[1][2 * i] = speqpop.m[1][2 * i] * speqconv.m[1][2 * i - 1] + speqpop.m[1][2 * i - 1] * speqconv.m[1][2 * i];
        }
        NumRec.rlft3(blur, speqblur.m, 1, this.map.getLX(), this.map.getLY(), -1);
        for (i = 1; i <= this.map.getLX(); ++i) {
            for (j = 1; j <= this.map.getLY(); ++j) {
                this.rho_0[i - 1][j - 1] = blur.getValue(1, i, j);
            }
        }
    }

    private void initcond() {
        int j;
        int i;
        NumRec.coscosft(this.rho_0, -1, -1, this.map.getLX(), this.map.getLY());
        for (i = 0; i < this.map.getLX(); ++i) {
            for (j = 0; j < this.map.getLY(); ++j) {
                if (!(this.rho_0[i][j] < -1.0E10)) continue;
                this.log("ERROR: Negative density in DENSITYFILE.\n");
            }
        }
        this.log("Gaussian blur ...\n");
        this.gaussianblur();
        this.minpop = this.rho_0[0][0];
        double maxpop = this.rho_0[0][0];
        for (i = 0; i < this.map.getLX(); ++i) {
            for (j = 0; j < this.map.getLY(); ++j) {
                if (!(this.rho_0[i][j] < this.minpop)) continue;
                this.minpop = this.rho_0[i][j];
            }
        }
        for (i = 0; i < this.map.getLX(); ++i) {
            for (j = 0; j < this.map.getLY(); ++j) {
                if (!(this.rho_0[i][j] > maxpop)) continue;
                maxpop = this.rho_0[i][j];
            }
        }
        if (0.0 < this.minpop && this.minpop < 1.0E-8 * maxpop) {
            this.log("Minimimum population very small (" + this.minpop + "). Integrator \n");
            this.log("will probably converge very slowly. You can speed up the\n");
            this.log("process by increasing SIGMA to a value > " + this.sigma * Math.pow(1.2, this.nblurs) + ".\n");
        }
        NumRec.coscosft(this.rho_0, 1, 1, this.map.getLX(), this.map.getLY());
    }

    private void calcv(double t) {
        int k;
        int j;
        for (j = 0; j <= this.map.getLX(); ++j) {
            for (k = 0; k <= this.map.getLY(); ++k) {
                this.rho[j][k] = Math.exp(-(Math.PI * (double)j / (double)this.map.getLX() * (Math.PI * (double)j / (double)this.map.getLX()) + Math.PI * (double)k / (double)this.map.getLY() * (Math.PI * (double)k / (double)this.map.getLY())) * t) * this.rho_0[j][k];
            }
        }
        for (j = 0; j <= this.map.getLX(); ++j) {
            for (k = 0; k <= this.map.getLY(); ++k) {
                this.gridvx[j][k] = -(Math.PI * (double)j / (double)this.map.getLX()) * this.rho[j][k];
                this.gridvy[j][k] = -(Math.PI * (double)k / (double)this.map.getLY()) * this.rho[j][k];
            }
        }
        NumRec.coscosft(this.rho, -1, -1, this.map.getLX(), this.map.getLY());
        NumRec.sincosft(this.gridvx, -1, -1, this.map.getLX(), this.map.getLY());
        NumRec.cossinft(this.gridvy, -1, -1, this.map.getLX(), this.map.getLY());
        for (j = 0; j <= this.map.getLX(); ++j) {
            for (k = 0; k <= this.map.getLY(); ++k) {
                this.gridvx[j][k] = -this.gridvx[j][k] / this.rho[j][k];
                this.gridvy[j][k] = -this.gridvy[j][k] / this.rho[j][k];
            }
        }
    }

    private static double intpol(double[][] arr, double x, double y, double lx, double ly) {
        int gaussx = (int)x;
        int gaussy = (int)y;
        double deltax = x - (double)gaussx;
        double deltay = y - (double)gaussy;
        if ((double)gaussx == lx && (double)gaussy == ly) {
            return arr[gaussx][gaussy];
        }
        if ((double)gaussx == lx) {
            return (1.0 - deltay) * arr[gaussx][gaussy] + deltay * arr[gaussx][gaussy + 1];
        }
        if ((double)gaussy == ly) {
            return (1.0 - deltax) * arr[gaussx][gaussy] + deltax * arr[gaussx + 1][gaussy];
        }
        return (1.0 - deltax) * (1.0 - deltay) * arr[gaussx][gaussy] + (1.0 - deltax) * deltay * arr[gaussx][gaussy + 1] + deltax * (1.0 - deltay) * arr[gaussx + 1][gaussy] + deltax * deltay * arr[gaussx + 1][gaussy + 1];
    }

    private boolean newt2(double h, double[] xappr, int ix, double xguess, double[] yappr, int iy, double yguess, int j, int k) {
        xappr[ix] = xguess;
        yappr[iy] = yguess;
        for (int i = 1; i <= 50; ++i) {
            double fx = xappr[ix] - 0.5 * h * Engine.intpol(this.gridvx, xappr[ix], yappr[iy], this.map.getLX(), this.map.getLY()) - this.x[j][k] - 0.5 * h * this.vx[j][k];
            double fy = yappr[iy] - 0.5 * h * Engine.intpol(this.gridvy, xappr[ix], yappr[iy], this.map.getLX(), this.map.getLY()) - this.y[j][k] - 0.5 * h * this.vy[j][k];
            int gaussx = (int)xappr[ix];
            int gaussy = (int)yappr[iy];
            int gaussxplus = gaussx == this.map.getLX() ? 0 : gaussx + 1;
            int gaussyplus = gaussy == this.map.getLY() ? 0 : gaussy + 1;
            double deltax = this.x[j][k] - (double)gaussx;
            double deltay = this.y[j][k] - (double)gaussy;
            double dfxdx = 1.0 - 0.5 * h * ((1.0 - deltay) * (this.gridvx[gaussxplus][gaussy] - this.gridvx[gaussx][gaussy]) + deltay * (this.gridvx[gaussxplus][gaussyplus] - this.gridvx[gaussx][gaussyplus]));
            double dfxdy = -0.5 * h * ((1.0 - deltax) * (this.gridvx[gaussx][gaussyplus] - this.gridvx[gaussx][gaussy]) + deltax * (this.gridvx[gaussxplus][gaussyplus] - this.gridvx[gaussxplus][gaussy]));
            double dfydx = -0.5 * h * ((1.0 - deltay) * (this.gridvy[gaussxplus][gaussy] - this.gridvy[gaussx][gaussy]) + deltay * (this.gridvy[gaussxplus][gaussyplus] - this.gridvy[gaussx][gaussyplus]));
            double dfydy = 1.0 - 0.5 * h * ((1.0 - deltax) * (this.gridvy[gaussx][gaussyplus] - this.gridvy[gaussx][gaussy]) + deltax * (this.gridvy[gaussxplus][gaussyplus] - this.gridvy[gaussxplus][gaussy]));
            if (fx * fx + fy * fy < 0.001) {
                return true;
            }
            deltax = (fy * dfxdy - fx * dfydy) / (dfxdx * dfydy - dfxdy * dfydx);
            deltay = (fx * dfydx - fy * dfxdx) / (dfxdx * dfydy - dfxdy * dfydx);
            if (deltax * deltax + deltay * deltay < 0.001) {
                return true;
            }
            int n = ix;
            xappr[n] = xappr[n] + deltax;
            int n2 = iy;
            yappr[n2] = yappr[n2] + deltay;
        }
        this.log("newt2 failed, increasing sigma to " + this.sigma * Math.pow(1.2, this.nblurs) + ".\n");
        return false;
    }

    private boolean nonlinvoltra() {
        try {
            int k;
            int j;
            Writer displfile = null;
            double maxchange = 1.0E100;
            do {
                this.initcond();
                ++this.nblurs;
                if (!(this.minpop < 0.0)) continue;
                this.log("Minimum population negative, will increase sigma to " + this.sigma * Math.pow(1.2, this.nblurs) + "\n");
            } while (this.minpop < 0.0);
            double h = 1.0E-4;
            double t = 0.0;
            for (j = 0; j <= this.map.getLX(); ++j) {
                for (k = 0; k <= this.map.getLY(); ++k) {
                    this.x[j][k] = j;
                    this.y[j][k] = k;
                }
            }
            this.calcv(0.0);
            for (j = 0; j <= this.map.getLX(); ++j) {
                for (k = 0; k <= this.map.getLY(); ++k) {
                    this.vx[j][k] = this.gridvx[j][k];
                    this.vy[j][k] = this.gridvy[j][k];
                }
            }
            int i = 1;
            while (!this.worker.isCancelled()) {
                boolean stepsize_ok = true;
                this.calcv(t + h);
                block8: for (j = 0; j <= this.map.getLX(); ++j) {
                    for (k = 0; k <= this.map.getLY(); ++k) {
                        double vyplus;
                        double yguess;
                        double vxplus = Engine.intpol(this.gridvx, this.x[j][k] + h * this.vx[j][k], this.y[j][k] + h * this.vy[j][k], this.map.getLX(), this.map.getLY());
                        double xguess = this.x[j][k] + 0.5 * h * (this.vx[j][k] + vxplus);
                        if (!this.newt2(h, this.xappr[j], k, xguess, this.yappr[j], k, yguess = this.y[j][k] + 0.5 * h * (this.vy[j][k] + (vyplus = Engine.intpol(this.gridvy, this.x[j][k] + h * this.vx[j][k], this.y[j][k] + h * this.vy[j][k], this.map.getLX(), this.map.getLY()))), j, k)) {
                            return false;
                        }
                        if (!((xguess - this.xappr[j][k]) * (xguess - this.xappr[j][k]) + (yguess - this.yappr[j][k]) * (yguess - this.yappr[j][k]) > 0.001)) continue;
                        if (h < 1.0E-5) {
                            this.log("Time step below + " + h + ", increasing SIGMA to " + this.sigma * Math.pow(1.2, this.nblurs) + "\n");
                            ++this.nblurs;
                            return false;
                        }
                        h /= 10.0;
                        stepsize_ok = false;
                        continue block8;
                    }
                }
                if (stepsize_ok) {
                    t += h;
                    maxchange = 0.0;
                    for (j = 0; j <= this.map.getLX(); ++j) {
                        for (k = 0; k <= this.map.getLY(); ++k) {
                            if ((this.x[j][k] - this.xappr[j][k]) * (this.x[j][k] - this.xappr[j][k]) + (this.y[j][k] - this.yappr[j][k]) * (this.y[j][k] - this.yappr[j][k]) > maxchange) {
                                maxchange = (this.x[j][k] - this.xappr[j][k]) * (this.x[j][k] - this.xappr[j][k]) + (this.y[j][k] - this.yappr[j][k]) * (this.y[j][k] - this.yappr[j][k]);
                            }
                            this.x[j][k] = this.xappr[j][k];
                            this.y[j][k] = this.yappr[j][k];
                            this.vx[j][k] = Engine.intpol(this.gridvx, this.xappr[j][k], this.yappr[j][k], this.map.getLX(), this.map.getLY());
                            this.vy[j][k] = Engine.intpol(this.gridvy, this.xappr[j][k], this.yappr[j][k], this.map.getLX(), this.map.getLY());
                        }
                    }
                    h *= 1.2;
                    if (i % 10 == 0) {
                        this.log("time " + t + "\n");
                    }
                    ++i;
                }
                if (i < 3000 && t < 1.0E8 && maxchange > 1.0E-100) continue;
            }
            if (!this.worker.isCancelled()) {
                if (maxchange > 1.0E-100) {
                    this.log("WARNING: Insufficient convergence within 3000 steps, time 1.0E8.\n");
                }
                if (displfile != null) {
                    displfile.write("time ");
                    displfile.write(t + "\n");
                    displfile.write("minx ");
                    displfile.write(this.map.getMinx() + "\n");
                    displfile.write("maxx ");
                    displfile.write(this.map.getMaxx() + "\n");
                    displfile.write("miny ");
                    displfile.write(this.map.getMiny() + "\n");
                    displfile.write("maxy ");
                    displfile.write(this.map.getMaxy() + "\n");
                    displfile.write("sigma ");
                    displfile.write(this.sigma * Math.pow(1.2, this.nblurs - 1) + "\n");
                    displfile.write("background ");
                    displfile.write("0\n map.getLX()\nly\n\n");
                    for (j = 0; j <= this.map.getLX(); ++j) {
                        for (k = 0; k <= this.map.getLY(); ++k) {
                            displfile.write("j " + j + ", k " + k + ", x " + this.x[j][k] + ", y " + this.y[j][k] + "\n");
                        }
                    }
                    ((BufferedWriter)displfile).close();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return true;
    }

    public CoordinateFilter transf() {
        return new CoordinateFilter(){

            public void filter(Coordinate p) {
                double d;
                Coordinate a = new Coordinate();
                Coordinate b = new Coordinate();
                Coordinate c = new Coordinate();
                Coordinate d2 = new Coordinate();
                Coordinate ptr = new Coordinate();
                double stepX = (double)Engine.this.map.getLX() / (Engine.this.map.getMaxx() - Engine.this.map.getMinx());
                double stepY = (double)Engine.this.map.getLY() / (Engine.this.map.getMaxy() - Engine.this.map.getMiny());
                p.x = Math.min(Engine.this.map.getMaxx() - stepX, Math.max(p.x, Engine.this.map.getMinx()));
                p.y = Math.min(Engine.this.map.getMaxy() - stepY, Math.max(p.y, Engine.this.map.getMiny()));
                assert (p.x >= Engine.this.map.getMinx() && p.x <= Engine.this.map.getMaxx()) : String.valueOf(p) + "; " + String.valueOf(Engine.this.map);
                assert (p.y >= Engine.this.map.getMiny() && p.y <= Engine.this.map.getMaxy()) : String.valueOf(p) + "; " + String.valueOf(Engine.this.map);
                p.x = (p.x - Engine.this.map.getMinx()) * (double)Engine.this.map.getLX() / (Engine.this.map.getMaxx() - Engine.this.map.getMinx());
                p.y = (p.y - Engine.this.map.getMiny()) * (double)Engine.this.map.getLY() / (Engine.this.map.getMaxy() - Engine.this.map.getMiny());
                int gaussx = (int)p.x;
                int gaussy = (int)p.y;
                if (gaussx < 0 || gaussx > Engine.this.map.getLX() || gaussy < 0 || gaussy > Engine.this.map.getLY()) {
                    Engine.this.log("ERROR: Coordinate limits exceeded in transf.\n");
                }
                double deltax = p.x - (double)gaussx;
                double deltay = p.y - (double)gaussy;
                a.x = (1.0 - deltax) * Engine.this.x[gaussx][gaussy] + deltax * Engine.this.x[gaussx + 1][gaussy];
                a.y = (1.0 - deltax) * Engine.this.y[gaussx][gaussy] + deltax * Engine.this.y[gaussx + 1][gaussy];
                b.x = (1.0 - deltax) * Engine.this.x[gaussx][gaussy + 1] + deltax * Engine.this.x[gaussx + 1][gaussy + 1];
                b.y = (1.0 - deltax) * Engine.this.y[gaussx][gaussy + 1] + deltax * Engine.this.y[gaussx + 1][gaussy + 1];
                c.x = (1.0 - deltay) * Engine.this.x[gaussx][gaussy] + deltay * Engine.this.x[gaussx][gaussy + 1];
                c.y = (1.0 - deltay) * Engine.this.y[gaussx][gaussy] + deltay * Engine.this.y[gaussx][gaussy + 1];
                d2.x = (1.0 - deltay) * Engine.this.x[gaussx + 1][gaussy] + deltay * Engine.this.x[gaussx + 1][gaussy + 1];
                d2.y = (1.0 - deltay) * Engine.this.y[gaussx + 1][gaussy] + deltay * Engine.this.y[gaussx + 1][gaussy + 1];
                double den = (b.x - a.x) * (c.y - d2.y) + (a.y - b.y) * (c.x - d2.x);
                if (Math.abs(d) < 1.0E-12) {
                    Engine.this.log("ERROR: Transformed area element has parallel edges.\n");
                }
                double t = ((c.x - a.x) * (c.y - d2.y) + (a.y - c.y) * (c.x - d2.x)) / den;
                double u = ((b.x - a.x) * (c.y - a.y) + (a.y - b.y) * (c.x - a.x)) / den;
                if (t < -0.001 || t > 1.001 || u < -0.001 || u > 1.001) {
                    Engine.this.log("WARNING: Transformed area element non-convex.\n");
                }
                p.x = (1.0 - (a.x + t * (b.x - a.x)) / (double)Engine.this.map.getLX()) * Engine.this.map.getMinx() + (a.x + t * (b.x - a.x)) / (double)Engine.this.map.getLX() * Engine.this.map.getMaxx();
                p.y = (1.0 - (a.y + t * (b.y - a.y)) / (double)Engine.this.map.getLY()) * Engine.this.map.getMiny() + (a.y + t * (b.y - a.y)) / (double)Engine.this.map.getLY() * Engine.this.map.getMaxy();
            }
        };
    }

    public Coordinate transf(GeometryFactory gf, Point po) {
        double d;
        Coordinate p = new Coordinate(po.getX(), po.getY());
        Coordinate a = new Coordinate();
        Coordinate b = new Coordinate();
        Coordinate c = new Coordinate();
        Coordinate d2 = new Coordinate();
        Coordinate ptr = new Coordinate();
        p.x = (p.x - this.map.getMinx()) * (double)this.map.getLX() / (this.map.getMaxx() - this.map.getMinx());
        p.y = (p.y - this.map.getMiny()) * (double)this.map.getLY() / (this.map.getMaxy() - this.map.getMiny());
        int gaussx = (int)p.x;
        int gaussy = (int)p.y;
        if (gaussx < 0 || gaussx > this.map.getLX() || gaussy < 0 || gaussy > this.map.getLY()) {
            this.log("ERROR: Coordinate limits exceeded in transf.\n");
        }
        double deltax = p.x - (double)gaussx;
        double deltay = p.y - (double)gaussy;
        a.x = (1.0 - deltax) * this.x[gaussx][gaussy] + deltax * this.x[gaussx + 1][gaussy];
        a.y = (1.0 - deltax) * this.y[gaussx][gaussy] + deltax * this.y[gaussx + 1][gaussy];
        b.x = (1.0 - deltax) * this.x[gaussx][gaussy + 1] + deltax * this.x[gaussx + 1][gaussy + 1];
        b.y = (1.0 - deltax) * this.y[gaussx][gaussy + 1] + deltax * this.y[gaussx + 1][gaussy + 1];
        c.x = (1.0 - deltay) * this.x[gaussx][gaussy] + deltay * this.x[gaussx][gaussy + 1];
        c.y = (1.0 - deltay) * this.y[gaussx][gaussy] + deltay * this.y[gaussx][gaussy + 1];
        d2.x = (1.0 - deltay) * this.x[gaussx + 1][gaussy] + deltay * this.x[gaussx + 1][gaussy + 1];
        d2.y = (1.0 - deltay) * this.y[gaussx + 1][gaussy] + deltay * this.y[gaussx + 1][gaussy + 1];
        double den = (b.x - a.x) * (c.y - d2.y) + (a.y - b.y) * (c.x - d2.x);
        if (Math.abs(d) < 1.0E-12) {
            this.log("ERROR: Transformed area element has parallel edges.\n");
        }
        double t = ((c.x - a.x) * (c.y - d2.y) + (a.y - c.y) * (c.x - d2.x)) / den;
        double u = ((b.x - a.x) * (c.y - a.y) + (a.y - b.y) * (c.x - a.x)) / den;
        if (t < -0.001 || t > 1.001 || u < -0.001 || u > 1.001) {
            this.log("WARNING: Transformed area element non-convex.\n");
        }
        ptr.x = (1.0 - (a.x + t * (b.x - a.x)) / (double)this.map.getLX()) * this.map.getMinx() + (a.x + t * (b.x - a.x)) / (double)this.map.getLX() * this.map.getMaxx();
        ptr.y = (1.0 - (a.y + t * (b.y - a.y)) / (double)this.map.getLY()) * this.map.getMiny() + (a.y + t * (b.y - a.y)) / (double)this.map.getLY() * this.map.getMaxy();
        return ptr;
    }

    private void pspicture(BufferedReader infile, BufferedWriter outfile) {
        double addy;
        double addx;
        double conv;
        if ((double)(11 * this.map.getLX()) > 8.5 * (double)this.map.getLY()) {
            conv = 612.0f / (float)this.map.getLX();
            addx = 0.0;
            addy = 396.0 - 306.0 * (double)this.map.getLY() / (double)this.map.getLX();
        } else {
            conv = 792.0f / (float)this.map.getLY();
            addx = 306.0 - (double)(396 * this.map.getLX() / this.map.getLY());
            addy = 0.0;
        }
        try {
            String line = infile.readLine();
            StringTokenizer tokenizer = new StringTokenizer(line, " ");
            int id = Integer.parseInt(tokenizer.nextToken());
            line = infile.readLine();
            tokenizer = new StringTokenizer(line, " ");
            double xcoord = Double.parseDouble(tokenizer.nextToken());
            double ycoord = Double.parseDouble(tokenizer.nextToken());
            outfile.write("0.001 setlinewidth\n");
            outfile.write("newpath\n");
            outfile.write((xcoord - this.map.getMinx()) * conv / this.map.getXstepsize() + addx + " ");
            outfile.write((ycoord - this.map.getMiny()) * conv / this.map.getYstepsize() + addy + " ");
            outfile.write("moveto\n");
            while ((line = infile.readLine()) != null) {
                double b;
                double g;
                double r;
                if (!line.startsWith("E")) {
                    tokenizer = new StringTokenizer(line, " ");
                    xcoord = Double.parseDouble(tokenizer.nextToken());
                    ycoord = Double.parseDouble(tokenizer.nextToken());
                    outfile.write((xcoord - this.map.getMinx()) * conv / this.map.getXstepsize() + addx + " ");
                    outfile.write((ycoord - this.map.getMiny()) * conv / this.map.getYstepsize() + addy + " ");
                    outfile.write("lineto\n");
                    continue;
                }
                int maxid = 38;
                if (id % 3 == 0) {
                    r = (float)id / (float)maxid;
                    g = 1.0f - (float)id / (float)maxid;
                    b = Math.abs(1.0f - 2.0f * (float)id / (float)maxid);
                } else if (id % 3 == 1) {
                    b = (float)id / (float)maxid;
                    r = 1.0f - (float)id / (float)maxid;
                    g = Math.abs(1.0f - 2.0f * (float)id / (float)maxid);
                } else {
                    g = (float)id / (float)maxid;
                    b = 1.0f - (float)id / (float)maxid;
                    r = Math.abs(1.0f - 2.0f * (float)id / (float)maxid);
                }
                outfile.write("closepath\n");
                outfile.write(r + " " + g + " " + b + " ");
                outfile.write("setrgbcolor\ngsave\nfill\ngrestore\n0 setgray stroke\n");
                line = infile.readLine();
                if (line.startsWith("E")) break;
                tokenizer = new StringTokenizer(line, " ");
                id = Integer.parseInt(tokenizer.nextToken());
                line = infile.readLine();
                tokenizer = new StringTokenizer(line, " ");
                xcoord = Double.parseDouble(tokenizer.nextToken());
                ycoord = Double.parseDouble(tokenizer.nextToken());
                outfile.write("newpath\n");
                outfile.write((xcoord - this.map.getMinx()) * conv / this.map.getXstepsize() + addx + " ");
                outfile.write((ycoord - this.map.getMiny()) * conv / this.map.getYstepsize() + addy + " ");
                outfile.write("moveto\n");
            }
            outfile.write("showpage\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public InputLayerModel getInputMap() {
        return this.map;
    }

    public OutputLayerModel getOutputMap() {
        return this.outputMap;
    }

    public static interface Worker {
        public boolean isCancelled();
    }

    private final class Map2 {
        private final InputLayerModel layerModel;

        public Map2(InputLayerModel layerModel) {
            this.layerModel = layerModel;
        }

        public final int getRegionCount() {
            return this.layerModel.getRowCount();
        }

        public final int getPolygonCount(int region) {
            Geometry geometry = this.layerModel.getGeometry(region);
            if (geometry != null) {
                if (geometry instanceof MultiPolygon) {
                    return geometry.getNumGeometries();
                }
                if (geometry instanceof Polygon) {
                    return geometry.getNumGeometries();
                }
                return geometry.getNumGeometries();
            }
            return 0;
        }

        public final Polygon getPolygon(int region, int index) {
            Geometry geometry = this.layerModel.getGeometry(region);
            if (geometry instanceof MultiPolygon) {
                return (Polygon)geometry.getGeometryN(index);
            }
            return (Polygon)geometry;
        }

        public final int getRow(int region) {
            return region;
        }
    }
}

