/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.cartogram.math;

import com.macrofocus.cartogram.math.Matrix;
import com.macrofocus.cartogram.math.Tensor;

public final class NumRec {
    private static final double rel_error = 1.0E-12;

    private static boolean signbit(double x) {
        return x < 0.0;
    }

    private static void swap(double[] a, int ia, double[] b, int ib) {
        double tmp = a[ia];
        a[ia] = b[ib];
        b[ib] = tmp;
    }

    private static void four1(double[] data, int nn, int isign) {
        int m;
        int i;
        int n = nn << 1;
        int j = 1;
        for (i = 1; i < n; i += 2) {
            if (j > i) {
                NumRec.swap(data, j, data, i);
                NumRec.swap(data, j + 1, data, i + 1);
            }
            for (m = n >> 1; m >= 2 && j > m; j -= m, m >>= 1) {
            }
            j += m;
        }
        int mmax = 2;
        while (n > mmax) {
            int istep = mmax << 1;
            double theta = (double)isign * (6.28318530717959 / (double)mmax);
            double wtemp = Math.sin(0.5 * theta);
            double wpr = -2.0 * wtemp * wtemp;
            double wpi = Math.sin(theta);
            double wr = 1.0;
            double wi = 0.0;
            for (m = 1; m < mmax; m += 2) {
                for (i = m; i <= n; i += istep) {
                    j = i + mmax;
                    double tempr = wr * data[j] - wi * data[j + 1];
                    double tempi = wr * data[j + 1] + wi * data[j];
                    data[j] = data[i] - tempr;
                    data[j + 1] = data[i + 1] - tempi;
                    int n2 = i;
                    data[n2] = data[n2] + tempr;
                    int n3 = i + 1;
                    data[n3] = data[n3] + tempi;
                }
                wtemp = wr;
                wr = wtemp * wpr - wi * wpi + wr;
                wi = wi * wpr + wtemp * wpi + wi;
            }
            mmax = istep;
        }
    }

    private static void realft(double[] data, int n, int isign) {
        double h1r;
        double c2;
        double c1 = 0.5;
        double theta = Math.PI / (double)(n >> 1);
        if (isign == 1) {
            c2 = -0.5;
            NumRec.four1(data, n >> 1, 1);
        } else {
            c2 = 0.5;
            theta = -theta;
        }
        double wtemp = Math.sin(0.5 * theta);
        double wpr = -2.0 * wtemp * wtemp;
        double wpi = Math.sin(theta);
        double wr = 1.0 + wpr;
        double wi = wpi;
        int np3 = n + 3;
        for (int i = 2; i <= n >> 2; ++i) {
            int i1 = i + i - 1;
            int i2 = 1 + i1;
            int i3 = np3 - i2;
            int i4 = 1 + i3;
            h1r = 0.5 * (data[i1] + data[i3]);
            double h1i = 0.5 * (data[i2] - data[i4]);
            double h2r = -c2 * (data[i2] + data[i4]);
            double h2i = c2 * (data[i1] - data[i3]);
            data[i1] = h1r + wr * h2r - wi * h2i;
            data[i2] = h1i + wr * h2i + wi * h2r;
            data[i3] = h1r - wr * h2r + wi * h2i;
            data[i4] = -h1i + wr * h2i + wi * h2r;
            wtemp = wr;
            wr = wtemp * wpr - wi * wpi + wr;
            wi = wi * wpr + wtemp * wpi + wi;
        }
        if (isign == 1) {
            h1r = data[1];
            data[1] = h1r + data[2];
            data[2] = h1r - data[2];
        } else {
            h1r = data[1];
            data[1] = 0.5 * (h1r + data[2]);
            data[2] = 0.5 * (h1r - data[2]);
            NumRec.four1(data, n >> 1, -1);
        }
    }

    private static void cosft(double[] z, int n, int isign) {
        int j;
        double wi = 0.0;
        double wr = 1.0;
        double[] a = new double[n + 2];
        for (j = 1; j <= n + 1; ++j) {
            a[j] = z[j - 1];
        }
        double theta = Math.PI / (double)n;
        double wtemp = Math.sin(0.5 * theta);
        double wpr = -2.0 * wtemp * wtemp;
        double wpi = Math.sin(theta);
        double sum = 0.5 * (a[1] - a[n + 1]);
        a[1] = 0.5 * (a[1] + a[n + 1]);
        int n2 = n + 2;
        for (j = 2; j <= n >> 1; ++j) {
            wtemp = wr;
            wr = wtemp * wpr - wi * wpi + wr;
            wi = wi * wpr + wtemp * wpi + wi;
            double y1 = 0.5 * (a[j] + a[n2 - j]);
            double y2 = a[j] - a[n2 - j];
            a[j] = y1 - wi * y2;
            a[n2 - j] = y1 + wi * y2;
            sum += wr * y2;
        }
        NumRec.realft(a, n, 1);
        a[n + 1] = a[2];
        a[2] = sum;
        for (j = 4; j <= n; j += 2) {
            a[j] = sum += a[j];
        }
        if (isign == 1) {
            for (j = 1; j <= n + 1; ++j) {
                z[j - 1] = a[j];
            }
        } else if (isign == -1) {
            for (j = 1; j <= n + 1; ++j) {
                z[j - 1] = 2.0 * a[j] / (double)n;
            }
        }
        a = null;
    }

    private static void sinft(double[] z, int n, int isign) {
        int j;
        double wi = 0.0;
        double wr = 1.0;
        int n2 = n + 2;
        double[] a = new double[n + 1];
        for (j = 1; j <= n; ++j) {
            a[j] = z[j - 1];
        }
        double theta = Math.PI / (double)n;
        double wtemp = Math.sin(0.5 * theta);
        double wpr = -2.0 * wtemp * wtemp;
        double wpi = Math.sin(theta);
        a[1] = 0.0;
        for (j = 2; j <= (n >> 1) + 1; ++j) {
            wtemp = wr;
            wr = wtemp * wpr - wi * wpi + wr;
            wi = wi * wpr + wtemp * wpi + wi;
            double y1 = wi * (a[j] + a[n2 - j]);
            double y2 = 0.5 * (a[j] - a[n2 - j]);
            a[j] = y1 + y2;
            a[n2 - j] = y1 - y2;
        }
        NumRec.realft(a, n, 1);
        a[1] = a[1] * 0.5;
        a[2] = 0.0;
        double sum = 0.0;
        for (j = 1; j <= n - 1; j += 2) {
            a[j] = a[j + 1];
            a[j + 1] = sum += a[j];
        }
        if (isign == 1) {
            for (j = 1; j <= n; ++j) {
                z[j - 1] = a[j];
            }
        } else if (isign == -1) {
            for (j = 1; j <= n; ++j) {
                z[j - 1] = 2.0 * a[j] / (double)n;
            }
        }
        z[n] = 0.0;
        a = null;
    }

    public static void coscosft(double[][] y, int isign1, int isign2, int lx, int ly) {
        int i;
        double[] temp = new double[lx + 1];
        for (i = 0; i <= lx; ++i) {
            NumRec.cosft(y[i], ly, isign2);
        }
        for (int j = 0; j <= ly; ++j) {
            for (i = 0; i <= lx; ++i) {
                temp[i] = y[i][j];
            }
            NumRec.cosft(temp, lx, isign1);
            for (i = 0; i <= lx; ++i) {
                y[i][j] = temp[i];
            }
        }
    }

    public static void cossinft(double[][] y, int isign1, int isign2, int lx, int ly) {
        int i;
        double[] temp = new double[lx + 1];
        for (i = 0; i <= lx; ++i) {
            NumRec.sinft(y[i], ly, isign2);
        }
        for (int j = 0; j <= ly; ++j) {
            for (i = 0; i <= lx; ++i) {
                temp[i] = y[i][j];
            }
            NumRec.cosft(temp, lx, isign1);
            for (i = 0; i <= lx; ++i) {
                y[i][j] = temp[i];
            }
        }
    }

    public static void sincosft(double[][] y, int isign1, int isign2, int lx, int ly) {
        int i;
        double[] temp = new double[lx + 1];
        for (i = 0; i <= lx; ++i) {
            NumRec.cosft(y[i], ly, isign2);
        }
        for (int j = 0; j <= ly; ++j) {
            for (i = 0; i <= lx; ++i) {
                temp[i] = y[i][j];
            }
            NumRec.sinft(temp, lx, isign1);
            for (i = 0; i <= lx; ++i) {
                y[i][j] = temp[i];
            }
        }
    }

    public static Matrix dmatrix(int nrh, int nch) {
        boolean nrl = true;
        boolean ncl = true;
        int nrow = nrh - 1 + 1;
        int ncol = nch - 1 + 1;
        return new Matrix(nrow, ncol);
    }

    public static Tensor d3tensor(int nrh, int nch, int ndh) {
        boolean nrl = true;
        boolean ncl = true;
        boolean ndl = true;
        int nrow = nrh - 1 + 1;
        int ncol = nch - 1 + 1;
        int ndep = ndh - 1 + 1;
        return new Tensor(nrow, ncol, ndep);
    }

    private static void fourn(Tensor data, int[] nn, int ndim, int isign) {
        int idim;
        int ntot = 1;
        for (idim = 1; idim <= ndim; ++idim) {
            ntot *= nn[idim];
        }
        int nprev = 1;
        for (idim = ndim; idim >= 1; --idim) {
            int i3;
            int i1;
            int i2;
            int n = nn[idim];
            int nrem = ntot / (n * nprev);
            int ip1 = nprev << 1;
            int ip2 = ip1 * n;
            int ip3 = ip2 * nrem;
            int i2rev = 1;
            for (i2 = 1; i2 <= ip2; i2 += ip1) {
                int ibit;
                if (i2 < i2rev) {
                    for (i1 = i2; i1 <= i2 + ip1 - 2; i1 += 2) {
                        for (i3 = i1; i3 <= ip3; i3 += ip2) {
                            int i3rev = i2rev + i3 - i2;
                            double tmp = data.getValue(i3);
                            data.setValue(i3, data.getValue(i3rev));
                            data.setValue(i3rev, tmp);
                            double tmp2 = data.getValue(i3 + 1);
                            data.setValue(i3 + 1, data.getValue(i3rev + 1));
                            data.setValue(i3rev + 1, tmp2);
                        }
                    }
                }
                for (ibit = ip2 >> 1; ibit >= ip1 && i2rev > ibit; i2rev -= ibit, ibit >>= 1) {
                }
                i2rev += ibit;
            }
            int ifp1 = ip1;
            while (ifp1 < ip2) {
                int ifp2 = ifp1 << 1;
                double theta = (double)(2 * isign) * Math.PI / (double)(ifp2 / ip1);
                double wtemp = Math.sin(0.5 * theta);
                double wpr = -2.0 * wtemp * wtemp;
                double wpi = Math.sin(theta);
                double wr = 1.0;
                double wi = 0.0;
                for (i3 = 1; i3 <= ifp1; i3 += ip1) {
                    for (i1 = i3; i1 <= i3 + ip1 - 2; i1 += 2) {
                        for (i2 = i1; i2 <= ip3; i2 += ifp2) {
                            int k1 = i2;
                            int k2 = k1 + ifp1;
                            double tempr = (double)((float)wr) * data.getValue(k2) - (double)((float)wi) * data.getValue(k2 + 1);
                            double tempi = (double)((float)wr) * data.getValue(k2 + 1) + (double)((float)wi) * data.getValue(k2);
                            data.setValue(k2, data.getValue(k1) - tempr);
                            data.setValue(k2 + 1, data.getValue(k1 + 1) - tempi);
                            data.setValue(k1, data.getValue(k1) + tempr);
                            data.setValue(k1 + 1, data.getValue(k1 + 1) + tempi);
                        }
                    }
                    wtemp = wr;
                    wr = wtemp * wpr - wi * wpi + wr;
                    wi = wi * wpr + wtemp * wpi + wi;
                }
                ifp1 = ifp2;
            }
            nprev *= n;
        }
    }

    public static void rlft3(Tensor data, double[][] speq, int nn1, int nn2, int nn3, int isign) {
        int i2;
        int j2;
        int i1;
        int[] nn = new int[4];
        double c1 = 0.5;
        double c2 = -0.5 * (double)isign;
        double theta = (double)(2 * isign) * (Math.PI / (double)nn3);
        double wtemp = Math.sin(0.5 * theta);
        double wpr = -2.0 * wtemp * wtemp;
        double wpi = Math.sin(theta);
        nn[1] = nn1;
        nn[2] = nn2;
        nn[3] = nn3 >> 1;
        if (isign == 1) {
            NumRec.fourn(data, nn, 3, isign);
            for (i1 = 1; i1 <= nn1; ++i1) {
                j2 = 0;
                for (i2 = 1; i2 <= nn2; ++i2) {
                    speq[i1][++j2] = data.getValue(i1, i2, 1);
                    speq[i1][++j2] = data.getValue(i1, i2, 2);
                }
            }
        }
        for (i1 = 1; i1 <= nn1; ++i1) {
            int j1 = i1 != 1 ? nn1 - i1 + 2 : 1;
            double wr = 1.0;
            double wi = 0.0;
            int ii3 = 1;
            int i3 = 1;
            while (i3 <= (nn3 >> 2) + 1) {
                for (i2 = 1; i2 <= nn2; ++i2) {
                    double h2r;
                    double h2i;
                    double h1i;
                    double h1r;
                    if (i3 == 1) {
                        j2 = i2 != 1 ? (nn2 - i2 << 1) + 3 : 1;
                        h1r = c1 * (data.getValue(i1, i2, 1) + speq[j1][j2]);
                        h1i = c1 * (data.getValue(i1, i2, 2) - speq[j1][j2 + 1]);
                        h2i = c2 * (data.getValue(i1, i2, 1) - speq[j1][j2]);
                        h2r = -c2 * (data.getValue(i1, i2, 2) + speq[j1][j2 + 1]);
                        data.setValue(i1, i2, 1, h1r + h2r);
                        data.setValue(i1, i2, 2, h1i + h2i);
                        speq[j1][j2] = h1r - h2r;
                        speq[j1][j2 + 1] = h2i - h1i;
                        continue;
                    }
                    j2 = i2 != 1 ? nn2 - i2 + 2 : 1;
                    int j3 = nn3 + 3 - (i3 << 1);
                    h1r = c1 * (data.getValue(i1, i2, ii3) + data.getValue(j1, j2, j3));
                    h1i = c1 * (data.getValue(i1, i2, ii3 + 1) - data.getValue(j1, j2, j3 + 1));
                    h2i = c2 * (data.getValue(i1, i2, ii3) - data.getValue(j1, j2, j3));
                    h2r = -c2 * (data.getValue(i1, i2, ii3 + 1) + data.getValue(j1, j2, j3 + 1));
                    data.setValue(i1, i2, ii3, h1r + wr * h2r - wi * h2i);
                    data.setValue(i1, i2, ii3 + 1, h1i + wr * h2i + wi * h2r);
                    data.setValue(j1, j2, j3, h1r - wr * h2r + wi * h2i);
                    data.setValue(j1, j2, j3 + 1, -h1i + wr * h2i + wi * h2r);
                }
                wtemp = wr;
                wr = wtemp * wpr - wi * wpi + wr;
                wi = wi * wpr + wtemp * wpi + wi;
                ++i3;
                ii3 += 2;
            }
        }
        if (isign == -1) {
            NumRec.fourn(data, nn, 3, isign);
        }
    }

    public static double erf(double x) {
        double two_sqrtpi = 1.1283791670955126;
        if (Math.abs(x) > 2.2) {
            return 1.0 - NumRec.erfc(x);
        }
        double sum = x;
        double term = x;
        double xsqr = x * x;
        int j = 1;
        do {
            sum -= (term *= xsqr / (double)j) / (double)(2 * j + 1);
            sum += (term *= xsqr / (double)(++j)) / (double)(2 * j + 1);
            ++j;
        } while (Math.abs(term / sum) > 1.0E-12);
        return 1.1283791670955126 * sum;
    }

    private static double erfc(double x) {
        double q1;
        double one_sqrtpi = 0.5641895835477563;
        if (Math.abs(x) < 2.2) {
            return 1.0 - NumRec.erf(x);
        }
        if (NumRec.signbit(x)) {
            return 2.0 - NumRec.erfc(-x);
        }
        double a = 1.0;
        double b = x;
        double c = x;
        double d = x * x + 0.5;
        double q2 = b / d;
        double n = 1.0;
        do {
            double t = a * n + b * x;
            a = b;
            b = t;
            t = c * n + d * x;
            c = d;
            d = t;
            n += 0.5;
        } while (Math.abs((q1 = q2) - (q2 = b / d)) / q2 > 1.0E-12);
        return 0.5641895835477563 * Math.exp(-x * x) * q2;
    }
}

