/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import net.sf.mpxj.ActivityCodeContainer;
import net.sf.mpxj.ChildTaskContainer;
import net.sf.mpxj.CostAccountContainer;
import net.sf.mpxj.CustomFieldContainer;
import net.sf.mpxj.DataLinkContainer;
import net.sf.mpxj.EventManager;
import net.sf.mpxj.ExpenseCategoryContainer;
import net.sf.mpxj.FilterContainer;
import net.sf.mpxj.GroupContainer;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ProjectCalendarContainer;
import net.sf.mpxj.ProjectConfig;
import net.sf.mpxj.ProjectProperties;
import net.sf.mpxj.Resource;
import net.sf.mpxj.ResourceAssignmentContainer;
import net.sf.mpxj.ResourceContainer;
import net.sf.mpxj.SubProjectContainer;
import net.sf.mpxj.TableContainer;
import net.sf.mpxj.Task;
import net.sf.mpxj.TaskContainer;
import net.sf.mpxj.ViewContainer;
import net.sf.mpxj.common.NumberHelper;

public final class ProjectFile
implements ChildTaskContainer {
    private final ProjectConfig m_config = new ProjectConfig(this);
    private final ProjectProperties m_properties = new ProjectProperties(this);
    private final ResourceContainer m_resources = new ResourceContainer(this);
    private final TaskContainer m_tasks = new TaskContainer(this);
    private final List<Task> m_childTasks = new ArrayList<Task>();
    private final ResourceAssignmentContainer m_assignments = new ResourceAssignmentContainer(this);
    private final ProjectCalendarContainer m_calendars = new ProjectCalendarContainer(this);
    private final TableContainer m_tables = new TableContainer();
    private final FilterContainer m_filters = new FilterContainer();
    private final GroupContainer m_groups = new GroupContainer();
    private final SubProjectContainer m_subProjects = new SubProjectContainer();
    private final ViewContainer m_views = new ViewContainer();
    private final EventManager m_eventManager = new EventManager();
    private final CustomFieldContainer m_customFields = new CustomFieldContainer();
    private final ActivityCodeContainer m_activityCodes = new ActivityCodeContainer();
    private final DataLinkContainer m_dataLinks = new DataLinkContainer();
    private final ExpenseCategoryContainer m_expenseCategories = new ExpenseCategoryContainer(this);
    private final CostAccountContainer m_costAccounts = new CostAccountContainer(this);

    public ProjectConfig getProjectConfig() {
        return this.m_config;
    }

    @Override
    public Task addTask() {
        return this.m_tasks.add();
    }

    public void removeTask(Task task) {
        this.m_tasks.remove(task);
    }

    public void validateUniqueIDsForMicrosoftProject() {
        this.m_tasks.validateUniqueIDsForMicrosoftProject();
        this.m_resources.validateUniqueIDsForMicrosoftProject();
        this.m_assignments.validateUniqueIDsForMicrosoftProject();
        this.m_calendars.validateUniqueIDsForMicrosoftProject();
    }

    @Override
    public List<Task> getChildTasks() {
        return this.m_childTasks;
    }

    public TaskContainer getTasks() {
        return this.m_tasks;
    }

    public ProjectCalendar addCalendar() {
        return this.m_calendars.add();
    }

    public void removeCalendar(ProjectCalendar calendar) {
        this.m_calendars.remove(calendar);
    }

    public ProjectCalendar addDefaultBaseCalendar() {
        return this.m_calendars.addDefaultBaseCalendar();
    }

    public ProjectCalendar addDefaultDerivedCalendar() {
        return this.m_calendars.addDefaultDerivedCalendar();
    }

    public ProjectCalendarContainer getCalendars() {
        return this.m_calendars;
    }

    public ProjectProperties getProjectProperties() {
        return this.m_properties;
    }

    public Resource addResource() {
        return this.m_resources.add();
    }

    public void removeResource(Resource resource) {
        this.m_resources.remove(resource);
    }

    public ResourceContainer getResources() {
        return this.m_resources;
    }

    public ResourceAssignmentContainer getResourceAssignments() {
        return this.m_assignments;
    }

    public ProjectCalendar getCalendarByName(String calendarName) {
        return this.m_calendars.getByName(calendarName);
    }

    public ProjectCalendar getCalendarByUniqueID(Integer calendarID) {
        return (ProjectCalendar)this.m_calendars.getByUniqueID(calendarID);
    }

    public Task getTaskByID(Integer id) {
        return (Task)this.m_tasks.getByID(id);
    }

    public Task getTaskByUniqueID(Integer id) {
        return (Task)this.m_tasks.getByUniqueID(id);
    }

    public Resource getResourceByID(Integer id) {
        return (Resource)this.m_resources.getByID(id);
    }

    public Resource getResourceByUniqueID(Integer id) {
        return (Resource)this.m_resources.getByUniqueID(id);
    }

    public void updateStructure() {
        this.m_tasks.updateStructure();
    }

    public Date getStartDate() {
        Date startDate = null;
        for (Task task : this.m_tasks) {
            Date taskStartDate;
            if (NumberHelper.getInt(task.getUniqueID()) == 0) continue;
            if (task.getMilestone()) {
                taskStartDate = task.getActualFinish();
                if (taskStartDate == null) {
                    taskStartDate = task.getFinish();
                }
            } else {
                taskStartDate = task.getActualStart();
                if (taskStartDate == null) {
                    taskStartDate = task.getStart();
                }
            }
            if (taskStartDate == null) continue;
            if (startDate == null) {
                startDate = taskStartDate;
                continue;
            }
            if (taskStartDate.getTime() >= startDate.getTime()) continue;
            startDate = taskStartDate;
        }
        return startDate;
    }

    public Date getFinishDate() {
        Date finishDate = null;
        for (Task task : this.m_tasks) {
            if (NumberHelper.getInt(task.getUniqueID()) == 0) continue;
            Date taskFinishDate = task.getActualFinish();
            if (taskFinishDate == null) {
                taskFinishDate = task.getFinish();
            }
            if (taskFinishDate == null) continue;
            if (finishDate == null) {
                finishDate = taskFinishDate;
                continue;
            }
            if (taskFinishDate.getTime() <= finishDate.getTime()) continue;
            finishDate = taskFinishDate;
        }
        return finishDate;
    }

    public ViewContainer getViews() {
        return this.m_views;
    }

    public TableContainer getTables() {
        return this.m_tables;
    }

    public FilterContainer getFilters() {
        return this.m_filters;
    }

    public GroupContainer getGroups() {
        return this.m_groups;
    }

    public SubProjectContainer getSubProjects() {
        return this.m_subProjects;
    }

    public EventManager getEventManager() {
        return this.m_eventManager;
    }

    public CustomFieldContainer getCustomFields() {
        return this.m_customFields;
    }

    public ActivityCodeContainer getActivityCodes() {
        return this.m_activityCodes;
    }

    public DataLinkContainer getDataLinks() {
        return this.m_dataLinks;
    }

    public ExpenseCategoryContainer getExpenseCategories() {
        return this.m_expenseCategories;
    }

    public CostAccountContainer getCostAccounts() {
        return this.m_costAccounts;
    }

    public ProjectCalendar getDefaultCalendar() {
        String calendarName = this.m_properties.getDefaultCalendarName();
        ProjectCalendar calendar = this.getCalendarByName(calendarName);
        if (calendar == null) {
            calendar = this.m_calendars.isEmpty() ? this.addDefaultBaseCalendar() : (ProjectCalendar)this.m_calendars.get(0);
        }
        return calendar;
    }

    public void setDefaultCalendar(ProjectCalendar calendar) {
        if (calendar != null) {
            this.m_properties.setDefaultCalendarName(calendar.getName());
        }
    }

    public ProjectCalendar getBaselineCalendar() {
        ProjectCalendar result = this.getCalendarByName("Used for Microsoft Project 98 Baseline Calendar");
        if (result == null) {
            result = this.getDefaultCalendar();
        }
        return result;
    }
}

