/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.explorer;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import net.sf.mpxj.Duration;
import net.sf.mpxj.explorer.ObjectPropertiesModel;

public class ObjectPropertiesController {
    private final ObjectPropertiesModel m_model;

    public ObjectPropertiesController(ObjectPropertiesModel model) {
        this.m_model = model;
    }

    public void loadObject(Object object, Set<String> excludedMethods) {
        this.m_model.setTableModel(this.createTableModel(object, excludedMethods));
    }

    private TableModel createTableModel(Object object, Set<String> excludedMethods) {
        ArrayList<Method> methods = new ArrayList<Method>();
        for (Method method : object.getClass().getMethods()) {
            Object name;
            if (method.getParameterTypes().length != 0 && (method.getParameterTypes().length != 1 || method.getParameterTypes()[0] != Integer.TYPE) || excludedMethods.contains(name = method.getName()) || !((String)name).startsWith("get") && !((String)name).startsWith("is")) continue;
            methods.add(method);
        }
        TreeMap<String, String> map = new TreeMap<String, String>();
        for (Method method : methods) {
            if (method.getParameterTypes().length == 0) {
                this.getSingleValue(method, object, map);
                continue;
            }
            this.getMultipleValues(method, object, map);
        }
        Object[] headings = new String[]{"Property", "Value"};
        Object[][] data = new String[map.size()][2];
        int rowIndex = 0;
        for (Map.Entry entry : map.entrySet()) {
            data[rowIndex][0] = (String)entry.getKey();
            data[rowIndex][1] = (String)entry.getValue();
            ++rowIndex;
        }
        DefaultTableModel tableModel = new DefaultTableModel(data, headings){

            @Override
            public boolean isCellEditable(int r, int c) {
                return false;
            }
        };
        return tableModel;
    }

    private Object filterValue(Object value) {
        if (value instanceof Boolean && !((Boolean)value).booleanValue()) {
            value = null;
        }
        if (value instanceof String && ((String)value).isEmpty()) {
            value = null;
        }
        if (value instanceof Double && (Double)value == 0.0) {
            value = null;
        }
        if (value instanceof Integer && (Integer)value == 0) {
            value = null;
        }
        if (value instanceof Duration && ((Duration)value).getDuration() == 0.0) {
            value = null;
        }
        return value;
    }

    private void getSingleValue(Method method, Object object, Map<String, String> map) {
        Object value;
        try {
            value = this.filterValue(method.invoke(object, new Object[0]));
        }
        catch (Exception ex) {
            value = ex.toString();
        }
        if (value != null) {
            map.put(this.getPropertyName(method), String.valueOf(value));
        }
    }

    private void getMultipleValues(Method method, Object object, Map<String, String> map) {
        try {
            for (int index = 1; index < 1000; ++index) {
                Object value = this.filterValue(method.invoke(object, index));
                if (value == null) continue;
                map.put(this.getPropertyName(method, index), String.valueOf(value));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String getPropertyName(Method method) {
        String result = method.getName();
        if (result.startsWith("get")) {
            result = result.substring(3);
        }
        return result;
    }

    private String getPropertyName(Method method, int index) {
        return method.getName().substring(3) + index;
    }
}

