/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpd;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import net.sf.mpxj.MPXJException;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.common.AutoCloseableHelper;
import net.sf.mpxj.mpd.MPD9DatabaseReader;
import net.sf.mpxj.reader.AbstractProjectFileReader;

public final class MPDDatabaseReader
extends AbstractProjectFileReader {
    private Integer m_projectID;
    private DataSource m_dataSource;
    private Connection m_connection;

    public Map<Integer, String> listProjects() throws MPXJException {
        return this.getReader().listProjects();
    }

    public ProjectFile read() throws MPXJException {
        MPD9DatabaseReader reader = this.getReader();
        reader.setProjectID(this.m_projectID);
        return reader.read();
    }

    public void setProjectID(int projectID) {
        this.m_projectID = projectID;
    }

    @Deprecated
    public void setPreserveNoteFormatting(boolean preserveNoteFormatting) {
    }

    public void setDataSource(DataSource dataSource) {
        this.m_dataSource = dataSource;
    }

    public void setConnection(Connection connection) {
        this.m_connection = connection;
    }

    @Override
    public ProjectFile read(File file) throws MPXJException {
        try {
            this.m_connection = this.getDatabaseConnection(file);
            this.m_projectID = 1;
            ProjectFile projectFile = this.read();
            return projectFile;
        }
        finally {
            AutoCloseableHelper.closeQuietly(this.m_connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ProjectFile> readAll(File file) throws MPXJException {
        try {
            this.m_connection = this.getDatabaseConnection(file);
            ArrayList<ProjectFile> result = new ArrayList<ProjectFile>();
            Set<Integer> ids = this.listProjects().keySet();
            Object object = ids.iterator();
            while (object.hasNext()) {
                Integer id;
                this.m_projectID = id = object.next();
                result.add(this.read());
            }
            object = result;
            return object;
        }
        finally {
            AutoCloseableHelper.closeQuietly(this.m_connection);
        }
    }

    private Connection getDatabaseConnection(File file) throws MPXJException {
        try {
            Class.forName("sun.jdbc.odbc.JdbcOdbcDriver");
            String url = "jdbc:odbc:DRIVER=Microsoft Access Driver (*.mdb);DBQ=" + file.getAbsolutePath();
            return DriverManager.getConnection(url);
        }
        catch (ClassNotFoundException ex) {
            throw new MPXJException("Failed to load JDBC driver", ex);
        }
        catch (SQLException ex) {
            throw new MPXJException("Failed to create connection", ex);
        }
    }

    private MPD9DatabaseReader getReader() {
        MPD9DatabaseReader reader = new MPD9DatabaseReader();
        reader.setDataSource(this.m_dataSource);
        reader.setConnection(this.m_connection);
        return reader;
    }
}

