/*
 * Decompiled with CFR 0.152.
 */
package org.opendatafoundation.data.spss;

import java.io.IOException;
import org.opendatafoundation.data.spss.SPSSAbstractRecordType;
import org.opendatafoundation.data.spss.SPSSFile;
import org.opendatafoundation.data.spss.SPSSFileException;

public class SPSSRecordType6
extends SPSSAbstractRecordType {
    int recordTypeCode;
    int numberOfLines;
    String[] line;

    @Override
    public void read(SPSSFile sPSSFile) throws IOException, SPSSFileException {
        this.fileLocation = sPSSFile.getFilePointer();
        this.recordTypeCode = sPSSFile.readSPSSInt();
        if (this.recordTypeCode != 6) {
            throw new SPSSFileException("Error reading variableRecord: bad record type [" + this.recordTypeCode + "]. Expecting Record Type 6.");
        }
        this.numberOfLines = sPSSFile.readSPSSInt();
        this.line = new String[this.numberOfLines];
        for (int i = 0; i < this.numberOfLines; ++i) {
            this.line[i] = sPSSFile.readSPSSString(80);
        }
    }

    @Override
    public String toString() {
        String string = "";
        string = string + "\nRECORD TYPE 6 - DOCUMENT RECORD";
        string = string + "\nLocation        : " + this.fileLocation;
        string = string + "\nRecord Type     : " + this.recordTypeCode;
        string = string + "\nNumber of lines : " + this.numberOfLines;
        for (int i = 0; i < this.numberOfLines; ++i) {
            string = string + this.line[i] + "\n";
        }
        return string;
    }
}

