/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.model.atompub;

import com.google.common.collect.Maps;
import com.google.gdata.model.AttributeKey;
import com.google.gdata.model.Element;
import com.google.gdata.model.ElementCreator;
import com.google.gdata.model.ElementKey;
import com.google.gdata.model.ElementMetadata;
import com.google.gdata.model.MetadataRegistry;
import com.google.gdata.model.QName;
import com.google.gdata.model.atom.Category;
import com.google.gdata.util.Namespaces;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Categories
extends Element {
    public static final ElementKey<Void, Categories> KEY = ElementKey.of(new QName(Namespaces.atomPubStandardNs, "categories"), Void.class, Categories.class);
    public static final AttributeKey<Fixed> FIXED = AttributeKey.of(new QName(null, "fixed"), Fixed.class);
    public static final AttributeKey<String> HREF = AttributeKey.of(new QName(null, "href"), String.class);
    public static final AttributeKey<String> SCHEME = AttributeKey.of(new QName(null, "scheme"), String.class);

    public static void registerMetadata(MetadataRegistry registry) {
        if (registry.isRegistered(KEY)) {
            return;
        }
        ElementCreator builder = registry.build(KEY);
        builder.addAttribute(FIXED);
        builder.addAttribute(HREF);
        builder.addAttribute(SCHEME);
        builder.addElement(Category.KEY).setCardinality(ElementMetadata.Cardinality.MULTIPLE);
    }

    public Categories() {
        super(KEY);
    }

    protected Categories(ElementKey<?, ? extends Categories> key) {
        super(key);
    }

    protected Categories(ElementKey<?, ? extends Categories> key, Element source) {
        super(key, source);
    }

    @Override
    public Categories lock() {
        return (Categories)super.lock();
    }

    public List<Category> getCategories() {
        return super.getElements(Category.KEY);
    }

    public Categories addCategory(Category category) {
        super.addElement(Category.KEY, (Element)category);
        return this;
    }

    public boolean removeCategory(Category category) {
        return super.removeElement(category);
    }

    public void clearCategories() {
        super.removeElement(Category.KEY);
    }

    public boolean hasCategories() {
        return super.hasElement(Category.KEY);
    }

    public Fixed getFixed() {
        return super.getAttributeValue(FIXED);
    }

    public Categories setFixed(Fixed fixed) {
        super.setAttributeValue(FIXED, (Object)fixed);
        return this;
    }

    public boolean hasFixed() {
        return super.hasAttribute(FIXED);
    }

    public String getHref() {
        return super.getAttributeValue(HREF);
    }

    public Categories setHref(String href) {
        super.setAttributeValue(HREF, (Object)href);
        return this;
    }

    public boolean hasHref() {
        return super.hasAttribute(HREF);
    }

    public String getScheme() {
        return super.getAttributeValue(SCHEME);
    }

    public Categories setScheme(String scheme) {
        super.setAttributeValue(SCHEME, (Object)scheme);
        return this;
    }

    public boolean hasScheme() {
        return super.hasAttribute(SCHEME);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Fixed {
        NO,
        YES;

        private static final Map<String, Fixed> VALUE_MAP;

        public String toString() {
            return this.name().toLowerCase();
        }

        public static Fixed fromString(String value) {
            return VALUE_MAP.get(value);
        }

        static {
            VALUE_MAP = Maps.newHashMap();
            for (Fixed value : Fixed.values()) {
                VALUE_MAP.put(value.toString(), value);
            }
        }
    }
}

