/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.synthetica.aluoxide;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Window;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;

public class GraphicsUtils
extends de.javasoft.plaf.synthetica.GraphicsUtils {
    private boolean textShadowEnabled = SyntheticaLookAndFeel.getBoolean((String)"SyntheticaAluOxide.textShadowEnabled", null, (boolean)true);
    private boolean useSimpleTextShadow = SyntheticaLookAndFeel.getBoolean((String)"SyntheticaAluOxide.useSimpleTextShadow", null, (boolean)true);
    private Color optionalForeground = new Color(0xE7E7E7);
    private Color optionalForeground_hover = new Color(0xFFFFFF);
    private Color optionalForeground_disabled = new Color(0x788088);

    public void paintText(SynthContext sc, Graphics g, String text, int x, int y, int mnemonicIndex) {
        JComponent c = sc.getComponent();
        String name = c.getName();
        Region region = sc.getRegion();
        boolean selected = (sc.getComponentState() & 0x200) > 0;
        boolean disabled = (sc.getComponentState() & 8) > 0;
        boolean hover = (sc.getComponentState() & 2) > 0;
        boolean pressed = (sc.getComponentState() & 4) > 0;
        Container cParent = c.getParent();
        Container grandParent = cParent == null ? null : cParent.getParent();
        JComponent parent = cParent instanceof JComponent ? (JComponent)cParent : null;
        JToolBar opaqueToolBar = null;
        boolean isMenuBarChild = parent instanceof JMenuBar;
        boolean isToolBarChild = parent instanceof JToolBar;
        boolean isStatusBarChild = false;
        Color paintColor = g.getColor();
        if ((isMenuBarChild || isToolBarChild || isStatusBarChild) && paintColor instanceof UIResource && parent.isOpaque()) {
            g.setColor(this.optionalForeground);
        } else if (isMenuBarChild && !(c instanceof JMenuItem) && paintColor instanceof UIResource) {
            g.setColor(this.optionalForeground);
        } else if (isToolBarChild && (opaqueToolBar = (JToolBar)SyntheticaLookAndFeel.findOpaqueParentOfClass(JToolBar.class, (Container)c, (boolean)false)) != null && paintColor instanceof UIResource) {
            g.setColor(this.optionalForeground);
        }
        if (region == Region.PROGRESS_BAR) {
            this.paintTextShadow(c, g, x, y, text, false, 5, -5, 1.0f, Color.WHITE, -2, -2, false, mnemonicIndex);
        } else if (region == Region.BUTTON || region == Region.TOGGLE_BUTTON) {
            if (pressed && !selected) {
                ++y;
            }
            if ((opaqueToolBar = (JToolBar)SyntheticaLookAndFeel.findOpaqueParentOfClass(JToolBar.class, (Container)c, (boolean)false)) != null && paintColor instanceof UIResource) {
                Color foreground = hover ? this.optionalForeground_hover : (disabled ? this.optionalForeground_disabled : this.optionalForeground);
                g.setColor(foreground);
            }
        }
        if (this.textShadowEnabled && ((Boolean)SyntheticaLookAndFeel.getClientProperty((String)"Synthetica.textShadowEnabled", (JComponent)c, (Object)this.textShadowEnabled)).booleanValue()) {
            if (region == Region.MENU && ((JMenu)c).isTopLevelMenu()) {
                Window w = SwingUtilities.getWindowAncestor(c);
                if (w != null && w.isActive()) {
                    this.paintDarkShadow(c, g, x, y, text, mnemonicIndex);
                }
            } else if (region == Region.MENU && selected) {
                this.paintBrightShadow(c, g, x, y, text, mnemonicIndex);
            } else if (c instanceof JMenuItem && hover) {
                this.paintBrightShadow(c, g, x, y, text, mnemonicIndex);
            } else if (region == Region.LABEL && "TableHeader.renderer".equals(name)) {
                this.paintBrightShadow(c, g, x, y, text, mnemonicIndex);
            } else if (region == Region.LABEL && -13421773 == c.getForeground().getRGB() && ("List.cellRenderer".equals(name) || "ComboBox.listRenderer".equals(name) || "Table.cellRenderer".equals(name) || "Tree.cellRenderer".equals(name))) {
                JTable table;
                boolean focused;
                boolean respectFocus = SyntheticaLookAndFeel.getBoolean((String)"Synthetica.cellRenderer.respectFocus", (Component)c, (boolean)false);
                boolean bl = respectFocus ? (grandParent != null ? grandParent.hasFocus() : false) : (focused = false);
                if ("Table.cellRenderer".equals(name) && respectFocus && grandParent instanceof JTable && (table = (JTable)grandParent).getCellEditor() != null) {
                    focused = true;
                }
                if (focused || "ComboBox.listRenderer".equals(name)) {
                    this.paintBrightShadow(c, g, x, y, text, mnemonicIndex);
                }
            } else if ((region == Region.BUTTON || region == Region.TOGGLE_BUTTON) && opaqueToolBar == null) {
                this.paintBrightShadow2(c, g, x, y, text, mnemonicIndex);
            } else if (region == Region.TABBED_PANE_TAB) {
                this.paintBrightShadow2(c, g, x, y, text, mnemonicIndex);
            }
        }
        super.paintText(sc, g, text, x, y, mnemonicIndex);
    }

    private void paintBrightShadow(JComponent c, Graphics g, int x, int y, String text, int mnemonicIndex) {
        this.paintShadow(c, g, x, y, text, false, 1, -2, 0.75f, Color.WHITE, 0, 1, mnemonicIndex);
    }

    private void paintBrightShadow2(JComponent c, Graphics g, int x, int y, String text, int mnemonicIndex) {
        this.paintShadow(c, g, x, y, text, false, 1, -2, 0.5f, Color.WHITE, 0, 1, mnemonicIndex);
    }

    private void paintDarkShadow(JComponent c, Graphics g, int x, int y, String text, int mnemonicIndex) {
        this.paintShadow(c, g, x, y, text, false, 1, -2, 1.0f, Color.BLACK, 0, 1, mnemonicIndex);
    }

    private void paintShadow(JComponent c, Graphics g, int x, int y, String text, boolean highQuality, int size, int distance, float opacity, Color color, int xOffset, int yOffset, int mnemonicIndex) {
        size = SyntheticaLookAndFeel.getInstance().scaleInteger(Integer.valueOf(size));
        distance = SyntheticaLookAndFeel.getInstance().scaleInteger(Integer.valueOf(distance));
        xOffset = SyntheticaLookAndFeel.getInstance().scaleInteger(Integer.valueOf(xOffset));
        yOffset = SyntheticaLookAndFeel.getInstance().scaleInteger(Integer.valueOf(yOffset));
        if (this.useSimpleTextShadow) {
            FontMetrics fm = g.getFontMetrics(c.getFont());
            Color col = g.getColor();
            g.setColor(new Color(color.getRed(), color.getGreen(), color.getBlue(), (int)(255.0f * opacity / 1.25f)));
            g.drawString(text, x + xOffset, y + yOffset + fm.getAscent());
            g.setColor(col);
        } else {
            this.paintTextShadow(c, g, x, y, text, highQuality, size, distance, opacity, color, xOffset, yOffset, false, mnemonicIndex);
        }
    }
}

